"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("./options");
class RepositoryInitializerTask {
    constructor(workingDirectory, commitOptions) {
        this.workingDirectory = workingDirectory;
        this.commitOptions = commitOptions;
    }
    toConfiguration() {
        return {
            name: options_1.RepositoryInitializerName,
            options: {
                commit: !!this.commitOptions,
                workingDirectory: this.workingDirectory,
                authorName: this.commitOptions && this.commitOptions.name,
                authorEmail: this.commitOptions && this.commitOptions.email,
                message: this.commitOptions && this.commitOptions.message,
            },
        };
    }
}
exports.RepositoryInitializerTask = RepositoryInitializerTask;
//# sourceMappingURL=data:application/json;base64,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