/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DevExpress from 'devextreme/bundles/dx.all';
import DxDiagram from 'devextreme/ui/diagram';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiCustomShapeComponent } from './nested/custom-shape-dxi';
/**
 * [tags] ctp The Diagram widget provides a visual interface to help you design new and modify existing diagrams. #include common-ctp-note with { component: "Diagram" }
 */
export declare class DxDiagramComponent extends DxComponent implements OnDestroy, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxDiagram;
    /**
     * Specifies the shortcut key that sets focus on the widget.
     */
    accessKey: string;
    /**
     * Specifies whether or not the widget changes its state when interacting with a user.
     */
    activeStateEnabled: boolean;
    /**
     * Specifies whether the Diagram widget automatically zooms the work area.
     */
    autoZoom: string;
    /**
     * Configures the context menu's settings.
     */
    contextMenu: {
        commands?: Array<string>;
        enabled?: boolean;
    };
    /**
     * Provide access to an array of custom shapes.
     */
    customShapes: Array<any | {
        allowEditImage?: boolean;
        allowEditText?: boolean;
        backgroundImageHeight?: number;
        backgroundImageLeft?: number;
        backgroundImageTop?: number;
        backgroundImageUrl?: string;
        backgroundImageWidth?: number;
        baseType?: string;
        category?: string;
        connectionPoints?: Array<any | {
            x?: number;
            y?: number;
        }>;
        defaultHeight?: number;
        defaultImageUrl?: string;
        defaultText?: string;
        defaultWidth?: number;
        imageHeight?: number;
        imageLeft?: number;
        imageTop?: number;
        imageWidth?: number;
        textHeight?: number;
        textLeft?: number;
        textTop?: number;
        textWidth?: number;
        title?: string;
        type?: string;
    }>;
    /**
     * Specifies whether the widget responds to user interaction.
     */
    disabled: boolean;
    /**
     * Allows you to bind the collection of diagram edges to a data source.
     */
    edges: {
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        fromExpr?: Function | string;
        fromLineEndExpr?: Function | string;
        fromPointIndexExpr?: Function | string;
        keyExpr?: Function | string;
        lineTypeExpr?: Function | string;
        lockedExpr?: Function | string;
        pointsExpr?: Function | string;
        styleExpr?: Function | string;
        textExpr?: Function | string;
        textStyleExpr?: Function | string;
        toExpr?: Function | string;
        toLineEndExpr?: Function | string;
        toPointIndexExpr?: Function | string;
        zIndexExpr?: Function | string;
    };
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Configures export settings.
     */
    export: {
        fileName?: string;
        proxyUrl?: string;
    };
    /**
     * Specifies whether the widget can be focused using keyboard navigation.
     */
    focusStateEnabled: boolean;
    /**
     * Specifies whether or not to display the widget in full-screen mode.
     */
    fullScreen: boolean;
    /**
     * Specifies the grid pitch.
     */
    gridSize: number | {
        items?: Array<number>;
        value?: number;
    };
    /**
     * Specifies the widget's height.
     */
    height: number | Function | string;
    /**
     * Specifies text for a hint that appears when a user pauses on the widget.
     */
    hint: string;
    /**
     * Specifies whether the widget changes its state when a user pauses on it.
     */
    hoverStateEnabled: boolean;
    /**
     * Allows you to bind the collection of diagram nodes to a data source.
     */
    nodes: {
        autoLayout?: string | {
            orientation?: string;
            type?: string;
        };
        childrenExpr?: Function | string;
        containerKeyExpr?: Function | string;
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        heightExpr?: Function | string;
        imageUrlExpr?: Function | string;
        itemsExpr?: Function | string;
        keyExpr?: Function | string;
        leftExpr?: Function | string;
        lockedExpr?: Function | string;
        parentKeyExpr?: Function | string;
        styleExpr?: Function | string;
        textExpr?: Function | string;
        textStyleExpr?: Function | string;
        topExpr?: Function | string;
        typeExpr?: Function | string;
        widthExpr?: Function | string;
        zIndexExpr?: Function | string;
    };
    /**
     * Specifies the color of a diagram page.
     */
    pageColor: string;
    /**
     * Specifies the page orientation.
     */
    pageOrientation: string;
    /**
     * Specifies a size of pages.
     */
    pageSize: {
        height?: number;
        items?: Array<any | {
            height?: number;
            text?: string;
            width?: number;
        }>;
        width?: number;
    };
    /**
     * Provides access to Properties panel settings.
     */
    propertiesPanel: {
        collapsible?: boolean;
        enabled?: boolean;
        groups?: Array<any | {
            commands?: Array<string>;
        }>;
    };
    /**
     * Specifies whether the diagram is read-only.
     */
    readOnly: boolean;
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies whether grid lines are visible.
     */
    showGrid: boolean;
    /**
     * Switch the Diagram widget to simple view mode.
     */
    simpleView: boolean;
    /**
     * Specifies whether diagram elements should snap to grid lines.
     */
    snapToGrid: boolean;
    /**
     * Specifies the number of the element when the Tab key is used for navigating.
     */
    tabIndex: number;
    /**
     * Provides access to toolbar settings.
     */
    toolbar: {
        commands?: Array<string>;
        visible?: boolean;
    };
    /**
     * Provides access to toolbox settings.
     */
    toolbox: {
        groups?: Array<any | string | {
            category?: string;
            displayMode?: string;
            expanded?: boolean;
            shapes?: Array<string>;
            title?: string;
        }>;
        visible?: boolean;
    };
    /**
     * Specifies the unit for measurement options (for example, defaultHeight, gridSize, leftExpr).
     */
    units: string;
    /**
     * Specifies the measurement unit that is displayed in user interface elements.
     */
    viewUnits: string;
    /**
     * Specifies whether the widget is visible.
     */
    visible: boolean;
    /**
     * Specifies the widget's width.
     */
    width: number | Function | string;
    /**
     * Specifies the zoom level.
     */
    zoomLevel: number | {
        items?: Array<number>;
        value?: number;
    };
    /**
     * A function that is executed when the widget's content is ready and each time the content is changed.
     */
    onContentReady: EventEmitter<any>;
    /**
     * A function that is executed when the diagram's data changes.
     */
    onDataChanged: EventEmitter<any>;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function used in JavaScript frameworks to save the widget instance.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    accessKeyChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    activeStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    autoZoomChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    contextMenuChange: EventEmitter<{
        commands?: Array<string>;
        enabled?: boolean;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    customShapesChange: EventEmitter<Array<any | {
        allowEditImage?: boolean;
        allowEditText?: boolean;
        backgroundImageHeight?: number;
        backgroundImageLeft?: number;
        backgroundImageTop?: number;
        backgroundImageUrl?: string;
        backgroundImageWidth?: number;
        baseType?: string;
        category?: string;
        connectionPoints?: Array<any | {
            x?: number;
            y?: number;
        }>;
        defaultHeight?: number;
        defaultImageUrl?: string;
        defaultText?: string;
        defaultWidth?: number;
        imageHeight?: number;
        imageLeft?: number;
        imageTop?: number;
        imageWidth?: number;
        textHeight?: number;
        textLeft?: number;
        textTop?: number;
        textWidth?: number;
        title?: string;
        type?: string;
    }>>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    disabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    edgesChange: EventEmitter<{
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        fromExpr?: Function | string;
        fromLineEndExpr?: Function | string;
        fromPointIndexExpr?: Function | string;
        keyExpr?: Function | string;
        lineTypeExpr?: Function | string;
        lockedExpr?: Function | string;
        pointsExpr?: Function | string;
        styleExpr?: Function | string;
        textExpr?: Function | string;
        textStyleExpr?: Function | string;
        toExpr?: Function | string;
        toLineEndExpr?: Function | string;
        toPointIndexExpr?: Function | string;
        zIndexExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    exportChange: EventEmitter<{
        fileName?: string;
        proxyUrl?: string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    focusStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    fullScreenChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    gridSizeChange: EventEmitter<number | {
        items?: Array<number>;
        value?: number;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    heightChange: EventEmitter<number | Function | string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    hintChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    hoverStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    nodesChange: EventEmitter<{
        autoLayout?: string | {
            orientation?: string;
            type?: string;
        };
        childrenExpr?: Function | string;
        containerKeyExpr?: Function | string;
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        heightExpr?: Function | string;
        imageUrlExpr?: Function | string;
        itemsExpr?: Function | string;
        keyExpr?: Function | string;
        leftExpr?: Function | string;
        lockedExpr?: Function | string;
        parentKeyExpr?: Function | string;
        styleExpr?: Function | string;
        textExpr?: Function | string;
        textStyleExpr?: Function | string;
        topExpr?: Function | string;
        typeExpr?: Function | string;
        widthExpr?: Function | string;
        zIndexExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    pageColorChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    pageOrientationChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    pageSizeChange: EventEmitter<{
        height?: number;
        items?: Array<any | {
            height?: number;
            text?: string;
            width?: number;
        }>;
        width?: number;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    propertiesPanelChange: EventEmitter<{
        collapsible?: boolean;
        enabled?: boolean;
        groups?: Array<any | {
            commands?: Array<string>;
        }>;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    readOnlyChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    showGridChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    simpleViewChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    snapToGridChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    tabIndexChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    toolbarChange: EventEmitter<{
        commands?: Array<string>;
        visible?: boolean;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    toolboxChange: EventEmitter<{
        groups?: Array<any | string | {
            category?: string;
            displayMode?: string;
            expanded?: boolean;
            shapes?: Array<string>;
            title?: string;
        }>;
        visible?: boolean;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    unitsChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    viewUnitsChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    visibleChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    widthChange: EventEmitter<number | Function | string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    zoomLevelChange: EventEmitter<number | {
        items?: Array<number>;
        value?: number;
    }>;
    customShapesChildren: QueryList<DxiCustomShapeComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxDiagram;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    setupChanges(prop: string, changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
}
export declare class DxDiagramModule {
}
