"use strict";
/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var platform_browser_1 = require("@angular/platform-browser");
var platform_browser_2 = require("@angular/platform-browser");
var core_1 = require("@angular/core");
var file_manager_1 = require("devextreme/ui/file_manager");
var component_1 = require("../core/component");
var template_host_1 = require("../core/template-host");
var integration_1 = require("../core/integration");
var template_1 = require("../core/template");
var nested_option_1 = require("../core/nested-option");
var watcher_helper_1 = require("../core/watcher-helper");
var iterable_differ_helper_1 = require("../core/iterable-differ-helper");
var context_menu_1 = require("./nested/context-menu");
var item_dxi_1 = require("./nested/item-dxi");
var item_view_1 = require("./nested/item-view");
var permissions_1 = require("./nested/permissions");
var toolbar_1 = require("./nested/toolbar");
var upload_1 = require("./nested/upload");
/**
 * [tags] ctp The FileManager is a widget that allows users to upload, select, and manage files and directories in different file storages. #include common-ctp-note with { component: "FileManager" }
 */
var DxFileManagerComponent = /** @class */ (function (_super) {
    __extends(DxFileManagerComponent, _super);
    function DxFileManagerComponent(elementRef, ngZone, templateHost, _watcherHelper, _idh, optionHost, transferState, platformId) {
        var _this = _super.call(this, elementRef, ngZone, templateHost, _watcherHelper, transferState, platformId) || this;
        _this._watcherHelper = _watcherHelper;
        _this._idh = _idh;
        _this._createEventEmitters([
            { subscribe: 'contentReady', emit: 'onContentReady' },
            { subscribe: 'currentDirectoryChanged', emit: 'onCurrentDirectoryChanged' },
            { subscribe: 'disposing', emit: 'onDisposing' },
            { subscribe: 'initialized', emit: 'onInitialized' },
            { subscribe: 'optionChanged', emit: 'onOptionChanged' },
            { subscribe: 'selectedFileOpened', emit: 'onSelectedFileOpened' },
            { emit: 'accessKeyChange' },
            { emit: 'activeStateEnabledChange' },
            { emit: 'allowedFileExtensionsChange' },
            { emit: 'contextMenuChange' },
            { emit: 'currentPathChange' },
            { emit: 'customizeDetailColumnsChange' },
            { emit: 'customizeThumbnailChange' },
            { emit: 'disabledChange' },
            { emit: 'elementAttrChange' },
            { emit: 'fileProviderChange' },
            { emit: 'focusStateEnabledChange' },
            { emit: 'heightChange' },
            { emit: 'hintChange' },
            { emit: 'hoverStateEnabledChange' },
            { emit: 'itemViewChange' },
            { emit: 'permissionsChange' },
            { emit: 'rootFolderNameChange' },
            { emit: 'rtlEnabledChange' },
            { emit: 'selectionModeChange' },
            { emit: 'tabIndexChange' },
            { emit: 'toolbarChange' },
            { emit: 'uploadChange' },
            { emit: 'visibleChange' },
            { emit: 'widthChange' }
        ]);
        _this._idh.setHost(_this);
        optionHost.setHost(_this);
        return _this;
    }
    Object.defineProperty(DxFileManagerComponent.prototype, "accessKey", {
        /**
         * Specifies the shortcut key that sets focus on the widget.
         */
        get: function () {
            return this._getOption('accessKey');
        },
        set: function (value) {
            this._setOption('accessKey', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "activeStateEnabled", {
        /**
         * Specifies whether or not the widget changes its state when interacting with a user.
         */
        get: function () {
            return this._getOption('activeStateEnabled');
        },
        set: function (value) {
            this._setOption('activeStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "allowedFileExtensions", {
        /**
         * Specifies the allowed upload file extensions.
         */
        get: function () {
            return this._getOption('allowedFileExtensions');
        },
        set: function (value) {
            this._setOption('allowedFileExtensions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "contextMenu", {
        /**
         * Configures the context menu settings.
         */
        get: function () {
            return this._getOption('contextMenu');
        },
        set: function (value) {
            this._setOption('contextMenu', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "currentPath", {
        /**
         * Specifies the path that is used when the FileManager is initialized.
         */
        get: function () {
            return this._getOption('currentPath');
        },
        set: function (value) {
            this._setOption('currentPath', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "customizeDetailColumns", {
        /**
         * Customizes columns in details view. Applies only if itemView.mode is "details".
         */
        get: function () {
            return this._getOption('customizeDetailColumns');
        },
        set: function (value) {
            this._setOption('customizeDetailColumns', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "customizeThumbnail", {
        /**
         * Allows you to provide custom icons to be used as thumbnails.
         */
        get: function () {
            return this._getOption('customizeThumbnail');
        },
        set: function (value) {
            this._setOption('customizeThumbnail', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "disabled", {
        /**
         * Specifies whether the widget responds to user interaction.
         */
        get: function () {
            return this._getOption('disabled');
        },
        set: function (value) {
            this._setOption('disabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "elementAttr", {
        /**
         * Specifies the attributes to be attached to the widget's root element.
         */
        get: function () {
            return this._getOption('elementAttr');
        },
        set: function (value) {
            this._setOption('elementAttr', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "fileProvider", {
        /**
         * Specifies the file provider.
         */
        get: function () {
            return this._getOption('fileProvider');
        },
        set: function (value) {
            this._setOption('fileProvider', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "focusStateEnabled", {
        /**
         * Specifies whether the widget can be focused using keyboard navigation.
         */
        get: function () {
            return this._getOption('focusStateEnabled');
        },
        set: function (value) {
            this._setOption('focusStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "height", {
        /**
         * Specifies the widget's height.
         */
        get: function () {
            return this._getOption('height');
        },
        set: function (value) {
            this._setOption('height', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "hint", {
        /**
         * Specifies text for a hint that appears when a user pauses on the widget.
         */
        get: function () {
            return this._getOption('hint');
        },
        set: function (value) {
            this._setOption('hint', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "hoverStateEnabled", {
        /**
         * Specifies whether the widget changes its state when a user pauses on it.
         */
        get: function () {
            return this._getOption('hoverStateEnabled');
        },
        set: function (value) {
            this._setOption('hoverStateEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "itemView", {
        /**
         * Configures the file and folder view.
         */
        get: function () {
            return this._getOption('itemView');
        },
        set: function (value) {
            this._setOption('itemView', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "permissions", {
        /**
         * Specifies actions that a user is allowed to perform on files and folders.
         */
        get: function () {
            return this._getOption('permissions');
        },
        set: function (value) {
            this._setOption('permissions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "rootFolderName", {
        /**
         * Specifies the root folder name.
         */
        get: function () {
            return this._getOption('rootFolderName');
        },
        set: function (value) {
            this._setOption('rootFolderName', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "rtlEnabled", {
        /**
         * Switches the widget to a right-to-left representation.
         */
        get: function () {
            return this._getOption('rtlEnabled');
        },
        set: function (value) {
            this._setOption('rtlEnabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "selectionMode", {
        /**
         * Specifies whether a user can select a single or multiple files and folders in the item view simultaneously.
         */
        get: function () {
            return this._getOption('selectionMode');
        },
        set: function (value) {
            this._setOption('selectionMode', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "tabIndex", {
        /**
         * Specifies the number of the element when the Tab key is used for navigating.
         */
        get: function () {
            return this._getOption('tabIndex');
        },
        set: function (value) {
            this._setOption('tabIndex', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "toolbar", {
        /**
         * Configures toolbar settings.
         */
        get: function () {
            return this._getOption('toolbar');
        },
        set: function (value) {
            this._setOption('toolbar', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "upload", {
        /**
         * Configures upload settings.
         */
        get: function () {
            return this._getOption('upload');
        },
        set: function (value) {
            this._setOption('upload', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "visible", {
        /**
         * Specifies whether the widget is visible.
         */
        get: function () {
            return this._getOption('visible');
        },
        set: function (value) {
            this._setOption('visible', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DxFileManagerComponent.prototype, "width", {
        /**
         * Specifies the widget's width.
         */
        get: function () {
            return this._getOption('width');
        },
        set: function (value) {
            this._setOption('width', value);
        },
        enumerable: true,
        configurable: true
    });
    DxFileManagerComponent.prototype._createInstance = function (element, options) {
        return new file_manager_1.default(element, options);
    };
    DxFileManagerComponent.prototype.ngOnDestroy = function () {
        this._destroyWidget();
    };
    DxFileManagerComponent.prototype.ngOnChanges = function (changes) {
        _super.prototype.ngOnChanges.call(this, changes);
        this.setupChanges('allowedFileExtensions', changes);
    };
    DxFileManagerComponent.prototype.setupChanges = function (prop, changes) {
        if (!(prop in this._optionsToUpdate)) {
            this._idh.setup(prop, changes);
        }
    };
    DxFileManagerComponent.prototype.ngDoCheck = function () {
        this._idh.doCheck('allowedFileExtensions');
        this._watcherHelper.checkWatchers();
        _super.prototype.ngDoCheck.call(this);
        _super.prototype.clearChangedOptions.call(this);
    };
    DxFileManagerComponent.prototype._setOption = function (name, value) {
        var isSetup = this._idh.setupSingle(name, value);
        var isChanged = this._idh.getChanges(name, value) !== null;
        if (isSetup || isChanged) {
            _super.prototype._setOption.call(this, name, value);
        }
    };
    DxFileManagerComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'dx-file-manager',
                    template: '',
                    providers: [
                        template_host_1.DxTemplateHost,
                        watcher_helper_1.WatcherHelper,
                        nested_option_1.NestedOptionHost,
                        iterable_differ_helper_1.IterableDifferHelper
                    ]
                },] },
    ];
    /** @nocollapse */
    DxFileManagerComponent.ctorParameters = function () { return [
        { type: core_1.ElementRef },
        { type: core_1.NgZone },
        { type: template_host_1.DxTemplateHost },
        { type: watcher_helper_1.WatcherHelper },
        { type: iterable_differ_helper_1.IterableDifferHelper },
        { type: nested_option_1.NestedOptionHost },
        { type: platform_browser_2.TransferState },
        { type: undefined, decorators: [{ type: core_1.Inject, args: [core_1.PLATFORM_ID,] }] }
    ]; };
    DxFileManagerComponent.propDecorators = {
        accessKey: [{ type: core_1.Input }],
        activeStateEnabled: [{ type: core_1.Input }],
        allowedFileExtensions: [{ type: core_1.Input }],
        contextMenu: [{ type: core_1.Input }],
        currentPath: [{ type: core_1.Input }],
        customizeDetailColumns: [{ type: core_1.Input }],
        customizeThumbnail: [{ type: core_1.Input }],
        disabled: [{ type: core_1.Input }],
        elementAttr: [{ type: core_1.Input }],
        fileProvider: [{ type: core_1.Input }],
        focusStateEnabled: [{ type: core_1.Input }],
        height: [{ type: core_1.Input }],
        hint: [{ type: core_1.Input }],
        hoverStateEnabled: [{ type: core_1.Input }],
        itemView: [{ type: core_1.Input }],
        permissions: [{ type: core_1.Input }],
        rootFolderName: [{ type: core_1.Input }],
        rtlEnabled: [{ type: core_1.Input }],
        selectionMode: [{ type: core_1.Input }],
        tabIndex: [{ type: core_1.Input }],
        toolbar: [{ type: core_1.Input }],
        upload: [{ type: core_1.Input }],
        visible: [{ type: core_1.Input }],
        width: [{ type: core_1.Input }],
        onContentReady: [{ type: core_1.Output }],
        onCurrentDirectoryChanged: [{ type: core_1.Output }],
        onDisposing: [{ type: core_1.Output }],
        onInitialized: [{ type: core_1.Output }],
        onOptionChanged: [{ type: core_1.Output }],
        onSelectedFileOpened: [{ type: core_1.Output }],
        accessKeyChange: [{ type: core_1.Output }],
        activeStateEnabledChange: [{ type: core_1.Output }],
        allowedFileExtensionsChange: [{ type: core_1.Output }],
        contextMenuChange: [{ type: core_1.Output }],
        currentPathChange: [{ type: core_1.Output }],
        customizeDetailColumnsChange: [{ type: core_1.Output }],
        customizeThumbnailChange: [{ type: core_1.Output }],
        disabledChange: [{ type: core_1.Output }],
        elementAttrChange: [{ type: core_1.Output }],
        fileProviderChange: [{ type: core_1.Output }],
        focusStateEnabledChange: [{ type: core_1.Output }],
        heightChange: [{ type: core_1.Output }],
        hintChange: [{ type: core_1.Output }],
        hoverStateEnabledChange: [{ type: core_1.Output }],
        itemViewChange: [{ type: core_1.Output }],
        permissionsChange: [{ type: core_1.Output }],
        rootFolderNameChange: [{ type: core_1.Output }],
        rtlEnabledChange: [{ type: core_1.Output }],
        selectionModeChange: [{ type: core_1.Output }],
        tabIndexChange: [{ type: core_1.Output }],
        toolbarChange: [{ type: core_1.Output }],
        uploadChange: [{ type: core_1.Output }],
        visibleChange: [{ type: core_1.Output }],
        widthChange: [{ type: core_1.Output }]
    };
    return DxFileManagerComponent;
}(component_1.DxComponent));
exports.DxFileManagerComponent = DxFileManagerComponent;
var DxFileManagerModule = /** @class */ (function () {
    function DxFileManagerModule() {
    }
    DxFileManagerModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [
                        context_menu_1.DxoContextMenuModule,
                        item_dxi_1.DxiItemModule,
                        item_view_1.DxoItemViewModule,
                        permissions_1.DxoPermissionsModule,
                        toolbar_1.DxoToolbarModule,
                        upload_1.DxoUploadModule,
                        integration_1.DxIntegrationModule,
                        template_1.DxTemplateModule,
                        platform_browser_1.BrowserTransferStateModule
                    ],
                    declarations: [
                        DxFileManagerComponent
                    ],
                    exports: [
                        DxFileManagerComponent,
                        context_menu_1.DxoContextMenuModule,
                        item_dxi_1.DxiItemModule,
                        item_view_1.DxoItemViewModule,
                        permissions_1.DxoPermissionsModule,
                        toolbar_1.DxoToolbarModule,
                        upload_1.DxoUploadModule,
                        template_1.DxTemplateModule
                    ]
                },] },
    ];
    return DxFileManagerModule;
}());
exports.DxFileManagerModule = DxFileManagerModule;
//# sourceMappingURL=file-manager.js.map