/*!
 * devextreme-angular
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file in the root of the project for details.
 *
 * https://github.com/DevExpress/devextreme-angular
 */
import { TransferState } from '@angular/platform-browser';
import { ElementRef, NgZone, OnDestroy, EventEmitter, OnChanges, DoCheck, SimpleChanges, QueryList } from '@angular/core';
import DevExpress from 'devextreme/bundles/dx.all';
import DxGantt from 'devextreme/ui/gantt';
import { DxComponent } from '../core/component';
import { DxTemplateHost } from '../core/template-host';
import { NestedOptionHost } from '../core/nested-option';
import { WatcherHelper } from '../core/watcher-helper';
import { IterableDifferHelper } from '../core/iterable-differ-helper';
import { DxiColumnComponent } from './nested/column-dxi';
/**
 * [tags] ctp The Gantt is a widget that displays the task flow and dependencies between tasks. #include common-ctp-note with { component: "Gantt" }
 */
export declare class DxGanttComponent extends DxComponent implements OnDestroy, OnChanges, DoCheck {
    private _watcherHelper;
    private _idh;
    instance: DxGantt;
    /**
     * Specifies the shortcut key that sets focus on the widget.
     */
    accessKey: string;
    /**
     * Specifies whether or not the widget changes its state when interacting with a user.
     */
    activeStateEnabled: boolean;
    /**
     * Specifies whether users can select tasks in the Gantt.
     */
    allowSelection: boolean;
    /**
     * An array of columns in the Gantt.
     */
    columns: Array<DevExpress.ui.dxTreeListColumn | string>;
    /**
     * Configures dependencies.
     */
    dependencies: {
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        predecessorIdExpr?: Function | string;
        successorIdExpr?: Function | string;
        typeExpr?: Function | string;
    };
    /**
     * Specifies whether the widget responds to user interaction.
     */
    disabled: boolean;
    /**
     * Configures edit options.
     */
    editing: {
        allowDependencyAdding?: boolean;
        allowDependencyDeleting?: boolean;
        allowDependencyUpdating?: boolean;
        allowResourceAdding?: boolean;
        allowResourceDeleting?: boolean;
        allowResourceUpdating?: boolean;
        allowTaskAdding?: boolean;
        allowTaskDeleting?: boolean;
        allowTaskUpdating?: boolean;
        enabled?: boolean;
    };
    /**
     * Specifies the attributes to be attached to the widget's root element.
     */
    elementAttr: any;
    /**
     * Specifies whether the widget can be focused using keyboard navigation.
     */
    focusStateEnabled: boolean;
    /**
     * Specifies the widget's height.
     */
    height: number | Function | string;
    /**
     * Specifies text for a hint that appears when a user pauses on the widget.
     */
    hint: string;
    /**
     * Specifies whether the widget changes its state when a user pauses on it.
     */
    hoverStateEnabled: boolean;
    /**
     * Configures resource assignments.
     */
    resourceAssignments: {
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        resourceIdExpr?: Function | string;
        taskIdExpr?: Function | string;
    };
    /**
     * Configures task resources.
     */
    resources: {
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        textExpr?: Function | string;
    };
    /**
     * Switches the widget to a right-to-left representation.
     */
    rtlEnabled: boolean;
    /**
     * Specifies the zoom level of tasks in the Gantt chart.
     */
    scaleType: string;
    /**
     * Allows you to select a row or determine which row is selected.
     */
    selectedRowKey: any;
    /**
     * Specifies whether to display task resources.
     */
    showResources: boolean;
    /**
     * Specifies whether to show/hide horizontal faint lines that separate tasks.
     */
    showRowLines: boolean;
    /**
     * Specifies the number of the element when the Tab key is used for navigating.
     */
    tabIndex: number;
    /**
     * Specifies the width of the task list in pixels.
     */
    taskListWidth: number;
    /**
     * Configures tasks.
     */
    tasks: {
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        endExpr?: Function | string;
        keyExpr?: Function | string;
        parentIdExpr?: Function | string;
        progressExpr?: Function | string;
        startExpr?: Function | string;
        titleExpr?: Function | string;
    };
    /**
     * Specifies a task's title position.
     */
    taskTitlePosition: string;
    /**
     * Specifies whether the widget is visible.
     */
    visible: boolean;
    /**
     * Specifies the widget's width.
     */
    width: number | Function | string;
    /**
     * A function that is executed when the widget's content is ready and each time the content is changed.
     */
    onContentReady: EventEmitter<any>;
    /**
     * A function that is executed before the widget is disposed of.
     */
    onDisposing: EventEmitter<any>;
    /**
     * A function used in JavaScript frameworks to save the widget instance.
     */
    onInitialized: EventEmitter<any>;
    /**
     * A function that is executed after a widget option is changed.
     */
    onOptionChanged: EventEmitter<any>;
    /**
     * A function that is executed after users select a task or clear its selection.
     */
    onSelectionChanged: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    accessKeyChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    activeStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    allowSelectionChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    columnsChange: EventEmitter<Array<DevExpress.ui.dxTreeListColumn | string>>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    dependenciesChange: EventEmitter<{
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        predecessorIdExpr?: Function | string;
        successorIdExpr?: Function | string;
        typeExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    disabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    editingChange: EventEmitter<{
        allowDependencyAdding?: boolean;
        allowDependencyDeleting?: boolean;
        allowDependencyUpdating?: boolean;
        allowResourceAdding?: boolean;
        allowResourceDeleting?: boolean;
        allowResourceUpdating?: boolean;
        allowTaskAdding?: boolean;
        allowTaskDeleting?: boolean;
        allowTaskUpdating?: boolean;
        enabled?: boolean;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    elementAttrChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    focusStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    heightChange: EventEmitter<number | Function | string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    hintChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    hoverStateEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    resourceAssignmentsChange: EventEmitter<{
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        resourceIdExpr?: Function | string;
        taskIdExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    resourcesChange: EventEmitter<{
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        keyExpr?: Function | string;
        textExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    rtlEnabledChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    scaleTypeChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    selectedRowKeyChange: EventEmitter<any>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    showResourcesChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    showRowLinesChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    tabIndexChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    taskListWidthChange: EventEmitter<number>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    tasksChange: EventEmitter<{
        dataSource?: DevExpress.data.DataSource | DevExpress.data.DataSourceOptions | Array<any>;
        endExpr?: Function | string;
        keyExpr?: Function | string;
        parentIdExpr?: Function | string;
        progressExpr?: Function | string;
        startExpr?: Function | string;
        titleExpr?: Function | string;
    }>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    taskTitlePositionChange: EventEmitter<string>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    visibleChange: EventEmitter<boolean>;
    /**
     * This member supports the internal infrastructure and is not intended to be used directly from your code.
     */
    widthChange: EventEmitter<number | Function | string>;
    columnsChildren: QueryList<DxiColumnComponent>;
    constructor(elementRef: ElementRef, ngZone: NgZone, templateHost: DxTemplateHost, _watcherHelper: WatcherHelper, _idh: IterableDifferHelper, optionHost: NestedOptionHost, transferState: TransferState, platformId: any);
    protected _createInstance(element: any, options: any): DxGantt;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    setupChanges(prop: string, changes: SimpleChanges): void;
    ngDoCheck(): void;
    _setOption(name: string, value: any): void;
}
export declare class DxGanttModule {
}
