"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const fs_1 = require("fs");
const path_1 = require("path");
const child_process_1 = require("child_process");
function default_1(options) {
    const rules = [
        (0, schematics_1.schematic)('install', {
            dxversion: options.dxversion,
            project: options.project
        }),
        (0, schematics_1.schematic)('add-layout', {
            layout: options.layout,
            resolveConflicts: options.resolveConflicts,
            project: options.project,
            skipInstall: true,
            updateBudgets: options.updateBudgets,
            globalNgCliVersion: options.globalNgCliVersion
        }),
        // schematics installed packages with flag --ignore-scripts
        // @angular/cli@14 add option allowScript to NodePackageInstallTask
        (host) => {
            postinstallScripts();
            return host;
        }
    ];
    if (!options.empty) {
        rules.push((0, schematics_1.schematic)('add-sample-views', {
            project: options.project
        }));
    }
    return (0, schematics_1.chain)(rules);
}
exports.default = default_1;
const postinstallScripts = () => {
    const isWin = /^win/.test(process.platform);
    const sassEmbeddedPath = (0, path_1.resolve)('node_modules', 'sass-embedded');
    const sassVendorPath = (0, path_1.join)(sassEmbeddedPath, 'dist', 'lib', 'src', 'vendor', 'dart-sass-embedded');
    if (!(0, fs_1.existsSync)(sassVendorPath)) {
        (0, child_process_1.spawnSync)('npm', ['run', 'postinstall'], {
            cwd: (0, path_1.resolve)((0, path_1.join)('node_modules', 'sass-embedded')),
            windowsVerbatimArguments: true,
            shell: isWin ? false : true
        });
    }
};
//# sourceMappingURL=index.js.map