"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const ast_utils_1 = require("@schematics/angular/utility/ast-utils");
const add_view_1 = require("../add-view");
const project_1 = require("../utility/project");
const string_1 = require("../utility/string");
const change_1 = require("../utility/change");
const source_1 = require("../utility/source");
const sampleViewOptions = [
    {
        name: 'home',
        componentName: 'HomeComponent',
        relativePath: './pages/home/home.component'
    }, {
        name: 'profile',
        componentName: 'ProfileComponent',
        relativePath: './pages/profile/profile.component'
    }, {
        name: 'tasks',
        componentName: 'TasksComponent',
        relativePath: './pages/tasks/tasks.component'
    }
];
const devextremeOptions = [
    {
        componentName: 'DxDataGridModule',
        relativePath: 'devextreme-angular'
    }, {
        componentName: 'DxFormModule',
        relativePath: 'devextreme-angular'
    }
];
const navigations = [
    `  {
    text: 'Home',
    path: '/home',
    icon: 'home'
  }`,
    `  {
    text: 'Examples',
    icon: 'folder',
    items: [
      {
        text: 'Profile',
        path: '/profile'
      },
      {
        text: 'Tasks',
        path: '/tasks'
      }
    ]
  }`
];
function addImportsToRoutingModule(isView, routingPath, options) {
    return (host) => {
        const source = (0, source_1.getSourceFile)(host, routingPath);
        if (!source) {
            return host;
        }
        let changes;
        if (isView) {
            changes = (0, ast_utils_1.addDeclarationToModule)(source, routingPath, options.componentName, options.relativePath);
        }
        else {
            changes = (0, ast_utils_1.addImportToModule)(source, routingPath, options.componentName, options.relativePath);
        }
        return (0, change_1.applyChanges)(host, changes, routingPath);
    };
}
function addDefaultNavigation(rootPath) {
    return (host) => {
        const navigationPath = rootPath + 'app-navigation.ts';
        navigations.forEach((navigation) => {
            const navigationSource = (0, source_1.getSourceFile)(host, navigationPath);
            (0, change_1.insertItemToArray)(host, navigationPath, navigationSource, navigation, { location: 'end' });
        });
        return host;
    };
}
function default_1(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const project = yield (0, project_1.getProjectName)(host, options.project);
        const rootPath = yield (0, project_1.getApplicationPath)(host, project);
        const routingPath = rootPath + 'app-routing.module.ts';
        const rules = [];
        const templateSource = (0, schematics_1.apply)((0, schematics_1.url)('./files'), [
            (0, schematics_1.template)({
                project: (0, string_1.humanize)(project)
            }),
            (0, schematics_1.move)(rootPath)
        ]);
        rules.push((0, schematics_1.mergeWith)(templateSource));
        sampleViewOptions.forEach((viewOptions) => {
            rules.push((0, add_view_1.addViewToRouting)({ name: viewOptions.name, project, module: 'app-routing' }));
            rules.push(addImportsToRoutingModule(true, routingPath, viewOptions));
        });
        devextremeOptions.forEach((moduleOptions) => {
            rules.push(addImportsToRoutingModule(false, routingPath, moduleOptions));
        });
        rules.push(addDefaultNavigation(rootPath));
        return (0, schematics_1.chain)(rules);
    });
}
exports.default = default_1;
//# sourceMappingURL=index.js.map