"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const testing_1 = require("@angular-devkit/schematics/testing");
const path = require("path");
const collectionPath = path.join(__dirname, '../collection.json');
describe('sample views', () => {
    const appOptions = {
        name: 'testApp',
        projectRoot: '',
        inlineStyle: false,
        inlineTemplate: false,
        routing: true,
        style: 'css',
        skipTests: false,
        skipPackageJson: false
    };
    const workspaceOptions = {
        name: 'workspace',
        version: '6.0.0'
    };
    const sampleViewsOptions = {
        project: 'testApp'
    };
    const angularSchematicsCollection = require.resolve('../../node_modules/@schematics/angular/collection.json');
    const schematicRunner = new testing_1.SchematicTestRunner('@schematics/angular', angularSchematicsCollection);
    let appTree;
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        appTree = yield schematicRunner.runSchematicAsync('workspace', workspaceOptions).toPromise();
        appTree = yield schematicRunner.runSchematicAsync('application', appOptions, appTree).toPromise();
    }));
    it('should add sample views', () => __awaiter(void 0, void 0, void 0, function* () {
        const runner = new testing_1.SchematicTestRunner('schematics', collectionPath);
        let tree = yield runner.runSchematicAsync('add-layout', { layout: 'side-nav-outer-toolbar' }, appTree).toPromise();
        tree = yield runner.runSchematicAsync('add-sample-views', sampleViewsOptions, tree).toPromise();
        const moduleContent = tree.readContent('/src/app/app-routing.module.ts');
        expect(moduleContent).toMatch(/component: HomeComponent/);
        expect(moduleContent).toMatch(/path: 'home'/);
        expect(moduleContent).toMatch(/import { HomeComponent } from /);
        expect(moduleContent).toMatch(/declarations:\s\[\n*\s*HomeComponent/);
        const navigationContent = tree.readContent('/src/app/app-navigation.ts');
        expect(navigationContent).toMatch(/text: 'Home'/);
        expect(navigationContent).toContain(`export const navigation = [
  {
    text: 'Home',
    path: '/home',
    icon: 'home'
  },
  {
    text: 'Examples',
    icon: 'folder',
    items: [
      {
        text: 'Profile',
        path: '/profile'
      },
      {
        text: 'Tasks',
        path: '/tasks'
      }
    ]
  }
];`);
    }));
});
//# sourceMappingURL=index_spec.js.map