"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addViewToRouting = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const find_module_1 = require("@schematics/angular/utility/find-module");
const change_1 = require("../utility/change");
const routing_1 = require("../utility/routing");
const source_1 = require("../utility/source");
const core_1 = require("@angular-devkit/core");
const project_1 = require("../utility/project");
const string_1 = require("../utility/string");
function getPathToFile(host, projectName, moduleName) {
    return __awaiter(this, void 0, void 0, function* () {
        const rootPath = yield (0, project_1.getApplicationPath)(host, projectName);
        try {
            return (0, find_module_1.findModuleFromOptions)(host, { name: moduleName, path: rootPath, module: moduleName });
        }
        catch (error) {
            return;
        }
    });
}
function addViewToNavigation(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const navigationName = 'app-navigation';
        const navigationFilePath = yield getPathToFile(host, options.project, navigationName);
        if (!navigationFilePath) {
            return;
        }
        const source = (0, source_1.getSourceFile)(host, navigationFilePath);
        const pagePath = core_1.strings.dasherize(options.name);
        const name = core_1.strings.dasherize((0, core_1.basename)((0, core_1.normalize)(options.name)));
        const title = (0, string_1.humanize)(name);
        const navigationItem = `  {
    text: '${title}',
    path: '/${pagePath}',
    icon: '${options.icon}'
  }`;
        (0, change_1.insertItemToArray)(host, navigationFilePath, source, navigationItem, { location: 'end' });
        return host;
    });
}
function addRedirectRoute(host, routingModulePath, page) {
    const source = (0, source_1.getSourceFile)(host, routingModulePath);
    const content = source.getText();
    if (content.match(/path:\s*'\*\*'/g)) {
        return;
    }
    const routes = (0, routing_1.findRoutesInSource)(source);
    const redirectRoute = `  {
    path: '**',
    redirectTo: '${core_1.strings.dasherize(page)}'
  }`;
    (0, change_1.insertItemToArray)(host, routingModulePath, routes, redirectRoute, { location: 'end' });
}
function addViewToRouting(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const routingModulePath = yield getPathToFile(host, options.project, options.module);
        if (!routingModulePath) {
            throw new schematics_1.SchematicsException('Specified module does not exist.');
        }
        addRedirectRoute(host, routingModulePath, options.name);
        const source = (0, source_1.getSourceFile)(host, routingModulePath);
        const routes = (0, routing_1.findRoutesInSource)(source);
        if (!routes) {
            throw new schematics_1.SchematicsException('No routes found.');
        }
        if (!(0, routing_1.hasComponentInRoutes)(routes, options.name)) {
            const route = (0, routing_1.getRoute)(options.name);
            (0, change_1.insertItemToArray)(host, routingModulePath, routes, route);
        }
        return host;
    });
}
exports.addViewToRouting = addViewToRouting;
function getPathForView(name) {
    if (name.includes('/')) {
        return name;
    }
    return 'pages/' + name;
}
function getModuleName(addRoute, moduleName) {
    if (!moduleName && addRoute) {
        return 'app-routing';
    }
    return moduleName;
}
function addContentToView(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const name = core_1.strings.dasherize((0, core_1.basename)((0, core_1.normalize)(options.name)));
        const path = `${(0, core_1.dirname)(options.name)}/${name}`;
        const title = (0, string_1.humanize)(name);
        const componentPath = `/${yield (0, project_1.getApplicationPath)(host, options.project)}${path}/${name}.component.html`;
        if (host.exists(componentPath)) {
            host.overwrite(componentPath, `<h2 class="content-block">${title}</h2>
<div class="content-block">
    <div class="dx-card responsive-paddings">Put your content here</div>
</div>
`);
        }
        return host;
    });
}
function default_1(options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const addRoute = options.addRoute;
        const project = yield (0, project_1.getProjectName)(host, options.project);
        const module = getModuleName(addRoute, options.module);
        const name = getPathForView(options.name);
        const rules = [(0, schematics_1.externalSchematic)('@schematics/angular', 'component', {
                name,
                project,
                module,
                skipTests: options.skipTests,
                inlineStyle: options.inlineStyle,
                prefix: options.prefix
            }),
            addContentToView({ name, project })
        ];
        if (addRoute) {
            rules.push(addViewToRouting({ name, project, module }));
            rules.push(addViewToNavigation({ name, icon: options.icon, project }));
        }
        return (0, schematics_1.chain)(rules);
    });
}
exports.default = default_1;
//# sourceMappingURL=index.js.map