"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const styles_1 = require("../utility/styles");
const dependencies_1 = require("@schematics/angular/utility/dependencies");
const latest_versions_1 = require("../utility/latest-versions");
const modify_json_file_1 = require("../utility/modify-json-file");
const project_1 = require("../utility/project");
const patch_1 = require("../utility/patch");
function default_1(options) {
    return (0, schematics_1.chain)([
        (host) => addDevExtremeDependency(host, { dxversion: options.dxversion }),
        (host) => addDevExtremeCSS(host, { project: options.project }),
        (host) => reqisterJSZip(host),
        (_, context) => {
            context.addTask(new patch_1.PatchNodePackageInstallTask());
        },
    ]);
}
exports.default = default_1;
function addDevExtremeDependency(host, options) {
    (0, dependencies_1.addPackageJsonDependency)(host, {
        type: dependencies_1.NodeDependencyType.Default,
        name: 'devextreme',
        version: options.dxversion || latest_versions_1.latestVersions['devextreme']
    });
    (0, dependencies_1.addPackageJsonDependency)(host, {
        type: dependencies_1.NodeDependencyType.Default,
        name: 'devextreme-angular',
        version: options.dxversion || latest_versions_1.latestVersions['devextreme-angular']
    });
    (0, dependencies_1.addPackageJsonDependency)(host, {
        type: dependencies_1.NodeDependencyType.Dev,
        name: 'devextreme-cli',
        version: latest_versions_1.latestVersions['devextreme-cli']
    });
    (0, dependencies_1.addPackageJsonDependency)(host, {
        type: dependencies_1.NodeDependencyType.Dev,
        name: 'devextreme-themebuilder',
        version: options.dxversion || latest_versions_1.latestVersions['devextreme']
    });
    return host;
}
function addDevExtremeCSS(host, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const projectName = yield (0, project_1.getProjectName)(host, options.project);
        (0, modify_json_file_1.modifyJSONFile)(host, './angular.json', config => {
            return (0, styles_1.addStylesToApp)(projectName, config);
        });
        return host;
    });
}
function reqisterJSZip(host) {
    (0, modify_json_file_1.modifyJSONFile)(host, './tsconfig.app.json', config => {
        const compilerOptions = config['compilerOptions'];
        let paths = compilerOptions['paths'];
        if (!paths) {
            paths = {};
        }
        if (!paths['jszip']) {
            paths['jszip'] = ['node_modules/jszip/dist/jszip.min.js'];
        }
        compilerOptions['paths'] = paths;
        return config;
    });
    return host;
}
//# sourceMappingURL=index.js.map