"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.modifyJSONFile = exports.parseJson = void 0;
const parseJson = (str) => {
    return JSON.parse(str.replace(/\/\*[\S\s]+?\*\/\r?\n/g, ''));
};
exports.parseJson = parseJson;
function modifyJSONFile(host, path, callback) {
    const serializedConfig = host.read(path).toString();
    let obj = (0, exports.parseJson)(serializedConfig);
    obj = callback(obj);
    host.overwrite(path, `${JSON.stringify(obj, null, 2)}\n`);
    return host;
}
exports.modifyJSONFile = modifyJSONFile;
//# sourceMappingURL=modify-json-file.js.map