"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findRoutesInSource = exports.getRoute = exports.hasComponentInRoutes = void 0;
const typescript_1 = require("@schematics/angular/third_party/github.com/Microsoft/TypeScript/lib/typescript");
const core_1 = require("@angular-devkit/core");
function getRouteComponentName(pageName) {
    return `${core_1.strings.classify((0, core_1.basename)((0, core_1.normalize)(pageName)))}Component`;
}
function hasComponentInRoutes(routes, name) {
    const routesText = routes.getText();
    const componentName = getRouteComponentName(name);
    return routesText.indexOf(componentName) !== -1;
}
exports.hasComponentInRoutes = hasComponentInRoutes;
function getRoute(name) {
    return `  {
    path: '${core_1.strings.dasherize(name)}',
    component: ${getRouteComponentName(name)},
    canActivate: [ AuthGuardService ]
  }`;
}
exports.getRoute = getRoute;
function isRouteVariable(node, text) {
    return node.kind === typescript_1.SyntaxKind.VariableStatement &&
        text.search(/\:\s*Routes/) !== -1;
}
function findRoutesInSource(source) {
    // TODO: try to use ast-utils/findNodes
    return source.forEachChild((node) => {
        const text = node.getText();
        if (isRouteVariable(node, text)) {
            return node;
        }
    });
}
exports.findRoutesInSource = findRoutesInSource;
//# sourceMappingURL=routing.js.map