/**
 * DevExtreme (ui/scheduler/tooltip_strategies/tooltipStrategyBase.js)
 * Version: 19.2.3
 * Build date: Tue Oct 22 2019
 *
 * Copyright (c) 2012 - 2019 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TooltipStrategyBase = exports.createDefaultTooltipTemplate = void 0;
var _createClass = function() {
    function defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) {
                descriptor.writable = true
            }
            Object.defineProperty(target, descriptor.key, descriptor)
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) {
            defineProperties(Constructor.prototype, protoProps)
        }
        if (staticProps) {
            defineProperties(Constructor, staticProps)
        }
        return Constructor
    }
}();
var _button = require("../../button");
var _button2 = _interopRequireDefault(_button);
var _date = require("../../../core/utils/date");
var _date2 = _interopRequireDefault(_date);
var _function_template = require("../../../core/templates/function_template");
var _renderer = require("../../../core/renderer");
var _renderer2 = _interopRequireDefault(_renderer);
var _uiList = require("../../list/ui.list.edit");
var _uiList2 = _interopRequireDefault(_uiList);
var _extend = require("../../../core/utils/extend");

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        "default": obj
    }
}

function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function")
    }
}
var TOOLTIP_APPOINTMENT_ITEM = "dx-tooltip-appointment-item",
    TOOLTIP_APPOINTMENT_ITEM_CONTENT = TOOLTIP_APPOINTMENT_ITEM + "-content",
    TOOLTIP_APPOINTMENT_ITEM_CONTENT_SUBJECT = TOOLTIP_APPOINTMENT_ITEM + "-content-subject",
    TOOLTIP_APPOINTMENT_ITEM_CONTENT_DATE = TOOLTIP_APPOINTMENT_ITEM + "-content-date",
    TOOLTIP_APPOINTMENT_ITEM_MARKER = TOOLTIP_APPOINTMENT_ITEM + "-marker",
    TOOLTIP_APPOINTMENT_ITEM_MARKER_BODY = TOOLTIP_APPOINTMENT_ITEM + "-marker-body",
    TOOLTIP_APPOINTMENT_ITEM_DELETE_BUTTON_CONTAINER = TOOLTIP_APPOINTMENT_ITEM + "-delete-button-container",
    TOOLTIP_APPOINTMENT_ITEM_DELETE_BUTTON = TOOLTIP_APPOINTMENT_ITEM + "-delete-button";
var createDefaultTooltipTemplate = exports.createDefaultTooltipTemplate = function(template, data, targetData, index) {
    return new _function_template.FunctionTemplate(function(options) {
        return template.render({
            model: {
                appointmentData: data,
                targetedAppointmentData: targetData
            },
            container: options.container,
            index: index
        })
    })
};
var TooltipStrategyBase = exports.TooltipStrategyBase = function() {
    function TooltipStrategyBase(scheduler) {
        _classCallCheck(this, TooltipStrategyBase);
        this.scheduler = scheduler;
        this.tooltip = null
    }
    _createClass(TooltipStrategyBase, [{
        key: "show",
        value: function(target, dataList, isSingleItemBehavior) {
            if (this._canShowTooltip(target, dataList)) {
                this.hide();
                this._showCore(target, dataList, isSingleItemBehavior)
            }
        }
    }, {
        key: "_showCore",
        value: function(target, dataList, isSingleItemBehavior) {
            var _this = this;
            if (!this.tooltip) {
                this.tooltip = this._createTooltip(target);
                this.tooltip.option({
                    contentTemplate: function(container) {
                        if (!_this.list) {
                            var listElement = (0, _renderer2.default)("<div>");
                            (0, _renderer2.default)(container).append(listElement);
                            _this.list = _this._createList(listElement, dataList)
                        }
                    },
                    onShown: function() {
                        return _this.list.option("focusStateEnabled", _this.scheduler.option("focusStateEnabled"))
                    }
                })
            } else {
                this._shouldUseTarget() && this.tooltip.option("target", target);
                this.list.option("dataSource", dataList)
            }
            this.tooltip.option("visible", true)
        }
    }, {
        key: "dispose",
        value: function() {}
    }, {
        key: "hide",
        value: function() {
            if (this.tooltip) {
                this.tooltip.option("visible", false)
            }
        }
    }, {
        key: "_shouldUseTarget",
        value: function() {
            return true
        }
    }, {
        key: "_createTooltip",
        value: function(target, list) {}
    }, {
        key: "_canShowTooltip",
        value: function(target, dataList) {
            if (!dataList.length || this.tooltip && this.tooltip.option("visible") && (0, _renderer2.default)(this.tooltip.option("target")).get(0) === (0, _renderer2.default)(target).get(0)) {
                return false
            }
            return true
        }
    }, {
        key: "_createListOption",
        value: function(dataList) {
            var _this2 = this;
            return {
                dataSource: dataList,
                onContentReady: this._onListRendered.bind(this),
                onItemClick: function(e) {
                    return _this2._onListItemClick(e)
                },
                itemTemplate: function(item, index) {
                    return _this2._renderTemplate(_this2.tooltip.option("target"), item.data, item.currentData || item.data, index, item.color)
                }
            }
        }
    }, {
        key: "_createList",
        value: function(listElement, dataList) {
            return this.scheduler._createComponent(listElement, _uiList2.default, this._createListOption(dataList))
        }
    }, {
        key: "_onListRendered",
        value: function(e) {}
    }, {
        key: "_getTargetData",
        value: function(data, $appointment) {
            return this.scheduler.fire("getTargetedAppointmentData", data, $appointment)
        }
    }, {
        key: "_renderTemplate",
        value: function(target, data, currentData, index, color) {
            this._createTemplate(data, currentData, color);
            var template = this.scheduler._getAppointmentTemplate(this._getItemListTemplateName());
            return this._createFunctionTemplate(template, data, this._getTargetData(data, target), index)
        }
    }, {
        key: "_createFunctionTemplate",
        value: function(template, data, targetData, index) {
            return createDefaultTooltipTemplate(template, data, targetData, index)
        }
    }, {
        key: "_getItemListTemplateName",
        value: function() {
            return "appointmentTooltipTemplate"
        }
    }, {
        key: "_getItemListDefaultTemplateName",
        value: function() {
            return "appointmentTooltip"
        }
    }, {
        key: "_onListItemClick",
        value: function(e) {
            this.hide();
            if (this._canRaiseClickEvent()) {
                this._raiseClickEventAndShowAppointmentPopup(e)
            } else {
                this.scheduler.showAppointmentPopup(e.itemData.data, false, e.itemData.currentData)
            }
        }
    }, {
        key: "_canRaiseClickEvent",
        value: function() {
            return true
        }
    }, {
        key: "_raiseClickEventAndShowAppointmentPopup",
        value: function(e) {
            var config = {
                itemData: e.itemData.data,
                itemElement: e.itemElement
            };
            var showEditAppointmentPopupAction = this.createAppointmentClickAction();
            showEditAppointmentPopupAction(this.createClickEventArgument(config, e))
        }
    }, {
        key: "createAppointmentClickAction",
        value: function() {
            var _this3 = this;
            return this.scheduler._createActionByOption("onAppointmentClick", {
                afterExecute: function(e) {
                    var config = e.args[0];
                    config.event.stopPropagation();
                    _this3.scheduler.fire("showEditAppointmentPopup", {
                        data: config.appointmentData
                    })
                }
            })
        }
    }, {
        key: "createClickEventArgument",
        value: function(config, clickArg) {
            var result = (0, _extend.extendFromObject)(this.scheduler.fire("mapAppointmentFields", config), clickArg, false);
            return this.trimClickEventArgument(result)
        }
    }, {
        key: "trimClickEventArgument",
        value: function(e) {
            delete e.itemData;
            delete e.itemIndex;
            delete e.itemElement;
            return e
        }
    }, {
        key: "_onDeleteButtonClick",
        value: function() {
            this.hide()
        }
    }, {
        key: "_createTemplate",
        value: function(data, currentData, color) {
            var _this4 = this;
            this.scheduler._defaultTemplates[this._getItemListDefaultTemplateName()] = new _function_template.FunctionTemplate(function(options) {
                var $container = (0, _renderer2.default)(options.container);
                $container.append(_this4._createItemListContent(data, currentData, color));
                return $container
            })
        }
    }, {
        key: "_createItemListContent",
        value: function(data, currentData, color) {
            var editing = this.scheduler.option("editing"),
                isAllDay = this.scheduler.fire("getField", "allDay", data),
                text = this.scheduler.fire("getField", "text", data),
                startDateTimeZone = this.scheduler.fire("getField", "startDateTimeZone", data),
                endDateTimeZone = this.scheduler.fire("getField", "endDateTimeZone", data),
                startDate = this.scheduler.fire("convertDateByTimezone", this.scheduler.fire("getField", "startDate", currentData), startDateTimeZone),
                endDate = this.scheduler.fire("convertDateByTimezone", this.scheduler.fire("getField", "endDate", currentData), endDateTimeZone);
            var $itemElement = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM);
            $itemElement.append(this._createItemListMarker(color));
            $itemElement.append(this._createItemListInfo(text, this._formatDate(startDate, endDate, isAllDay)));
            if (editing && true === editing.allowDeleting || true === editing) {
                $itemElement.append(this._createDeleteButton(data, currentData))
            }
            return $itemElement
        }
    }, {
        key: "_createItemListMarker",
        value: function(color) {
            var $marker = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_MARKER);
            var $markerBody = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_MARKER_BODY);
            $marker.append($markerBody);
            color && color.done(function(value) {
                return $markerBody.css("background", value)
            });
            return $marker
        }
    }, {
        key: "_createItemListInfo",
        value: function(text, formattedDate) {
            var result = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_CONTENT);
            var $title = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_CONTENT_SUBJECT).text(text);
            var $date = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_CONTENT_DATE).text(formattedDate);
            return result.append($title).append($date)
        }
    }, {
        key: "_createDeleteButton",
        value: function(data, currentData) {
            var _this5 = this;
            var $container = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_DELETE_BUTTON_CONTAINER),
                $deleteButton = (0, _renderer2.default)("<div>").addClass(TOOLTIP_APPOINTMENT_ITEM_DELETE_BUTTON);
            $container.append($deleteButton);
            this.scheduler._createComponent($deleteButton, _button2.default, {
                icon: "trash",
                stylingMode: "text",
                onClick: function(e) {
                    _this5._onDeleteButtonClick();
                    _this5.scheduler._checkRecurringAppointment(data, currentData, currentData.startDate, function() {
                        return _this5.scheduler.deleteAppointment(data)
                    }, true);
                    e.event.stopPropagation()
                }
            });
            return $container
        }
    }, {
        key: "_formatDate",
        value: function(startDate, endDate, isAllDay) {
            var result = "";
            this.scheduler.fire("formatDates", {
                startDate: startDate,
                endDate: endDate,
                formatType: this._getTypeFormat(startDate, endDate, isAllDay),
                callback: function(value) {
                    return result = value
                }
            });
            return result
        }
    }, {
        key: "_getTypeFormat",
        value: function(startDate, endDate, isAllDay) {
            if (isAllDay) {
                return "DATE"
            }
            if ("month" !== this.scheduler.option("currentView") && _date2.default.sameDate(startDate, endDate)) {
                return "TIME"
            }
            return "DATETIME"
        }
    }]);
    return TooltipStrategyBase
}();
