/*
 Highstock JS v7.2.2 (2020-08-24)

 All technical indicators for Highstock

 (c) 2010-2019 Pawel Fus

 License: www.highcharts.com/license
*/
(function(e){"object"===typeof module&&module.exports?(e["default"]=e,module.exports=e):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(w){e(w);e.Highcharts=w;return e}):e("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(e){function w(d,k,r,l){d.hasOwnProperty(k)||(d[k]=l.apply(null,r))}e=e?e._modules:{};w(e,"mixins/indicator-required.js",[e["parts/Globals.js"]],function(d){var k=d.error;return{isParentLoaded:function(d,
l,f,b,c){if(d)return b?b(d):!0;k(c||this.generateMessage(f,l));return!1},generateMessage:function(d,l){return'Error: "'+d+'" indicator type requires "'+l+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+d}}});w(e,"indicators/indicators.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/indicator-required.js"]],function(d,k,r){var l=k.extend,f=k.isArray,b=k.pick,c=k.splat,a=d.error,g=d.Series,t=d.addEvent;k=d.seriesType;var q=d.seriesTypes,
n=d.seriesTypes.ohlc.prototype,p=r.generateMessage;t(d.Series,"init",function(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&l(this,{pointValKey:n.pointValKey,keys:n.keys,pointArrayMap:n.pointArrayMap,toYData:n.toYData})});t(g,"afterSetOptions",function(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")});k("sma","line",{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,period:14}},
{processData:function(){var a=this.options.compareToMain,c=this.linkedParent;g.prototype.processData.apply(this,arguments);c&&c.compareValue&&a&&(this.compareValue=c.compareValue)},bindTo:{series:!0,eventName:"updatedData"},hasDerivedData:!0,useCommonDataGrouping:!0,nameComponents:["period"],nameSuffixes:[],calculateOn:"init",requiredIndicators:[],requireIndicators:function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(c){q[c]?q[c].prototype.requireIndicators():(a.allLoaded=!1,a.needed=
c)});return a},init:function(b,f){function m(){var a=h.points||[],b=(h.xData||[]).length,g=h.getValues(h.linkedParent,h.options.params)||{values:[],xData:[],yData:[]},m=[],f=!0;if(b&&!h.hasGroupedData&&h.visible&&h.points)if(h.cropped){if(h.xAxis){var t=h.xAxis.min;var q=h.xAxis.max}b=h.cropData(g.xData,g.yData,t,q);for(t=0;t<b.xData.length;t++)m.push([b.xData[t]].concat(c(b.yData[t])));b=g.xData.indexOf(h.xData[0]);t=g.xData.indexOf(h.xData[h.xData.length-1]);-1===b&&t===g.xData.length-2&&m[0][0]===
a[0].x&&m.shift();h.updateData(m)}else g.xData.length!==b-1&&g.xData.length!==b+1&&(f=!1,h.updateData(g.values));f&&(h.xData=g.xData,h.yData=g.yData,h.options.data=g.values);!1===h.bindTo.series&&(delete h.processedXData,h.isDirty=!0,h.redraw());h.isDirtyData=!1}var h=this,q=h.requireIndicators();if(!q.allLoaded)return a(p(h.type,q.needed));g.prototype.init.call(h,b,f);b.linkSeries();h.dataEventsToUnbind=[];if(!h.linkedParent)return a("Series "+h.options.linkedTo+" not found! Check `linkedTo`.",!1,
b);h.dataEventsToUnbind.push(t(h.bindTo.series?h.linkedParent:h.linkedParent.xAxis,h.bindTo.eventName,m));if("init"===h.calculateOn)m();else var n=t(h.chart,h.calculateOn,function(){m();n()});return h},getName:function(){var a=this.name,c=[];a||((this.nameComponents||[]).forEach(function(a,g){c.push(this.options.params[a]+b(this.nameSuffixes[g],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+c.join(", ")+")":""));return a},getValues:function(a,c){var b=c.period,g=
a.xData;a=a.yData;var h=a.length,t=0,q=0,n=[],p=[],y=[],d=-1;if(g.length<b)return!1;for(f(a[0])&&(d=c.index?c.index:0);t<b-1;)q+=0>d?a[t]:a[t][d],t++;for(c=t;c<h;c++){q+=0>d?a[c]:a[c][d];var l=[g[c],q/b];n.push(l);p.push(l[0]);y.push(l[1]);q-=0>d?a[c-t]:a[c-t][d]}return{values:n,xData:p,yData:y}},destroy:function(){this.dataEventsToUnbind.forEach(function(a){a()});g.prototype.destroy.call(this)}});""});w(e,"indicators/accumulation-distribution.src.js",[e["parts/Globals.js"]],function(d){var k=d.seriesType;
k("ad","sma",{params:{volumeSeriesID:"volume"}},{nameComponents:!1,nameBase:"Accumulation/Distribution",getValues:function(k,l){var f=l.period,b=k.xData,c=k.yData,a=l.volumeSeriesID,g=k.chart.get(a);l=g&&g.yData;var t=c?c.length:0,q=[],n=[],p=[];if(b.length<=f&&t&&4!==c[0].length)return!1;if(!g)return d.error("Series "+a+" not found! Check `volumeSeriesID`.",!0,k.chart);for(;f<t;f++){k=q.length;a=c[f][1];g=c[f][2];var h=c[f][3],y=l[f];a=[b[f],h===a&&h===g||a===g?0:(2*h-g-a)/(a-g)*y];0<k&&(a[1]+=q[k-
1][1]);q.push(a);n.push(a[0]);p.push(a[1])}return{values:q,xData:n,yData:p}}});""});w(e,"indicators/ao.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,k){var e=k.isArray,l=d.correctFloat;d.seriesType("ao","sma",{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,states:{hover:{halo:{size:0}}}},{nameBase:"AO",nameComponents:!1,markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,
translate:d.seriesTypes.column.prototype.translate,drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){var f=this.options,b=this.points,c=f.greaterBarColor;f=f.lowerBarColor;var a=b[0];if(!this.userOptions.color&&a)for(a.color=c,a=1;a<b.length;a++)b[a].color=b[a].y>b[a-1].y?c:b[a].y<b[a-1].y?f:b[a-1].color},getValues:function(f){var b=f.xData||[];f=f.yData||[];var c=f.length,a=[],g=[],t=[],q=0,n=0,p;if(34>=b.length||!e(f[0])||4!==f[0].length)return!1;for(p=0;33>p;p++){var h=
(f[p][1]+f[p][2])/2;29<=p&&(q=l(q+h));n=l(n+h)}for(p=33;p<c;p++){h=(f[p][1]+f[p][2])/2;q=l(q+h);n=l(n+h);h=q/5;var y=n/34;h=l(h-y);a.push([b[p],h]);g.push(b[p]);t.push(h);h=p+1-5;y=p+1-34;q=l(q-(f[h][1]+f[h][2])/2);n=l(n-(f[y][1]+f[y][2])/2)}return{values:a,xData:g,yData:t}}});""});w(e,"mixins/multipe-lines.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,k){var e=k.defined,l=d.each,f=d.merge,b=d.error,c=d.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],
getTranslatedLinesNames:function(a){var c=[];l(this.pointArrayMap,function(b){b!==a&&c.push("plot"+b.charAt(0).toUpperCase()+b.slice(1))});return c},toYData:function(a){var c=[];l(this.pointArrayMap,function(b){c.push(a[b])});return c},translate:function(){var a=this,b=a.pointArrayMap,t=[],f;t=a.getTranslatedLinesNames();c.prototype.translate.apply(a,arguments);l(a.points,function(c){l(b,function(b,g){f=c[b];null!==f&&(c[t[g]]=a.yAxis.toPixels(f,!0))})})},drawGraph:function(){var a=this,g=a.linesApiNames,
t=a.points,q=t.length,n=a.options,p=a.graph,h={options:{gapSize:n.gapSize}},y=[],m=a.getTranslatedLinesNames(a.pointValKey),u;l(m,function(a,c){for(y[c]=[];q--;)u=t[q],y[c].push({x:u.x,plotX:u.plotX,plotY:u[a],isNull:!e(u[a])});q=t.length});l(g,function(g,m){y[m]?(a.points=y[m],n[g]?a.options=f(n[g].styles,h):b('Error: "There is no '+g+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+g],c.prototype.drawGraph.call(a),
a["graph"+g]=a.graph):b('Error: "'+g+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=t;a.options=n;a.graph=p;c.prototype.drawGraph.call(a)}}});w(e,"indicators/aroon.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/multipe-lines.js"]],function(d,k,e){function l(b,c){var a=b[0],g=0,f;for(f=1;f<b.length;f++)if("max"===c&&b[f]>=a||"min"===c&&b[f]<=a)a=b[f],g=f;return g}var f=k.pick;d.seriesType("aroon","sma",{params:{period:25},
marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(e,{nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y",linesApiNames:["aroonDown"],getValues:function(b,c){c=c.period;var a=b.xData,g=(b=b.yData)?b.length:0,t=[],q=[],n=[],p;for(p=c-1;p<g;p++){var h=b.slice(p-c+1,
p+2);var y=l(h.map(function(a){return f(a[2],a)}),"min");h=l(h.map(function(a){return f(a[1],a)}),"max");h=h/c*100;y=y/c*100;a[p+1]&&(t.push([a[p+1],h,y]),q.push(a[p+1]),n.push([h,y]))}return{values:t,xData:q,yData:n}}}));""});w(e,"indicators/aroon-oscillator.src.js",[e["parts/Globals.js"],e["mixins/multipe-lines.js"],e["mixins/indicator-required.js"]],function(d,k,e){var l=d.seriesTypes.aroon;d.seriesType("aroonoscillator","aroon",{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}},
d.merge(k,{nameBase:"Aroon Oscillator",pointArrayMap:["y"],pointValKey:"y",linesApiNames:[],init:function(){var f=arguments,b=this;e.isParentLoaded(l,"aroon",b.type,function(c){c.prototype.init.apply(b,f)})},getValues:function(f,b){var c=[],a=[],g=[];f=l.prototype.getValues.call(this,f,b);for(b=0;b<f.yData.length;b++){var t=f.yData[b][0];var q=f.yData[b][1];t-=q;c.push([f.xData[b],t]);a.push(f.xData[b]);g.push(t)}return{values:c,xData:a,yData:g}}}));""});w(e,"indicators/atr.src.js",[e["parts/Globals.js"],
e["parts/Utilities.js"]],function(d,k){function e(b,c){return Math.max(b[1]-b[2],c===f?0:Math.abs(b[1]-c[3]),c===f?0:Math.abs(b[2]-c[3]))}var l=k.isArray;d=d.seriesType;var f;d("atr","sma",{params:{period:14}},{getValues:function(b,c){c=c.period;var a=b.xData,g=(b=b.yData)?b.length:0,f=1,q=0,n=0,p=[],h=[],y=[],m;var u=[[a[0],b[0]]];if(a.length<=c||!l(b[0])||4!==b[0].length)return!1;for(m=1;m<=g;m++)if(u.push([a[m],b[m]]),c<f){var v=c;var d=a[m-1],k=e(b[m-1],b[m-2]);v=[d,(q*(v-1)+k)/v];q=v[1];p.push(v);
h.push(v[0]);y.push(v[1])}else c===f?(q=n/(m-1),p.push([a[m-1],q]),h.push(a[m-1]),y.push(q)):n+=e(b[m-1],b[m-2]),f++;return{values:p,xData:h,yData:y}}});""});w(e,"indicators/bollinger-bands.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/multipe-lines.js"]],function(d,k,e){var l=k.isArray,f=d.merge,b=d.seriesTypes.sma;d.seriesType("bb","sma",{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},
tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}},d.merge(e,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],init:function(){b.prototype.init.apply(this,arguments);this.options=f({topLine:{styles:{lineColor:this.color}},
bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(c,a){var g=a.period,f=a.standardDeviation,q=c.xData,n=(c=c.yData)?c.length:0,p=[],h=[],y=[],m;if(q.length<g)return!1;var u=l(c[0]);for(m=g;m<=n;m++){var v=q.slice(m-g,m);var d=c.slice(m-g,m);var k=b.prototype.getValues.call(this,{xData:v,yData:d},a);v=k.xData[0];k=k.yData[0];for(var e=0,r=d.length,z=0;z<r;z++){var A=(u?d[z][a.index]:d[z])-k;e+=A*A}A=Math.sqrt(e/(r-1));d=k+f*A;A=k-f*A;p.push([v,d,k,A]);h.push(v);y.push([d,
k,A])}return{values:p,xData:h,yData:y}}}));""});w(e,"indicators/cci.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,k){function e(f){return f.reduce(function(b,c){return b+c},0)}var l=k.isArray;d=d.seriesType;d("cci","sma",{params:{period:14}},{getValues:function(f,b){b=b.period;var c=f.xData,a=(f=f.yData)?f.length:0,g=[],t=1,q=[],n=[],p=[];if(c.length<=b||!l(f[0])||4!==f[0].length)return!1;for(;t<b;){var h=f[t-1];g.push((h[1]+h[2]+h[3])/3);t++}for(t=b;t<=a;t++){h=f[t-1];h=(h[1]+
h[2]+h[3])/3;var d=g.push(h);var m=g.slice(d-b);d=e(m)/b;var u,v=m.length,k=0;for(u=0;u<v;u++)k+=Math.abs(d-m[u]);m=k/b;h=(h-d)/(.015*m);q.push([c[t-1],h]);n.push(c[t-1]);p.push(h)}return{values:q,xData:n,yData:p}}});""});w(e,"indicators/cmf.src.js",[e["parts/Globals.js"]],function(d){d.seriesType("cmf","sma",{params:{period:14,volumeSeriesID:"volume"}},{nameBase:"Chaikin Money Flow",isValid:function(){var d=this.chart,e=this.options,l=this.linkedParent;d=this.volumeSeries||(this.volumeSeries=d.get(e.params.volumeSeriesID));
var f=l&&l.yData&&4===l.yData[0].length;return!!(l&&d&&l.xData&&l.xData.length>=e.params.period&&d.xData&&d.xData.length>=e.params.period&&f)},getValues:function(d,e){return this.isValid()?this.getMoneyFlow(d.xData,d.yData,this.volumeSeries.yData,e.period):!1},getMoneyFlow:function(d,e,l,f){function b(a,c){var b=a[1],g=a[2];a=a[3];return null!==c&&null!==b&&null!==g&&null!==a&&b!==g?(a-g-(b-a))/(b-g)*c:(y=h,null)}var c=e.length,a=[],g=0,t=0,q=[],n=[],p=[],h,y=-1;if(0<f&&f<=c){for(h=0;h<f;h++)a[h]=
b(e[h],l[h]),g+=l[h],t+=a[h];q.push(d[h-1]);n.push(h-y>=f&&0!==g?t/g:null);for(p.push([q[0],n[0]]);h<c;h++){a[h]=b(e[h],l[h]);g-=l[h-f];g+=l[h];t-=a[h-f];t+=a[h];var m=[d[h],h-y>=f?t/g:null];q.push(m[0]);n.push(m[1]);p.push([m[0],m[1]])}}return{values:p,xData:q,yData:n}}});""});w(e,"indicators/dpo.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(b,c,a,g,t){c=l(c[a][g],c[a]);return t?f(b-c):f(b+c)}var l=e.pick,f=d.correctFloat;d.seriesType("dpo","sma",{params:{period:21}},
{nameBase:"DPO",getValues:function(b,c){var a=c.period;c=c.index;var g=a+Math.floor(a/2+1),f=b.xData||[];b=b.yData||[];var q=b.length,n=[],p=[],h=[],d=0,m,u;if(f.length<=g)return!1;for(m=0;m<a-1;m++)d=k(d,b,m,c);for(u=0;u<=q-g;u++){var v=u+a-1;m=u+g-1;d=k(d,b,v,c);v=l(b[m][c],b[m]);v-=d/a;d=k(d,b,u,c,!0);n.push([f[m],v]);p.push(f[m]);h.push(v)}return{values:n,xData:p,yData:h}}});""});w(e,"indicators/ema.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.isArray;e=d.seriesType;
var l=d.correctFloat;e("ema","sma",{params:{index:3,period:9}},{accumulatePeriodPoints:function(f,b,c){for(var a=0,g=0,t;g<f;)t=0>b?c[g]:c[g][b],a+=t,g++;return a},calculateEma:function(f,b,c,a,g,t,q){f=f[c-1];b=0>t?b[c-1]:b[c-1][t];a=void 0===g?q:l(b*a+g*(1-a));return[f,a]},getValues:function(f,b){var c=b.period,a=f.xData,g=(f=f.yData)?f.length:0,t=2/(c+1),q=[],n=[],d=[],h=-1;if(g<c)return!1;k(f[0])&&(h=b.index?b.index:0);for(b=this.accumulatePeriodPoints(c,h,f)/c;c<g+1;c++){var l=this.calculateEma(a,
f,c,t,l,h,b);q.push(l);n.push(l[0]);d.push(l[1]);l=l[1]}return{values:q,xData:n,yData:d}}});""});w(e,"indicators/chaikin.src.js",[e["parts/Globals.js"],e["mixins/indicator-required.js"]],function(d,e){var k=d.seriesTypes.ema,l=d.seriesTypes.ad,f=d.error,b=d.correctFloat;d.seriesType("chaikin","ema",{params:{volumeSeriesID:"volume",periods:[3,10]}},{nameBase:"Chaikin Osc",nameComponents:["periods"],init:function(){var c=arguments,a=this;e.isParentLoaded(k,"ema",a.type,function(b){b.prototype.init.apply(a,
c)})},getValues:function(c,a){var g=a.periods,t=a.period,q=[],n=[],d=[],h;if(2!==g.length||g[1]<=g[0])return f('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."'),!1;a=l.prototype.getValues.call(this,c,{volumeSeriesID:a.volumeSeriesID,period:t});if(!a)return!1;c=k.prototype.getValues.call(this,a,{period:g[0]});a=k.prototype.getValues.call(this,a,{period:g[1]});if(!c||!a)return!1;g=g[1]-g[0];for(h=0;h<a.yData.length;h++)t=b(c.yData[h+g]-a.yData[h]),q.push([a.xData[h],
t]),n.push(a.xData[h]),d.push(t);return{values:q,xData:n,yData:d}}});""});w(e,"indicators/dema.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/indicator-required.js"]],function(d,e,r){var l=e.isArray,f=d.seriesTypes.ema,b=d.correctFloat;d.seriesType("dema","ema",{},{init:function(){var c=arguments,a=this;r.isParentLoaded(f,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getEMA:function(c,a,b,t,q,n){return f.prototype.calculateEma(n||[],c,void 0===q?1:q,this.chart.series[0].EMApercent,
a,void 0===t?-1:t,b)},getValues:function(c,a){var g=a.period,t=2*g,q=c.xData,n=c.yData,d=n?n.length:0,h=-1,y=[],m=[],u=[],v=0,e=[],k;c.EMApercent=2/(g+1);if(d<2*g-1)return!1;l(n[0])&&(h=a.index?a.index:0);c=f.prototype.accumulatePeriodPoints(g,h,n);a=c/g;c=0;for(k=g;k<d+2;k++){k<d+1&&(v=this.getEMA(n,x,a,h,k)[1],e.push(v));var x=v;if(k<t)c+=v;else{k===t&&(a=c/g);v=e[k-g-1];var r=this.getEMA([v],r,a)[1];var z=[q[k-2],b(2*v-r)];y.push(z);m.push(z[0]);u.push(z[1])}}return{values:y,xData:m,yData:u}}});
""});w(e,"indicators/tema.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/indicator-required.js"]],function(d,e,r){var l=e.isArray,f=d.seriesTypes.ema,b=d.correctFloat;d.seriesType("tema","ema",{},{init:function(){var c=arguments,a=this;r.isParentLoaded(f,"ema",a.type,function(b){b.prototype.init.apply(a,c)})},getEMA:function(c,a,b,t,q,d){return f.prototype.calculateEma(d||[],c,void 0===q?1:q,this.chart.series[0].EMApercent,a,void 0===t?-1:t,b)},getTemaPoint:function(c,a,g,f){return[c[f-
3],b(3*g.level1-3*g.level2+g.level3)]},getValues:function(c,a){var b=a.period,t=2*b,q=3*b,d=c.xData,p=c.yData,h=p?p.length:0,y=-1,m=[],u=[],v=[],e=[],k=[],x,r,z={};c.EMApercent=2/(b+1);if(h<3*b-2)return!1;l(p[0])&&(y=a.index?a.index:0);c=f.prototype.accumulatePeriodPoints(b,y,p);a=c/b;c=0;for(x=b;x<h+3;x++){x<h+1&&(z.level1=this.getEMA(p,A,a,y,x)[1],e.push(z.level1));var A=z.level1;if(x<t)c+=z.level1;else{x===t&&(a=c/b,c=0);z.level1=e[x-b-1];z.level2=this.getEMA([z.level1],C,a)[1];k.push(z.level2);
var C=z.level2;if(x<q)c+=z.level2;else{x===q&&(a=c/b);x===h+1&&(z.level1=e[x-b-1],z.level2=this.getEMA([z.level1],C,a)[1],k.push(z.level2));z.level1=e[x-b-2];z.level2=k[x-2*b-1];z.level3=this.getEMA([z.level2],z.prevLevel3,a)[1];if(r=this.getTemaPoint(d,q,z,x))m.push(r),u.push(r[0]),v.push(r[1]);z.prevLevel3=z.level3}}}return{values:m,xData:u,yData:v}}});""});w(e,"indicators/trix.src.js",[e["parts/Globals.js"],e["mixins/indicator-required.js"]],function(d,e){var k=d.correctFloat,l=d.seriesTypes.tema;
d.seriesType("trix","tema",{},{init:function(){var f=arguments,b=this;e.isParentLoaded(l,"tema",b.type,function(c){c.prototype.init.apply(b,f)})},getTemaPoint:function(f,b,c,a){if(a>b)var g=[f[a-3],0!==c.prevLevel3?k(c.level3-c.prevLevel3)/c.prevLevel3*100:null];return g}});""});w(e,"indicators/apo.src.js",[e["parts/Globals.js"],e["mixins/indicator-required.js"]],function(d,e){var k=d.seriesTypes.ema,l=d.error;d.seriesType("apo","ema",{params:{periods:[10,20]}},{nameBase:"APO",nameComponents:["periods"],
init:function(){var f=arguments,b=this;e.isParentLoaded(k,"ema",b.type,function(c){c.prototype.init.apply(b,f)})},getValues:function(f,b){var c=b.periods,a=b.index;b=[];var g=[],t=[],q;if(2!==c.length||c[1]<=c[0])return l('Error: "APO requires two periods. Notice, first period should be lower than the second one."'),!1;var d=k.prototype.getValues.call(this,f,{index:a,period:c[0]});f=k.prototype.getValues.call(this,f,{index:a,period:c[1]});if(!d||!f)return!1;c=c[1]-c[0];for(q=0;q<f.yData.length;q++)a=
d.yData[q+c]-f.yData[q],b.push([f.xData[q],a]),g.push(f.xData[q]),t.push(a);return{values:b,xData:g,yData:t}}});""});w(e,"indicators/ichimoku-kinko-hyo.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(a){return a.reduce(function(a,c){return Math.max(a,c[1])},-Infinity)}function l(a){return a.reduce(function(a,c){return Math.min(a,c[2])},Infinity)}function f(a){return{high:k(a),low:l(a)}}function b(a){var c,b,g,f,h;a.series.forEach(function(a){if(a.xData)for(f=a.xData,
h=b=a.xIncrement?1:f.length-1;0<h;h--)if(g=f[h]-f[h-1],c===n||g<c)c=g});return c}function c(a,c,b,g){if(a&&c&&b&&g){var f=c.plotX-a.plotX;c=c.plotY-a.plotY;var h=g.plotX-b.plotX;g=g.plotY-b.plotY;var m=a.plotX-b.plotX,d=a.plotY-b.plotY;b=(-c*m+f*d)/(-h*c+f*g);h=(h*d-g*m)/(-h*c+f*g);if(0<=b&&1>=b&&0<=h&&1>=h)return{plotX:a.plotX+h*f,plotY:a.plotY+h*c}}return!1}function a(a){var c=a.indicator;c.points=a.points;c.nextPoints=a.nextPoints;c.color=a.color;c.options=p(a.options.senkouSpan.styles,a.gap);
c.graph=a.graph;c.fillGraph=!0;y.prototype.drawGraph.call(c)}var g=e.defined,t=e.isArray,q=e.objectEach,n;e=d.seriesType;var p=d.merge,h=d.color,y=d.seriesTypes.sma;d.approximations["ichimoku-averages"]=function(){var a=[],c;[].forEach.call(arguments,function(b,g){a.push(d.approximations.average(b));c=!c&&void 0===a[g]});return c?void 0:a};e("ikh","sma",{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}},{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period",
"periodTenkan"],init:function(){y.prototype.init.apply(this,arguments);this.options=p({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:h(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:h(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:h(this.color).setOpacity(.2).get()}}},this.options)},toYData:function(a){return[a.tenkanSen,a.kijunSen,
a.chikouSpan,a.senkouSpanA,a.senkouSpanB]},translate:function(){var a=this;y.prototype.translate.apply(a);a.points.forEach(function(c){a.pointArrayMap.forEach(function(b){g(c[b])&&(c["plot"+b]=a.yAxis.toPixels(c[b],!0),c.plotY=c["plot"+b],c.tooltipPos=[c.plotX,c["plot"+b]],c.isNull=!1)})})},drawGraph:function(){var b=this,f=b.points,h=f.length,d=b.options,t=b.graph,n=b.color,l={options:{gapSize:d.gapSize}},e=b.pointArrayMap.length,k=[[],[],[],[],[],[]],r={tenkanLine:k[0],kijunLine:k[1],chikouLine:k[2],
senkouSpanA:k[3],senkouSpanB:k[4],senkouSpan:k[5]},w=[],B=b.options.senkouSpan,F=B.color||B.styles.fill,K=B.negativeColor,M=[[],[]],J=[[],[]],N=0,I,O,L;for(b.ikhMap=r;h--;){var E=f[h];for(I=0;I<e;I++)B=b.pointArrayMap[I],g(E[B])&&k[I].push({plotX:E.plotX,plotY:E["plot"+B],isNull:!1});K&&h!==f.length-1&&(B=r.senkouSpanB.length-1,E=c(r.senkouSpanA[B-1],r.senkouSpanA[B],r.senkouSpanB[B-1],r.senkouSpanB[B]),I={plotX:E.plotX,plotY:E.plotY,isNull:!1,intersectPoint:!0},E&&(r.senkouSpanA.splice(B,0,I),r.senkouSpanB.splice(B,
0,I),w.push(B)))}q(r,function(a,c){d[c]&&"senkouSpan"!==c&&(b.points=k[N],b.options=p(d[c].styles,l),b.graph=b["graph"+c],b.fillGraph=!1,b.color=n,y.prototype.drawGraph.call(b),b["graph"+c]=b.graph);N++});b.graphCollection&&b.graphCollection.forEach(function(a){b[a].destroy();delete b[a]});b.graphCollection=[];if(K&&r.senkouSpanA[0]&&r.senkouSpanB[0]){w.unshift(0);w.push(r.senkouSpanA.length-1);for(e=0;e<w.length-1;e++){B=w[e];E=w[e+1];h=r.senkouSpanB.slice(B,E+1);B=r.senkouSpanA.slice(B,E+1);if(1<=
Math.floor(h.length/2))if(E=Math.floor(h.length/2),h[E].plotY===B[E].plotY){for(L=I=E=0;L<h.length;L++)E+=h[L].plotY,I+=B[L].plotY;E=E>I?0:1}else E=h[E].plotY>B[E].plotY?0:1;else E=h[0].plotY>B[0].plotY?0:1;M[E]=M[E].concat(h);J[E]=J[E].concat(B)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,g){M[g].length&&J[g].length&&(O=0===g?F:K,a({indicator:b,points:M[g],nextPoints:J[g],color:O,options:d,gap:l,graph:b[c]}),b[c]=b.graph,b.graphCollection.push(c))})}else a({indicator:b,
points:r.senkouSpanB,nextPoints:r.senkouSpanA,color:F,options:d,gap:l,graph:b.graphsenkouSpan}),b.graphsenkouSpan=b.graph;delete b.nextPoints;delete b.fillGraph;b.points=f;b.options=d;b.graph=t},getGraphPath:function(a){var c=[];a=a||this.points;if(this.fillGraph&&this.nextPoints){var b=y.prototype.getGraphPath.call(this,this.nextPoints);b[0]="L";var g=y.prototype.getGraphPath.call(this,a);b=b.slice(0,g.length);for(var f=b.length-1;0<f;f-=3)c.push(b[f-2],b[f-1],b[f]);g=g.concat(c)}else g=y.prototype.getGraphPath.apply(this,
arguments);return g},getValues:function(a,c){var g=c.period,h=c.periodTenkan;c=c.periodSenkouSpanB;var d=a.xData,q=a.yData,p=q&&q.length||0;a=b(a.xAxis);var l=[],e=[],m;if(d.length<=g||!t(q[0])||4!==q[0].length)return!1;var y=d[0]-g*a;for(m=0;m<g;m++)e.push(y+m*a);for(m=0;m<p;m++){if(m>=h){var k=q.slice(m-h,m);k=f(k);k=(k.high+k.low)/2}if(m>=g){var u=q.slice(m-g,m);u=f(u);u=(u.high+u.low)/2;var r=(k+u)/2}if(m>=c){var w=q.slice(m-c,m);w=f(w);w=(w.high+w.low)/2}y=q[m][3];var J=d[m];l[m]===n&&(l[m]=
[]);l[m+g]===n&&(l[m+g]=[]);l[m+g][0]=k;l[m+g][1]=u;l[m+g][2]=n;l[m][2]=y;m<=g&&(l[m+g][3]=n,l[m+g][4]=n);l[m+2*g]===n&&(l[m+2*g]=[]);l[m+2*g][3]=r;l[m+2*g][4]=w;e.push(J)}for(m=1;m<=g;m++)e.push(J+m*a);return{values:l,xData:e,yData:l}}});""});w(e,"indicators/keltner-channels.src.js",[e["parts/Globals.js"],e["mixins/multipe-lines.js"]],function(d,e){var k=d.seriesTypes.sma,l=d.seriesTypes.ema,f=d.seriesTypes.atr,b=d.merge,c=d.correctFloat;d.seriesType("keltnerchannels","sma",{params:{period:20,periodATR:10,
multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1},b(e,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",
nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],init:function(){k.prototype.init.apply(this,arguments);this.options=b({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(a,b){var g=b.period,d=b.periodATR,n=b.multiplierATR,p=a.yData;p=p?p.length:0;var h=[];b=l.prototype.getValues(a,{period:g,index:b.index});var e=f.prototype.getValues(a,{period:d}),m=[],k=
[],v;if(p<g)return!1;for(v=g;v<=p;v++){var r=b.values[v-g];var D=e.values[v-d];var x=r[0];a=c(r[1]+n*D[1]);D=c(r[1]-n*D[1]);r=r[1];h.push([x,a,r,D]);m.push(x);k.push([a,r,D])}return{values:h,xData:m,yData:k}}}));""});w(e,"indicators/macd.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.defined;e=d.seriesType;var l=d.merge,f=d.seriesTypes.sma,b=d.seriesTypes.ema,c=d.correctFloat;e("macd","sma",{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],
styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0},{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y",
"signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:d.noop,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,init:function(){f.prototype.init.apply(this,arguments);this.options&&(this.options=l({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),
startIndex:this.macdZones.zones.length},this.resetZones=!0)},toYData:function(a){return[a.y,a.signal,a.MACD]},translate:function(){var a=this,c=["plotSignal","plotMACD"];d.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(b){[b.signal,b.MACD].forEach(function(g,f){null!==g&&(b[c[f]]=a.yAxis.toPixels(g,!0))})})},destroy:function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();f.prototype.destroy.apply(this,
arguments)},drawPoints:d.seriesTypes.column.prototype.drawPoints,drawGraph:function(){for(var a=this,c=a.points,b=c.length,d=a.options,n=a.zones,p={options:{gapSize:d.gapSize}},h=[[],[]],e;b--;)e=c[b],k(e.plotMACD)&&h[0].push({plotX:e.plotX,plotY:e.plotMACD,isNull:!k(e.plotMACD)}),k(e.plotSignal)&&h[1].push({plotX:e.plotX,plotY:e.plotSignal,isNull:!k(e.plotMACD)});["macd","signal"].forEach(function(c,b){a.points=h[b];a.options=l(d[c+"Line"].styles,p);a.graph=a["graph"+c];a.currentLineZone=c+"Zones";
a.zones=a[a.currentLineZone].zones;f.prototype.drawGraph.call(a);a["graph"+c]=a.graph});a.points=c;a.options=d;a.zones=n;a.currentLineZone=null},getZonesGraphs:function(a){var c=f.prototype.getZonesGraphs.call(this,a),b=c;this.currentLineZone&&(b=c.splice(this[this.currentLineZone].startIndex+1),b.length?b.splice(0,0,a[0]):b=[a[0]]);return b},applyZones:function(){var a=this.zones;this.zones=this.signalZones.zones;f.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&
this.graphmacd.hide();this.zones=a},getValues:function(a,g){var f=0,d=[],n=[],p=[];if(a.xData.length<g.longPeriod+g.signalPeriod)return!1;var h=b.prototype.getValues(a,{period:g.shortPeriod});var e=b.prototype.getValues(a,{period:g.longPeriod});h=h.values;e=e.values;for(a=1;a<=h.length;a++)k(e[a-1])&&k(e[a-1][1])&&k(h[a+g.shortPeriod+1])&&k(h[a+g.shortPeriod+1][0])&&d.push([h[a+g.shortPeriod+1][0],0,null,h[a+g.shortPeriod+1][1]-e[a-1][1]]);for(a=0;a<d.length;a++)n.push(d[a][0]),p.push([0,null,d[a][3]]);
g=b.prototype.getValues({xData:n,yData:p},{period:g.signalPeriod,index:2});g=g.values;for(a=0;a<d.length;a++)d[a][0]>=g[0][0]&&(d[a][2]=g[f][1],p[a]=[0,g[f][1],d[a][3]],null===d[a][3]?(d[a][1]=0,p[a][0]=0):(d[a][1]=c(d[a][3]-g[f][1]),p[a][0]=c(d[a][3]-g[f][1])),f++);return{values:d,xData:n,yData:p}}});""});w(e,"indicators/mfi.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(b){return b.reduce(function(c,a){return c+a})}function l(b){return(b[1]+b[2]+b[3])/3}var f=e.isArray;
d.seriesType("mfi","sma",{params:{period:14,volumeSeriesID:"volume",decimals:4}},{nameBase:"Money Flow Index",getValues:function(b,c){var a=c.period,g=b.xData,e=b.yData,q=e?e.length:0,n=c.decimals,p=1,h=b.chart.get(c.volumeSeriesID),y=h&&h.yData,m=[],u=[],v=[],r=[],D=[];if(!h)return d.error("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b.chart);if(g.length<=a||!f(e[0])||4!==e[0].length||!y)return!1;for(b=l(e[p]);p<a+1;)c=b,b=l(e[p]),c=b>=c,h=b*y[p],r.push(c?h:0),D.push(c?0:h),
p++;for(a=p-1;a<q;a++)a>p-1&&(r.shift(),D.shift(),c=b,b=l(e[a]),c=b>c,h=b*y[a],r.push(c?h:0),D.push(c?0:h)),c=k(D),h=k(r),c=h/c,c=parseFloat((100-100/(1+c)).toFixed(n)),m.push([g[a],c]),u.push(g[a]),v.push(c);return{values:m,xData:u,yData:v}}});""});w(e,"indicators/momentum.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(f,b,c,a,g){c=c[a-1][3]-c[a-g-1][3];b=b[a-1];f.shift();return[b,c]}var l=e.isArray;d=d.seriesType;d("momentum","sma",{params:{period:14}},{nameBase:"Momentum",
getValues:function(f,b){b=b.period;var c=f.xData,a=(f=f.yData)?f.length:0,g=c[0],d=[],e=[],n=[];if(c.length<=b||!l(f[0]))return!1;var p=[[g,f[0][3]]];for(g=b+1;g<a;g++){var h=k(p,c,f,g,b,void 0);d.push(h);e.push(h[0]);n.push(h[1])}h=k(p,c,f,g,b,void 0);d.push(h);e.push(h[0]);n.push(h[1]);return{values:d,xData:e,yData:n}}});""});w(e,"indicators/natr.src.js",[e["parts/Globals.js"]],function(d){var e=d.seriesTypes.atr;d.seriesType("natr","sma",{tooltip:{valueSuffix:"%"}},{requiredIndicators:["atr"],
getValues:function(d,l){for(var f=e.prototype.getValues.apply(this,arguments),b=f.values.length,c=l.period-1,a=d.yData,g=0;g<b;g++)f.yData[g]=f.values[g][1]/a[c][3]*100,f.values[g][1]=f.yData[g],c++;return f}});""});w(e,"indicators/pivot-points.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(c,a){var g=c.series.pointArrayMap,f=g.length;for(b.prototype.pointClass.prototype[a].call(c);f--;)a="dataLabel"+g[f],c[a]&&c[a].element&&c[a].destroy(),c[a]=null}var l=e.defined,
f=e.isArray,b=d.seriesTypes.sma;d.seriesType("pivotpoints","sma",{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}},{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",toYData:function(c){return[c.P]},translate:function(){var c=this;b.prototype.translate.apply(c);c.points.forEach(function(a){c.pointArrayMap.forEach(function(b){l(a[b])&&
(a["plot"+b]=c.yAxis.toPixels(a[b],!0))})});c.plotEndPoint=c.xAxis.toPixels(c.endPoint,!0)},getGraphPath:function(c){for(var a=this,g=c.length,f=[[],[],[],[],[],[],[],[],[]],d=[],e=a.plotEndPoint,p=a.pointArrayMap.length,h,k,m;g--;){k=c[g];for(m=0;m<p;m++)h=a.pointArrayMap[m],l(k[h])&&f[m].push({plotX:k.plotX,plotY:k["plot"+h],isNull:!1},{plotX:e,plotY:k["plot"+h],isNull:!1},{plotX:e,plotY:null,isNull:!0});e=k.plotX}f.forEach(function(c){d=d.concat(b.prototype.getGraphPath.call(a,c))});return d},
drawDataLabels:function(){var c=this,a=c.pointArrayMap,g,f,d;if(c.options.dataLabels.enabled){var e=c.points.length;a.concat([!1]).forEach(function(n,h){for(d=e;d--;)f=c.points[d],n?(f.y=f[n],f.pivotLine=n,f.plotY=f["plot"+n],g=f["dataLabel"+n],h&&(f["dataLabel"+a[h-1]]=f.dataLabel),f.dataLabels||(f.dataLabels=[]),f.dataLabels[0]=f.dataLabel=g=g&&g.element?g:null):f["dataLabel"+a[h-1]]=f.dataLabel;b.prototype.drawDataLabels.apply(c,arguments)})}},getValues:function(c,a){var b=a.period,d=c.xData,e=
(c=c.yData)?c.length:0;a=this[a.algorithm+"Placement"];var n=[],l=[],h=[],k;if(d.length<b||!f(c[0])||4!==c[0].length)return!1;for(k=b+1;k<=e+b;k+=b){var m=d.slice(k-b-1,k);var u=c.slice(k-b-1,k);var v=m.length;var r=m[v-1];u=this.getPivotAndHLC(u);u=a(u);u=n.push([r].concat(u));l.push(r);h.push(n[u-1].slice(1))}this.endPoint=m[0]+(r-m[0])/v*b;return{values:n,xData:l,yData:h}},getPivotAndHLC:function(c){var a=-Infinity,b=Infinity,f=c[c.length-1][3];c.forEach(function(c){a=Math.max(a,c[1]);b=Math.min(b,
c[2])});return[(a+b+f)/3,a,b,f]},standardPlacement:function(c){var a=c[1]-c[2];return[null,null,c[0]+a,2*c[0]-c[2],c[0],2*c[0]-c[1],c[0]-a,null,null]},camarillaPlacement:function(c){var a=c[1]-c[2];return[c[3]+1.5*a,c[3]+1.25*a,c[3]+1.1666*a,c[3]+1.0833*a,c[0],c[3]-1.0833*a,c[3]-1.1666*a,c[3]-1.25*a,c[3]-1.5*a]},fibonacciPlacement:function(c){var a=c[1]-c[2];return[null,c[0]+a,c[0]+.618*a,c[0]+.382*a,c[0],c[0]-.382*a,c[0]-.618*a,c[0]-a,null]}},{destroyElements:function(){k(this,"destroyElements")},
destroy:function(){k(this,"destroyElements")}});""});w(e,"indicators/ppo.src.js",[e["parts/Globals.js"],e["mixins/indicator-required.js"]],function(d,e){var k=d.seriesTypes.ema,l=d.error,f=d.correctFloat;d.seriesType("ppo","ema",{params:{periods:[12,26]}},{nameBase:"PPO",nameComponents:["periods"],init:function(){var b=arguments,c=this;e.isParentLoaded(k,"ema",c.type,function(a){a.prototype.init.apply(c,b)})},getValues:function(b,c){var a=c.periods,g=c.index;c=[];var d=[],e=[],n;if(2!==a.length||
a[1]<=a[0])return l('Error: "PPO requires two periods. Notice, first period should be lower than the second one."'),!1;var p=k.prototype.getValues.call(this,b,{index:g,period:a[0]});b=k.prototype.getValues.call(this,b,{index:g,period:a[1]});if(!p||!b)return!1;a=a[1]-a[0];for(n=0;n<b.yData.length;n++)g=f((p.yData[n+a]-b.yData[n])/b.yData[n]*100),c.push([b.xData[n],g]),d.push(b.xData[n]),e.push(g);return{values:c,xData:d,yData:e}}});""});w(e,"mixins/reduce-array.js",[e["parts/Globals.js"]],function(d){var e=
d.reduce;return{minInArray:function(d,l){return e(d,function(f,b){return Math.min(f,b[l])},Number.MAX_VALUE)},maxInArray:function(d,l){return e(d,function(f,b){return Math.max(f,b[l])},-Number.MAX_VALUE)},getArrayExtremes:function(d,l,f){return e(d,function(b,c){return[Math.min(b[0],c[l]),Math.max(b[1],c[f])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});w(e,"indicators/price-channel.src.js",[e["parts/Globals.js"],e["mixins/reduce-array.js"],e["mixins/multipe-lines.js"]],function(d,e,r){var l=e.getArrayExtremes;
e=d.merge;d.seriesType("pc","sma",{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:"#90ed7d",lineWidth:1}},bottomLine:{styles:{lineColor:"#f45b5b",lineWidth:1}},dataGrouping:{approximation:"averages"}},e(r,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],getValues:function(f,b){b=b.period;var c=f.xData,a=(f=f.yData)?f.length:0,g=[],d=[],e=[],n;if(a<b)return!1;for(n=b;n<=a;n++){var p=c[n-
1];var h=f.slice(n-b,n);var k=l(h,2,1);h=k[1];var m=k[0];k=(h+m)/2;g.push([p,h,k,m]);d.push(p);e.push([h,k,m])}return{values:g,xData:d,yData:e}}}));""});w(e,"indicators/price-envelopes.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.isArray,l=d.merge,f=d.seriesTypes.sma;d.seriesType("priceenvelopes","sma",{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle",init:function(){f.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)},
toYData:function(b){return[b.top,b.middle,b.bottom]},translate:function(){var b=this,c=["plotTop","plotMiddle","plotBottom"];f.prototype.translate.apply(b);b.points.forEach(function(a){[a.top,a.middle,a.bottom].forEach(function(f,d){null!==f&&(a[c[d]]=b.yAxis.toPixels(f,!0))})})},drawGraph:function(){for(var b=this,c=b.points,a=c.length,g=b.options,d=b.graph,e={options:{gapSize:g.gapSize}},n=[[],[]],p;a--;)p=c[a],n[0].push({plotX:p.plotX,plotY:p.plotTop,isNull:p.isNull}),n[1].push({plotX:p.plotX,
plotY:p.plotBottom,isNull:p.isNull});["topLine","bottomLine"].forEach(function(a,c){b.points=n[c];b.options=l(g[a].styles,e);b.graph=b["graph"+a];f.prototype.drawGraph.call(b);b["graph"+a]=b.graph});b.points=c;b.options=g;b.graph=d;f.prototype.drawGraph.call(b)},getValues:function(b,c){var a=c.period,g=c.topBand,d=c.bottomBand,e=b.xData,n=(b=b.yData)?b.length:0,l=[],h=[],y=[],m;if(e.length<a||!k(b[0])||4!==b[0].length)return!1;for(m=a;m<=n;m++){var u=e.slice(m-a,m);var v=b.slice(m-a,m);v=f.prototype.getValues.call(this,
{xData:u,yData:v},c);u=v.xData[0];v=v.yData[0];var r=v*(1+g);var D=v*(1-d);l.push([u,r,v,D]);h.push(u);y.push([r,v,D])}return{values:l,xData:h,yData:y}}});""});w(e,"indicators/psar.src.js",[e["parts/Globals.js"]],function(d){d.seriesType("psar","sma",{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}},{nameComponents:!1,getValues:function(d,e){var l=d.xData;d=d.yData;var f=d[0][1],b=e.maxAccelerationFactor,
c=e.increment,a=e.initialAccelerationFactor,g=d[0][2],k=e.decimals,q=e.index,n=[],p=[],h=[],y=1,m;if(q>=d.length)return!1;for(m=0;m<q;m++)f=Math.max(d[m][1],f),g=Math.min(d[m][2],parseFloat(g.toFixed(k)));var u=d[m][1]>g?1:-1;e=e.initialAccelerationFactor;var v=e*(f-g);n.push([l[q],g]);p.push(l[q]);h.push(parseFloat(g.toFixed(k)));for(m=q+1;m<d.length;m++){q=d[m-1][2];var r=d[m-2][2];var D=d[m-1][1];var x=d[m-2][1];var w=d[m][1];var z=d[m][2];null!==r&&null!==x&&null!==q&&null!==D&&null!==w&&null!==
z&&(g=u===y?1===u?g+v<Math.min(r,q)?g+v:Math.min(r,q):g+v>Math.max(x,D)?g+v:Math.max(x,D):f,q=1===u?w>f?w:f:z<f?z:f,w=1===y&&z>g||-1===y&&w>g?1:-1,y=w,v=q,z=c,r=b,D=a,e=y===u?1===y&&v>f?e===r?r:parseFloat((e+z).toFixed(2)):-1===y&&v<f?e===r?r:parseFloat((e+z).toFixed(2)):e:D,f=q-g,v=e*f,n.push([l[m],parseFloat(g.toFixed(k))]),p.push(l[m]),h.push(parseFloat(g.toFixed(k))),y=u,u=w,f=q)}return{values:n,xData:p,yData:h}}});""});w(e,"indicators/roc.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],
function(d,e){var k=e.isArray;d=d.seriesType;d("roc","sma",{params:{index:3,period:9}},{nameBase:"Rate of Change",getValues:function(d,f){var b=f.period,c=d.xData,a=(d=d.yData)?d.length:0,g=[],e=[],l=[],n=-1;if(c.length<=b)return!1;k(d[0])&&(n=f.index);for(f=b;f<a;f++){var p=0>n?(p=d[f-b])?(d[f]-p)/p*100:null:(p=d[f-b][n])?(d[f][n]-p)/p*100:null;p=[c[f],p];g.push(p);e.push(p[0]);l.push(p[1])}return{values:g,xData:e,yData:l}}});""});w(e,"indicators/rsi.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],
function(d,e){var k=e.isArray;d.seriesType("rsi","sma",{params:{period:14,decimals:4}},{getValues:function(d,f){var b=f.period,c=d.xData,a=(d=d.yData)?d.length:0;f=f.decimals;var g=1,e=[],l=[],n=[],p=0,h=0,y;if(c.length<b||!k(d[0])||4!==d[0].length)return!1;for(;g<b;){var m=parseFloat((d[g][3]-d[g-1][3]).toFixed(f));0<m?p+=m:h+=Math.abs(m);g++}var u=parseFloat((p/(b-1)).toFixed(f));for(y=parseFloat((h/(b-1)).toFixed(f));g<a;g++)m=parseFloat((d[g][3]-d[g-1][3]).toFixed(f)),0<m?(p=m,h=0):(p=0,h=Math.abs(m)),
u=parseFloat(((u*(b-1)+p)/b).toFixed(f)),y=parseFloat(((y*(b-1)+h)/b).toFixed(f)),p=0===y?100:0===u?0:parseFloat((100-100/(1+u/y)).toFixed(f)),e.push([c[g],p]),l.push(c[g]),n.push(p);return{values:e,xData:l,yData:n}}});""});w(e,"indicators/stochastic.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/reduce-array.js"],e["mixins/multipe-lines.js"]],function(d,e,r,l){var f=e.isArray,b=d.merge,c=d.seriesTypes.sma,a=r.getArrayExtremes;d.seriesType("stochastic","sma",{params:{periods:[14,
3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}},d.merge(l,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],init:function(){c.prototype.init.apply(this,arguments);this.options=
b({smoothedLine:{styles:{lineColor:this.color}}},this.options)},getValues:function(b,d){var g=d.periods[0];d=d.periods[1];var e=b.xData,l=(b=b.yData)?b.length:0,h=[],k=[],m=[],t=null,v;if(l<g||!f(b[0])||4!==b[0].length)return!1;for(v=g-1;v<l;v++){var r=b.slice(v-g+1,v+1);var w=a(r,2,1);var x=w[0];r=b[v][3]-x;x=w[1]-x;r=r/x*100;k.push(e[v]);m.push([r,null]);v>=g-1+(d-1)&&(t=c.prototype.getValues.call(this,{xData:k.slice(-d),yData:m.slice(-d)},{period:d}),t=t.yData[0]);h.push([e[v],r,t]);m[m.length-
1][1]=t}return{values:h,xData:k,yData:m}}}));""});w(e,"indicators/supertrend.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var l=e.isArray,f=e.objectEach,b=d.seriesTypes.atr,c=d.seriesTypes.sma,a=d.merge,g=d.correctFloat;d.seriesType("supertrend","sma",{params:{multiplier:3,period:10},risingTrendColor:"#06B535",fallingTrendColor:"#F21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}},
{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"],init:function(){c.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)},drawGraph:function(){var b=this,d=b.options,g=b.linkedParent,e=g?g.points:[],h=b.points,l=b.graph,m=h.length,u=e.length-m;u=0<u?u:0;for(var v={options:{gapSize:d.gapSize}},r={top:[],bottom:[],intersect:[]},w={top:{styles:{lineWidth:d.lineWidth,lineColor:d.fallingTrendColor,
dashStyle:d.dashStyle}},bottom:{styles:{lineWidth:d.lineWidth,lineColor:d.risingTrendColor,dashStyle:d.dashStyle}},intersect:d.changeTrendLine},x,G,z,A,C,H,B,F;m--;)x=h[m],G=h[m-1],z=e[m-1+u],A=e[m-2+u],C=e[m+u],H=e[m+u+1],B=x.options.color,F={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},!A&&z&&g.yData[z.index-1]&&(A=k(g,z.index-1,3)),!H&&C&&g.yData[C.index+1]&&(H=k(g,C.index+1,3)),!z&&A&&g.yData[A.index+1]?z=k(g,A.index+1,3):!z&&C&&g.yData[C.index-1]&&(z=k(g,C.index-1,3)),x&&z&&C&&A&&x.x!==z.x&&
(x.x===C.x?(A=z,z=C):x.x===A.x?(z=A,A={close:g.yData[z.index-1][3],x:g.xData[z.index-1]}):H&&x.x===H.x&&(z=H,A=C)),G&&A&&z?(C={x:G.x,plotX:G.plotX,plotY:G.plotY,isNull:!1},x.y>=z.close&&G.y>=A.close?(x.color=B||d.fallingTrendColor,r.top.push(F)):x.y<z.close&&G.y<A.close?(x.color=B||d.risingTrendColor,r.bottom.push(F)):(r.intersect.push(F),r.intersect.push(C),r.intersect.push(a(C,{isNull:!0})),x.y>=z.close&&G.y<A.close?(x.color=B||d.fallingTrendColor,G.color=B||d.risingTrendColor,r.top.push(F),r.top.push(a(C,
{isNull:!0}))):x.y<z.close&&G.y>=A.close&&(x.color=B||d.risingTrendColor,G.color=B||d.fallingTrendColor,r.bottom.push(F),r.bottom.push(a(C,{isNull:!0}))))):z&&(x.y>=z.close?(x.color=B||d.fallingTrendColor,r.top.push(F)):(x.color=B||d.risingTrendColor,r.bottom.push(F)));f(r,function(d,f){b.points=d;b.options=a(w[f].styles,v);b.graph=b["graph"+f+"Line"];c.prototype.drawGraph.call(b);b["graph"+f+"Line"]=b.graph});b.points=h;b.options=d;b.graph=l},getValues:function(a,c){var d=c.period;c=c.multiplier;
var f=a.xData,e=a.yData,k=[],m=[],q=[],v=0===d?0:d-1,t=[],r=[],x;if(f.length<=d||!l(e[0])||4!==e[0].length||0>d)return!1;a=b.prototype.getValues.call(this,a,{period:d}).yData;for(x=0;x<a.length;x++){var w=e[v+x];var z=e[v+x-1]||[];var A=t[x-1];var C=r[x-1];var H=q[x-1];0===x&&(A=C=H=0);d=g((w[1]+w[2])/2+c*a[x]);var B=g((w[1]+w[2])/2-c*a[x]);t[x]=d<A||z[3]>A?d:A;r[x]=B>C||z[3]<C?B:C;if(H===A&&w[3]<t[x]||H===C&&w[3]<r[x])var F=t[x];else if(H===A&&w[3]>t[x]||H===C&&w[3]>r[x])F=r[x];k.push([f[v+x],F]);
m.push(f[v+x]);q.push(F)}return{values:k,xData:m,yData:q}}});""});w(e,"indicators/volume-by-price.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.arrayMax,l=e.arrayMin,f=e.extend,b=e.isArray,c=Math.abs;e=d.noop;var a=d.addEvent,g=d.correctFloat,t=d.seriesType,q=d.seriesTypes.column.prototype;t("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",
negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:e,drawGraph:e,getColumnMetrics:q.getColumnMetrics,crispCol:q.crispCol,init:function(a){d.seriesTypes.sma.prototype.init.apply(this,
arguments);var b=this.options.params;var c=this.linkedParent;b=a.get(b.volumeSeriesID);this.addCustomEvents(c,b);return this},addCustomEvents:function(b,c){function d(){f.chart.redraw();f.setData([]);f.zoneStarts=[];f.zoneLinesSVG&&(f.zoneLinesSVG.destroy(),delete f.zoneLinesSVG)}var f=this;f.dataEventsToUnbind.push(a(b,"remove",function(){d()}));c&&f.dataEventsToUnbind.push(a(c,"remove",function(){d()}));return f},animate:function(a){var b=this,c={};d.svg&&!a&&(c.translateX=b.yAxis.pos,b.group.animate(c,
f(d.animObject(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})),b.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),q.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));q.drawPoints.apply(this,arguments)},posNegVolume:function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,f=this.points.length,e=[],g=[],l=0,n;a?(this.posWidths=e,this.negWidths=g):(e=this.posWidths,
g=this.negWidths);for(;l<f;l++){var k=this.points[l];k[c[0]+"Graphic"]=k.graphic;k.graphic=k[c[1]+"Graphic"];if(a){var p=k.shapeArgs.width;var q=this.priceZones[l];(n=q.wholeVolumeData)?(e.push(p/n*q.positiveVolumeData),g.push(p/n*q.negativeVolumeData)):(e.push(0),g.push(0))}k.color=b?d.styles.positiveColor:d.styles.negativeColor;k.shapeArgs.width=b?this.posWidths[l]:this.negWidths[l];k.shapeArgs.x=b?k.shapeArgs.x:this.posWidths[l]}},translate:function(){var a=this,b=a.options,d=a.chart,f=a.yAxis,
e=f.min,l=a.options.zoneLines,t=a.priceZones,r=0,w,x,G;q.translate.apply(a);var z=a.points;if(z.length){var A=.5>b.pointPadding?b.pointPadding:.1;b=a.volumeDataArray;var C=k(b);var H=d.plotWidth/2;var B=d.plotTop;var F=c(f.toPixels(e)-f.toPixels(e+a.rangeStep));var K=c(f.toPixels(e)-f.toPixels(e+a.rangeStep));A&&(e=c(F*(1-2*A)),r=c((F-e)/2),F=c(e));z.forEach(function(b,c){x=b.barX=b.plotX=0;G=b.plotY=f.toPixels(t[c].start)-B-(f.reversed?F-K:F)-r;w=g(H*t[c].wholeVolumeData/C);b.pointWidth=w;b.shapeArgs=
a.crispCol.apply(a,[x,G,w,F]);b.volumeNeg=t[c].negativeVolumeData;b.volumePos=t[c].positiveVolumeData;b.volumeAll=t[c].wholeVolumeData});l.enabled&&a.drawZones(d,f,a.zoneStarts,l.styles)}},getValues:function(a,c){var f=a.processedXData,e=a.processedYData,g=this.chart,l=c.ranges,k=[],n=[],q=[],p;if(!a.chart)return d.error("Base series not found! In case it has been removed, add a new one.",!0,g);if(!(p=g.get(c.volumeSeriesID)))return d.error("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",
!0,g);if((c=b(e[0]))&&4!==e[0].length)return d.error("Type of "+a.name+" series is different than line, OHLC or candlestick.",!0,g);(this.priceZones=this.specifyZones(c,f,e,l,p)).forEach(function(a,b){k.push([a.x,a.end]);n.push(k[b][0]);q.push(k[b][1])});return{values:k,xData:n,yData:q}},specifyZones:function(a,b,c,d,f){if(a){var e=c.length;for(var h=c[0][3],m=h,n=1,q;n<e;n++)q=c[n][3],q<h&&(h=q),q>m&&(m=q);e={min:h,max:m}}else e=!1;e=(h=e)?h.min:l(c);q=h?h.max:k(c);h=this.zoneStarts=[];m=[];var p=
0;n=1;if(!e||!q)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var t=this.rangeStep=g(q-e)/d;for(h.push(e);p<d-1;p++)h.push(g(h[p]+t));h.push(q);for(d=h.length;n<d;n++)m.push({index:n-1,x:b[0],start:h[n-1],end:h[n]});return this.volumePerZone(a,m,f,b,c)},volumePerZone:function(a,b,d,f,e){var g=this,h=d.processedXData,l=d.processedYData,m=b.length-1,k=e.length;d=l.length;var n,q,p,t,r;c(k-d)&&(f[0]!==h[0]&&l.unshift(0),f[k-1]!==h[d-1]&&l.push(0));g.volumeDataArray=
[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(r=b.negativeVolumeData=0;r<k;r++)p=q=!1,t=a?e[r][3]:e[r],n=r?a?e[r-1][3]:e[r-1]:t,t<=b.start&&0===b.index&&(q=!0),t>=b.end&&b.index===m&&(p=!0),(t>b.start||q)&&(t<b.end||p)&&(b.wholeVolumeData+=l[r],n>t?b.negativeVolumeData+=l[r]:b.positiveVolumeData+=l[r]);g.volumeDataArray.push(b.wholeVolumeData)});return b},drawZones:function(a,b,c,d){var f=a.renderer,e=this.zoneLinesSVG,g=[],h=a.plotWidth,l=a.plotTop,k;c.forEach(function(c){k=
b.toPixels(c)-l;g=g.concat(a.renderer.crispLine(["M",0,k,"L",h,k],d.lineWidth))});e?e.animate({d:g}):e=this.zoneLinesSVG=f.path(g).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return d.Point.prototype.destroy.apply(this,arguments)}});""});w(e,"indicators/vwap.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=
e.isArray;e=d.seriesType;e("vwap","sma",{params:{period:30,volumeSeriesID:"volume"}},{getValues:function(e,f){var b=e.chart,c=e.xData;e=e.yData;var a=f.period,g=!0,l;if(!(l=b.get(f.volumeSeriesID)))return d.error("Series "+f.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b);k(e[0])||(g=!1);return this.calculateVWAPValues(g,c,e,l,a)},calculateVWAPValues:function(d,f,b,c,a){var e=c.yData,l=c.xData.length,k=f.length;c=[];var n=[],p=[],h=[],r=[],m;l=k<=l?k:l;for(m=k=0;k<l;k++){var u=d?(b[k][1]+
b[k][2]+b[k][3])/3:b[k];u*=e[k];u=m?c[k-1]+u:u;var v=m?n[k-1]+e[k]:e[k];c.push(u);n.push(v);r.push([f[k],u/v]);p.push(r[k][0]);h.push(r[k][1]);m++;m===a&&(m=0)}return{values:r,xData:p,yData:h}}});""});w(e,"indicators/williams-r.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"],e["mixins/reduce-array.js"]],function(d,e,r){var l=e.isArray,f=r.getArrayExtremes;d.seriesType("williamsr","sma",{params:{period:14}},{nameBase:"Williams %R",getValues:function(b,c){c=c.period;var a=b.xData,d=(b=b.yData)?
b.length:0,e=[],k=[],n=[],p;if(a.length<c||!l(b[0])||4!==b[0].length)return!1;for(p=c-1;p<d;p++){var h=b.slice(p-c+1,p+1);var r=f(h,2,1);h=r[0];r=r[1];var m=b[p][3];h=(r-m)/(r-h)*-100;a[p]&&(e.push([a[p],h]),k.push(a[p]),n.push(h))}return{values:e,xData:k,yData:n}}});""});w(e,"indicators/wma.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){function k(b,c){c*=(c+1)/2;return b.reduce(function(a,b,c){return[null,a[1]+b[1]*(c+1)]})[1]/c}function l(b,c,a,d){a=k(b,b.length);c=c[d-1];
b.shift();return[c,a]}var f=e.isArray;d=d.seriesType;d("wma","sma",{params:{index:3,period:9}},{getValues:function(b,c){var a=c.period,d=b.xData,e=(b=b.yData)?b.length:0,k=1,n=d[0],p=b[0],h=[],r=[],m=[],u=-1;if(d.length<a)return!1;f(b[0])&&(u=c.index,p=b[0][u]);for(c=[[n,p]];k!==a;)c.push([d[k],0>u?b[k]:b[k][u]]),k++;for(a=k;a<e;a++)k=l(c,d,b,a),h.push(k),r.push(k[0]),m.push(k[1]),c.push([d[a],0>u?b[a]:b[a][u]]);k=l(c,d,b,a);h.push(k);r.push(k[0]);m.push(k[1]);return{values:h,xData:r,yData:m}}});
""});w(e,"indicators/zigzag.src.js",[e["parts/Globals.js"]],function(d){d=d.seriesType;d("zigzag","sma",{params:{lowIndex:2,highIndex:1,deviation:1}},{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag",getValues:function(d,e){var l=e.lowIndex,f=e.highIndex,b=e.deviation/100;e=1+b;var c=1-b;b=d.xData;var a=d.yData;d=a?a.length:0;var g=[],k=[],q=[],n,p,h=!1,r=!1;if(1>=b.length||d&&(void 0===a[0][l]||void 0===a[0][f]))return!1;var m=a[0][l];var u=a[0][f];for(n=1;n<d;n++){if(a[n][l]<=
u*c){g.push([b[0],u]);var v=[b[n],a[n][l]];h=p=!0}else a[n][f]>=m*e&&(g.push([b[0],m]),v=[b[n],a[n][f]],p=!1,h=!0);if(h){k.push(g[0][0]);q.push(g[0][1]);var w=n++;n=d}}for(n=w;n<d;n++)p?(a[n][l]<=v[1]&&(v=[b[n],a[n][l]]),a[n][f]>=v[1]*e&&(r=f)):(a[n][f]>=v[1]&&(v=[b[n],a[n][f]]),a[n][l]<=v[1]*c&&(r=l)),!1!==r&&(g.push(v),k.push(v[0]),q.push(v[1]),v=[b[n],a[n][r]],p=!p,r=!1);l=g.length;0!==l&&g[l-1][0]<b[d-1]&&(g.push(v),k.push(v[0]),q.push(v[1]));return{values:g,xData:k,yData:q}}});""});w(e,"indicators/regressions.src.js",
[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.isArray;d=d.seriesType;d("linearRegression","sma",{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}},{nameBase:"Linear Regression Indicator",getRegressionLineParameters:function(d,e){var b=this.options.params.index,c=function(a,b){return k(a)?a[b]:a},a=d.reduce(function(a,b){return b+a},0),f=e.reduce(function(a,d){return c(d,b)+a},0);a/=d.length;f/=e.length;var l=0,q=0,n;for(n=0;n<d.length;n++){var p=d[n]-a;var h=c(e[n],b)-f;
l+=p*h;q+=Math.pow(p,2)}d=q?l/q:0;return{slope:d,intercept:f-d*a}},getEndPointY:function(d,e){return d.slope*e+d.intercept},transformXData:function(d,e){var b=d[0];return d.map(function(c){return(c-b)/e})},findClosestDistance:function(d){var e,b;for(b=1;b<d.length-1;b++){var c=d[b]-d[b-1];0<c&&(void 0===e||c<e)&&(e=c)}return e},getValues:function(d,e){var b=d.xData;d=d.yData;e=e.period;var c,a={xData:[],yData:[],values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(b);for(c=e-1;c<=
b.length-1;c++){var k=c-e+1;var l=c+1;var n=b[c];var p=b.slice(k,l);k=d.slice(k,l);l=this.transformXData(p,f);p=this.getRegressionLineParameters(l,k);k=this.getEndPointY(p,l[l.length-1]);a.values.push({regressionLineParameters:p,x:n,y:k});a.xData.push(n);a.yData.push(k)}return a}});d("linearRegressionSlope","linearRegression",{},{nameBase:"Linear Regression Slope Indicator",getEndPointY:function(d){return d.slope}});d("linearRegressionIntercept","linearRegression",{},{nameBase:"Linear Regression Intercept Indicator",
getEndPointY:function(d){return d.intercept}});d("linearRegressionAngle","linearRegression",{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}},{nameBase:"Linear Regression Angle Indicator",slopeToAngle:function(d){return 180/Math.PI*Math.atan(d)},getEndPointY:function(d){return this.slopeToAngle(d.slope)}});""});w(e,"indicators/acceleration-bands.src.js",[e["parts/Globals.js"],e["mixins/multipe-lines.js"]],function(d,e){var k=d.seriesTypes.sma,
l=d.merge,f=d.correctFloat;d.seriesType("abands","sma",{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}},l(e,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Acceleration Bands",nameComponents:["period","factor"],linesApiNames:["topLine","bottomLine"],getValues:function(b,c){var a=c.period,d=c.factor;c=c.index;var e=b.xData,l=(b=b.yData)?b.length:0,n=[],p=[],h=[],r=[],
m=[],u;if(l<a)return!1;for(u=0;u<=l;u++){if(u<l){var v=b[u][2];var w=b[u][1];var D=d;v=f(w-v)/(f(w+v)/2)*1E3*D;n.push(b[u][1]*f(1+2*v));p.push(b[u][2]*f(1-2*v))}if(u>=a){v=e.slice(u-a,u);var x=b.slice(u-a,u);D=k.prototype.getValues.call(this,{xData:v,yData:n.slice(u-a,u)},{period:a});w=k.prototype.getValues.call(this,{xData:v,yData:p.slice(u-a,u)},{period:a});x=k.prototype.getValues.call(this,{xData:v,yData:x},{period:a,index:c});v=x.xData[0];D=D.yData[0];w=w.yData[0];x=x.yData[0];h.push([v,D,x,w]);
r.push(v);m.push([D,x,w])}}return{values:h,xData:r,yData:m}}}));""});w(e,"indicators/trendline.src.js",[e["parts/Globals.js"],e["parts/Utilities.js"]],function(d,e){var k=e.isArray;d=d.seriesType;d("trendline","sma",{params:{index:3}},{nameBase:"Trendline",nameComponents:!1,getValues:function(d,e){var b=d.xData,c=d.yData;d=[];var a=[],f=[],l=0,q=0,n=0,p=0,h=b.length,r=e.index;for(e=0;e<h;e++){var m=b[e];var u=k(c[e])?c[e][r]:c[e];l+=m;q+=u;n+=m*u;p+=m*m}c=(h*n-l*q)/(h*p-l*l);isNaN(c)&&(c=0);l=(q-
c*l)/h;for(e=0;e<h;e++)m=b[e],u=c*m+l,d[e]=[m,u],a[e]=m,f[e]=u;return{xData:a,yData:f,values:d}}});""});w(e,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map