/*
 Highstock JS v7.2.2 (2020-08-24)

 Indicator series type for Highstock

 (c) 2010-2019 Pawe Dalek

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/volume-by-price",["highcharts","highcharts/modules/stock"],function(n){a(n);a.Highcharts=n;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function n(a,l,n,q){a.hasOwnProperty(l)||(a[l]=q.apply(null,n))}a=a?a._modules:{};n(a,"indicators/volume-by-price.src.js",[a["parts/Globals.js"],a["parts/Utilities.js"]],function(a,
l){var n=l.arrayMax,q=l.arrayMin,B=l.extend,C=l.isArray,v=Math.abs;l=a.noop;var A=a.addEvent,z=a.correctFloat,D=a.seriesType,y=a.seriesTypes.column.prototype;D("vbp","sma",{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},
dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}},{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:l,drawGraph:l,getColumnMetrics:y.getColumnMetrics,crispCol:y.crispCol,init:function(c){a.seriesTypes.sma.prototype.init.apply(this,arguments);var d=this.options.params;var h=this.linkedParent;d=c.get(d.volumeSeriesID);this.addCustomEvents(h,
d);return this},addCustomEvents:function(c,d){function a(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG.destroy(),delete e.zoneLinesSVG)}var e=this;e.dataEventsToUnbind.push(A(c,"remove",function(){a()}));d&&e.dataEventsToUnbind.push(A(d,"remove",function(){a()}));return e},animate:function(c){var d=this,h={};a.svg&&!c&&(h.translateX=d.yAxis.pos,d.group.animate(h,B(a.animObject(d.options.animation),{step:function(c,a){d.group.attr({scaleX:Math.max(.001,a.pos)})}})),
d.animate=null)},drawPoints:function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),y.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));y.drawPoints.apply(this,arguments)},posNegVolume:function(c,d){var a=d?["positive","negative"]:["negative","positive"],e=this.options.volumeDivision,m=this.points.length,r=[],b=[],g=0,k;c?(this.posWidths=r,this.negWidths=b):(r=this.posWidths,b=this.negWidths);for(;g<m;g++){var f=this.points[g];f[a[0]+"Graphic"]=f.graphic;f.graphic=f[a[1]+
"Graphic"];if(c){var t=f.shapeArgs.width;var w=this.priceZones[g];(k=w.wholeVolumeData)?(r.push(t/k*w.positiveVolumeData),b.push(t/k*w.negativeVolumeData)):(r.push(0),b.push(0))}f.color=d?e.styles.positiveColor:e.styles.negativeColor;f.shapeArgs.width=d?this.posWidths[g]:this.negWidths[g];f.shapeArgs.x=d?f.shapeArgs.x:this.posWidths[g]}},translate:function(){var c=this,a=c.options,h=c.chart,e=c.yAxis,m=e.min,r=c.options.zoneLines,b=c.priceZones,g=0,k,f,t;y.translate.apply(c);var w=c.points;if(w.length){var l=
.5>a.pointPadding?a.pointPadding:.1;a=c.volumeDataArray;var u=n(a);var p=h.plotWidth/2;var E=h.plotTop;var x=v(e.toPixels(m)-e.toPixels(m+c.rangeStep));var q=v(e.toPixels(m)-e.toPixels(m+c.rangeStep));l&&(m=v(x*(1-2*l)),g=v((x-m)/2),x=v(m));w.forEach(function(a,d){f=a.barX=a.plotX=0;t=a.plotY=e.toPixels(b[d].start)-E-(e.reversed?x-q:x)-g;k=z(p*b[d].wholeVolumeData/u);a.pointWidth=k;a.shapeArgs=c.crispCol.apply(c,[f,t,k,x]);a.volumeNeg=b[d].negativeVolumeData;a.volumePos=b[d].positiveVolumeData;a.volumeAll=
b[d].wholeVolumeData});r.enabled&&c.drawZones(h,e,c.zoneStarts,r.styles)}},getValues:function(c,d){var h=c.processedXData,e=c.processedYData,m=this.chart,r=d.ranges,b=[],g=[],k=[],f;if(!c.chart)return a.error("Base series not found! In case it has been removed, add a new one.",!0,m);if(!(f=m.get(d.volumeSeriesID)))return a.error("Series "+d.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,m);if((d=C(e[0]))&&4!==e[0].length)return a.error("Type of "+c.name+" series is different than line, OHLC or candlestick.",
!0,m);(this.priceZones=this.specifyZones(d,h,e,r,f)).forEach(function(a,c){b.push([a.x,a.end]);g.push(b[c][0]);k.push(b[c][1])});return{values:b,xData:g,yData:k}},specifyZones:function(a,d,h,e,m){if(a){var c=h.length;for(var b=h[0][3],g=b,k=1,f;k<c;k++)f=h[k][3],f<b&&(b=f),f>g&&(g=f);c={min:b,max:g}}else c=!1;c=(b=c)?b.min:q(h);f=b?b.max:n(h);b=this.zoneStarts=[];g=[];var t=0;k=1;if(!c||!f)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var l=this.rangeStep=
z(f-c)/e;for(b.push(c);t<e-1;t++)b.push(z(b[t]+l));b.push(f);for(e=b.length;k<e;k++)g.push({index:k-1,x:d[0],start:b[k-1],end:b[k]});return this.volumePerZone(a,g,m,d,h)},volumePerZone:function(a,d,h,e,m){var c=this,b=h.processedXData,g=h.processedYData,k=d.length-1,f=m.length;h=g.length;var l,n,q,u,p;v(f-h)&&(e[0]!==b[0]&&g.unshift(0),e[f-1]!==b[h-1]&&g.push(0));c.volumeDataArray=[];d.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(p=b.negativeVolumeData=0;p<f;p++)q=n=!1,u=a?m[p][3]:
m[p],l=p?a?m[p-1][3]:m[p-1]:u,u<=b.start&&0===b.index&&(n=!0),u>=b.end&&b.index===k&&(q=!0),(u>b.start||n)&&(u<b.end||q)&&(b.wholeVolumeData+=g[p],l>u?b.negativeVolumeData+=g[p]:b.positiveVolumeData+=g[p]);c.volumeDataArray.push(b.wholeVolumeData)});return d},drawZones:function(a,d,h,e){var c=a.renderer,l=this.zoneLinesSVG,b=[],g=a.plotWidth,k=a.plotTop,f;h.forEach(function(c){f=d.toPixels(c)-k;b=b.concat(a.renderer.crispLine(["M",0,f,"L",g,f],e.lineWidth))});l?l.animate({d:b}):l=this.zoneLinesSVG=
c.path(b).attr({"stroke-width":e.lineWidth,stroke:e.color,dashstyle:e.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)}},{destroy:function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return a.Point.prototype.destroy.apply(this,arguments)}});""});n(a,"masters/indicators/volume-by-price.src.js",[],function(){})});
//# sourceMappingURL=volume-by-price.js.map