"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Zone.__load_patch('RTCPeerConnection', function (global, Zone, api) {
    var RTCPeerConnection = global['RTCPeerConnection'];
    if (!RTCPeerConnection) {
        return;
    }
    var addSymbol = api.symbol('addEventListener');
    var removeSymbol = api.symbol('removeEventListener');
    RTCPeerConnection.prototype.addEventListener = RTCPeerConnection.prototype[addSymbol];
    RTCPeerConnection.prototype.removeEventListener = RTCPeerConnection.prototype[removeSymbol];
    // RTCPeerConnection extends EventTarget, so we must clear the symbol
    // to allow patch RTCPeerConnection.prototype.addEventListener again
    RTCPeerConnection.prototype[addSymbol] = null;
    RTCPeerConnection.prototype[removeSymbol] = null;
    api.patchEventTarget(global, [RTCPeerConnection.prototype], { useG: false });
});
//# sourceMappingURL=data:application/json;base64,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