# Netapp Library (LUCI)
LUCI stands for “Library for User-Centered Interfaces”. As the NetApp Digital Design System, LUCI enables digital product teams to quickly design and build high-quality, consistent user experiences.

## Documentation
For Getting started guides, component documentation and code standards, check out our docs!

* [Getting Started Guide For Developers](http://luci.netapp.com/resources/get-started.html#setting-up-luci-with-npm) - learn how to setup up your development environment to work with the npm package.

* [Code Standards](http://luci.netapp.com/resources/code-standards.html) - review our code standards to start developing LUCI compliant components.
* [Component Documentation](http://luci.netapp.com) - learn more about the accessibility of our components, copy code, and become familiar with CSS class names.

## Contents
* components/ - LUCI components
* data/ - JSON files used to populate components with content
* docs/ - Sink pages that show all the variations of a component
* icons/ - SVG icons and the SVG sprite
* scripts/ - Demonstration only JavaScript
* styles/ - the Sass source files for the LUCI CSS
* templates/ - Nunjuck templates for Sink pages
* tokens/ - the Design Tokens in SCSS, JSON, and YAML format

### Developing in the Local Environment
The LUCI development environment is built on the open source `esds-build` project: [esds-build](https://github.com/EightShapes/esds-build).  
Refer to the `esds-build` documentation for where to place assets and build components.
