"use strict";

var Luci = Luci || {};

Luci.Navigation = function() {
    const navigationLink = document.querySelectorAll('.luci-navigation__link'),
        navigationExpandedClass = 'luci-navigation__link--is-expanded',
        navigationActiveClass = 'luci-navigation__link--is-active',
        navContainerWrapper = document.querySelector('.luci-navigation-container__navigation-wrapper');

    function setNavigationState(id, index, state) {
        localStorage.setItem(id + '-section-' + index + '-expanded', state);
    }

    function getCurrentPath() {
        let currentPath = window.location.pathname;
        currentPath = currentPath === '/' ? '/index.html' : currentPath;

        return currentPath;
    }

    function applyNavigationState() {
        const currentPath = getCurrentPath(),
                activeLinks = document.querySelectorAll('.luci-navigation__link[href*="' + currentPath + '"]');

        if (activeLinks.length) {
            for (let i = 0; i < activeLinks.length; i++) {
                activeLinks[i].classList.add(navigationActiveClass);
                let activeLinkParent = activeLinks[i].closest('.luci-navigation__list--subnav');

                if (activeLinkParent) {
                    let activeLinkRoot = activeLinks[i].closest('.luci-navigation');
                    let activeLinkListItem = activeLinkParent.closest('.luci-navigation__item');
                    let activeLinkButton = activeLinkListItem.querySelector('.luci-navigation__link--has-subnav');
                    activeLinkButton.classList.add(navigationActiveClass);
                    let navigationSections = activeLinkRoot.querySelectorAll('.luci-navigation__link--has-subnav');
                    setNavigationState(activeLinkRoot.id, Array.prototype.indexOf.call(navigationSections, activeLinkButton), true);
                }
            }

            if (navContainerWrapper && activeLinks[0].getBoundingClientRect().top >= navContainerWrapper.clientHeight) {
                activeLinks[0].scrollIntoView(
                    {behavior: 'smooth', block: 'center'}
                );
            }
        }
        //get current navigation state
        let navigationNodeList = document.querySelectorAll('.luci-navigation');
        if (navigationNodeList) {
            for (let i = 0; i < navigationNodeList.length; i++) {
                navigationNodeList[i].classList.add('luci-navigation--prevent-transition');
                let navigationSections = navigationNodeList[i].querySelectorAll('.luci-navigation__link--has-subnav');
                for (let j = 0; j < navigationSections.length; j++) {
                    if (localStorage.getItem(navigationNodeList[i].id + '-section-' + j + '-expanded') === 'true') {
                        navigationSections[j].classList.add(navigationExpandedClass);
                        navigationSections[j].setAttribute('aria-expanded', true);
                    }
                }
                setTimeout(function(){
                    navigationNodeList[i].classList.remove('luci-navigation--prevent-transition');
                }, 500);
            }
        }
    }

    function handleNavigationLinkClick(e) {
        let thisLinkRoot = this.closest('.luci-navigation');
        if (this.classList.contains('luci-navigation__link--has-subnav')) {
            e.preventDefault();
            this.classList.toggle(navigationExpandedClass);
            if (this.classList.contains(navigationExpandedClass)) {
                this.setAttribute('aria-expanded', true);
            } else {
                this.setAttribute('aria-expanded', false);
            }
            //save current navigation state
            let navigationSections = thisLinkRoot.querySelectorAll('.luci-navigation__link--has-subnav');
            for (let i = 0; i < navigationSections.length; i++) {
                setNavigationState(thisLinkRoot.id, i, navigationSections[i].classList.contains(navigationExpandedClass) ? true : false);
            }
        } else {
            let navigationLocalLinks = thisLinkRoot.querySelectorAll('.luci-navigation__link');
            let thisLinkParent = this.closest('.luci-navigation__list--subnav');
            for (let i = 0; i < navigationLocalLinks.length; i++) {
                navigationLocalLinks[i].classList.remove(navigationActiveClass);
            }
            this.classList.toggle(navigationActiveClass);
            if (thisLinkParent) {
                let thisLinkListItem = thisLinkParent.closest('.luci-navigation__item');
                let thisLinkButton = thisLinkListItem.querySelector('.luci-navigation__link--has-subnav');
                thisLinkButton.classList.toggle(navigationActiveClass);
            }
        }
    }

    const init = function init() {
        applyNavigationState();

        navigationLink.forEach(function(e){
            e.addEventListener('click', handleNavigationLinkClick);
        });
    };

    return {
        init: init
    };
}();

document.addEventListener('DOMContentLoaded', function() {
    Luci.Navigation.init();
});
