"use strict";

var Luci = Luci || {};

Luci.Readonly = function() {
  const readonlyCheckbox = document.querySelectorAll('input[type="checkbox"].luci-form__input--readonly');
  const readonlyRadioButton = document.querySelectorAll('input[type="radio"].luci-form__input--readonly');
  const readonlySelectMenu = document.querySelectorAll('select.luci-form__input--readonly');

  function setCheckedState(el) {
    if (!el.checked) {
      el.checked = true;
    }
  }

  function keepChecked(e) {
    e.preventDefault();
  }

  const init = function init() {
    readonlyCheckbox.forEach(function (el) {
      setCheckedState(el);
      el.addEventListener('click', keepChecked);
    });

    readonlyRadioButton.forEach(function (el) {
      setCheckedState(el);
      el.setAttribute("name", "readonly-" + Math.random() + "");
    });

    readonlySelectMenu.forEach(function (el) {
      el.addEventListener('mousedown', function(e) {
        e.preventDefault();
      });
    });
  };

  return {
    init: init
  };
}();

Luci.ComboBox = function() {
  const comboBox = document.querySelectorAll('.luci-form__combo-box'),
      comboBoxInput = document.querySelectorAll('.luci-form__combo-box-input'),
      comboBoxMenu = document.querySelectorAll('.luci-form__combo-box-menu'),
      comboBoxClose = document.querySelectorAll('.luci-form__combo-box-close'),
      comboBoxOpenClass = 'luci-form__combo-box--is-open',
      comboBoxLink = document.querySelectorAll('.luci-form__combo-box .luci-list-group__element--link');

  let i;

  function closeAllComboBoxes() {
      for (i = 0; i < comboBox.length; i++) {
          comboBox[i].classList.remove(comboBoxOpenClass);
      }
      if (comboBoxLink.length) {
          for (i = 0; i < comboBoxLink.length; i++) {
              comboBoxLink[i].blur();
          }
      }
      for (i = 0; i < comboBoxInput.length; i++) {
          comboBoxInput[i].setAttribute('aria-expanded', false);
      }
      for (i = 0; i < comboBoxMenu.length; i++) {
          comboBoxMenu[i].setAttribute('aria-hidden', true);
      }
      for (i = 0; i < comboBoxClose.length; i++) {
          comboBoxClose[i].setAttribute('tabindex', '-1');
      }
  }

  function handleComboBoxInputChange() {
    let target = this.closest('.luci-form__combo-box');
    let menu = target.querySelector('.luci-form__combo-box-menu');
    let closeButton = target.querySelector('.luci-form__combo-box-close');

    closeAllComboBoxes();

    if (this.value.length >= 3) {
        target.classList.add(comboBoxOpenClass);
        this.setAttribute('aria-expanded', true);
        menu.setAttribute('aria-hidden', false);
        closeButton.setAttribute('tabindex', '0');
    }
  }

  function handleComboBoxKeydown(e) {
    //Esc key pressed
    if (e.keyCode === 27) {
        closeAllComboBoxes();
    }
  }

  function handleComboBoxCloseClick(e) {
      e.preventDefault();
      e.stopPropagation();
      let target = this.closest('.luci-form__combo-box');
      let targetInput = target.querySelector('.luci-form__combo-box-input');
      targetInput.value = '';
      targetInput.focus();
      closeAllComboBoxes();
  }

  function handleComboBoxLinkClick(e) {
      e.preventDefault();
      e.stopPropagation();
      let target = this.closest('.luci-form__combo-box');
      let targetInput = target.querySelector('.luci-form__combo-box-input');
      let newText = this.textContent.trim();

      targetInput.value = newText;
      closeAllComboBoxes();
  }

  const init = function init() {
    comboBoxInput.forEach(function(e){
      e.addEventListener('click', handleComboBoxInputChange);
      e.addEventListener('input', handleComboBoxInputChange);
      e.addEventListener('keydown', handleComboBoxKeydown);
    });

    comboBoxClose.forEach(function(e){
      e.addEventListener('click', handleComboBoxCloseClick);
    });

    comboBoxLink.forEach(function(e){
      e.addEventListener('click', handleComboBoxLinkClick);
    });

    //Stop Propagation on Combo Box Input and Content elements
    for (i = 0; i < comboBoxInput.length; i++) {
        comboBoxInput[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    for (i = 0; i < comboBoxMenu.length; i++) {
        comboBoxMenu[i].addEventListener('click', function(e){e.stopPropagation();});
    }

    //Close All Comboboxes on body click
    document.addEventListener('click', function(event) {
      closeAllComboBoxes();
    });
  };

  return {
    init: init
  };
}();

document.addEventListener('DOMContentLoaded', function() {
  Luci.Readonly.init();
  Luci.ComboBox.init();
});
