/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Inject, Injectable, InjectionToken, Optional } from '@angular/core';
import { filter, first } from 'rxjs/operators';
/** @type {?} */
export const ANALYTICS_CONFIG = new InjectionToken('nwfAnalyticsConfig');
export class AnalyticsInjectorService {
    /**
     * @param {?} config
     * @param {?} authService
     */
    constructor(config, authService) {
        this.config = config;
        if (authService) {
            ((/** @type {?} */ (authService.isAuthenticated$()))).pipe(filter((/**
             * @param {?} value
             * @return {?}
             */
            (value) => value)), first()).subscribe((/**
             * @return {?}
             */
            () => {
                this.injectMatomo();
            }));
        }
        else {
            this.injectMatomo();
        }
    }
    /**
     * @private
     * @return {?}
     */
    injectMatomo() {
        const { url, src } = this.config;
        window['_paq'] = window['_paq'] || [];
        window['_paq'].push(['enableLinkTracking']);
        ((/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            const d = document;
            window['_paq'].push(['setTrackerUrl', url]);
            window['_paq'].push(['setSiteId', 1]);
            /** @type {?} */
            const g = d.createElement('script');
            /** @type {?} */
            const s = d.getElementsByTagName('script')[0];
            g.type = 'text/javascript';
            g.async = true;
            g.defer = true;
            g.src = src;
            s.parentNode.insertBefore(g, s);
        }))();
    }
}
AnalyticsInjectorService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
AnalyticsInjectorService.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: [ANALYTICS_CONFIG,] }] },
    { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: ['NwfAuthService',] }] }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    AnalyticsInjectorService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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