/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, EventEmitter, Input, Output } from '@angular/core';
export class HeaderComponent {
    /**
     * @param {?} element
     */
    constructor(element) {
        this.element = element;
        this.status = '';
        this.showDimissX = true;
        this.onDismiss = new EventEmitter();
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        /** @type {?} */
        let status = changes.status.currentValue;
        if (status === 'error') {
            status = 'critical';
            this.status = status;
        }
        /** @type {?} */
        const stateCls = status ? `is-${status}` : '';
        if (stateCls) {
            this.element.nativeElement.classList.add(stateCls);
        }
    }
}
HeaderComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-modal-header',
                template: "<nwf-icon [severity]=\"status\" *ngIf=\"status\" class=\"mr-1\"></nwf-icon>\n<h4 class=\"modal-title\">\n  <ng-content></ng-content>\n</h4>\n<nwf-dismiss-button *ngIf=\"showDimissX\" (onClose)=\"onDismiss.emit()\"></nwf-dismiss-button>\n",
                host: { class: 'modal-header' }
            }] }
];
/** @nocollapse */
HeaderComponent.ctorParameters = () => [
    { type: ElementRef }
];
HeaderComponent.propDecorators = {
    status: [{ type: Input }],
    showDimissX: [{ type: Input }],
    onDismiss: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    HeaderComponent.prototype.status;
    /** @type {?} */
    HeaderComponent.prototype.showDimissX;
    /** @type {?} */
    HeaderComponent.prototype.onDismiss;
    /**
     * @type {?}
     * @private
     */
    HeaderComponent.prototype.element;
}
//# sourceMappingURL=data:application/json;base64,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