/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService } from '@uirouter/core';
import { I18NextPipe } from 'angular-i18next';
import { orderBy } from 'lodash-es';
export class NwfStatusableDropdownComponent {
    /**
     * @param {?} stateService
     * @param {?} i18next
     */
    constructor(stateService, i18next) {
        this.stateService = stateService;
        this.i18next = i18next;
        this.statusList = [];
        this.noOfEvents = 0;
        this.arrowUp = false;
        this.hasEvents = false;
        this.dropdownList = [];
        this.highestSeverity = 'info';
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.newEventsCount = this.newEventsCount == '0' ? this.i18next.transform('nwfjs:no') : this.newEventsCount;
        if (this.statusList) {
            /** @type {?} */
            const isListEmpty = this.statusList.length == 0;
            this.hasEvents = this.evalFunction ? this.statusList.some(this.evalFunction) : (isListEmpty ? false : true);
            this.getHighestSeverity();
            this.loadDropdownList();
        }
    }
    /**
     * @return {?}
     */
    loadDropdownList() {
        this.dropdownList = this.evalFunction ? this.statusList.filter(this.evalFunction) : this.statusList;
        this.sortedList = this.sortBy ? orderBy(this.dropdownList, this.sortBy, 'desc') : this.dropdownList;
    }
    // set the icon on the dropdown button to the highest severity in the event list
    /**
     * @return {?}
     */
    getHighestSeverity() {
        /** @type {?} */
        const severityList = this.statusList.map((/**
         * @param {?} events
         * @return {?}
         */
        (events) => events.severity));
        if (severityList.includes('critical')) {
            return 'critical';
        }
        else if (severityList.includes('error')) {
            return 'error';
        }
        else if (severityList.includes('warning')) {
            return 'warning';
        }
        else {
            return 'information';
        }
    }
    /**
     * @param {?} stateName
     * @param {?} stateParams
     * @return {?}
     */
    getLink(stateName, stateParams) {
        return this.createUrl(stateName, stateParams);
    }
}
NwfStatusableDropdownComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-statusable-dropdown',
                template: "<div *ngIf=\"!hasEvents\" class=\"border\">\n    <div class=\"btn d-flex justify-content-start\">\n        <nwf-icon iconClass=\"icon-info-online\" data-netapp-id=\"nwf-statusable-dropdown-success-icon\"> </nwf-icon>\n        <span class=\"btn-icon-label\">{{ 'nwfjs:allHealthy' | i18next}}</span>\n    </div>\n</div>\n<div *ngIf=\"hasEvents\" class=\"border\">\n    <div ngbDropdown class=\"d-flex\" #myDrop=\"ngbDropdown\">\n        <button type=\"button\" class=\"btn\" ngbDropdownToggle>\n            <nwf-icon severity=\"{{getHighestSeverity()}}\"\n                data-netapp-id=\"nwf-statusable-dropdown-highest-severity-icon\"></nwf-icon>\n            <span\n                class=\"btn-icon-label pr-2\">{{'nwfjs:events' | i18next:{count: noOfEvents} }}{{ 'nwfjs:newEvents' | i18next:{newEventsCount: newEventsCount} }}</span>\n            <nwf-icon *ngIf=\"arrowUp\" data-netapp-id=\"nwf-statusable-dropdown-uparrow-icon\"\n                iconClass=\"icon-misc-arrowup\"></nwf-icon>\n            <nwf-icon *ngIf=\"!arrowUp\" data-netapp-id=\"nwf-statusable-dropdown-downarrow-icon\"\n                iconClass=\"icon-misc-arrowdown\"></nwf-icon>\n            <div class=\"ml-auto\">\n                <nwf-icon data-netapp-id=\"nwf-statusable-dropdown-chevrondown-icon\"\n                    [iconClass]=\"myDrop.isOpen() ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\">\n                </nwf-icon>\n            </div>\n        </button>\n\n        <div ngbDropdownMenu>\n            <button ngbDropdownItem class=\"dropdown-item-metadata\" *ngFor=\"let issue of sortedList | slice:0:4\">\n                <nwf-icon [severity]=\"issue.severity\" data-netapp-id=\"nwf-statusable-dropdown-severity-icon\"></nwf-icon>\n                <span class=\"pl-1 align-text-bottom\"><a href=\"{{getLink(issue.stateName, issue.stateParams)}}\">{{issue.label | i18next}}</a></span>\n                <small *ngIf=\"issue.source_full_name\" class=\"text-muted d-block pt-1 pl-4\">{{issue.source_full_name}}</small>\n            </button>\n            <button ngbDropdownItem>\n                <a href=\"{{viewAllNavigation()}}\">{{ 'nwfjs:viewAll' | i18next }}</a>\n            </button>\n        </div>\n    </div>\n</div>",
                styles: [".btn{width:100%;background-color:#fff;padding:0 10px;justify-content:left}.btn[aria-expanded=true],.btn[aria-expanded=true]:hover:not(:disabled){background-color:#fff}.dropdown-menu{min-width:100%}.btn-icon-label{margin-left:4px;color:#454545}.dropdown-toggle{white-space:unset}.dropdown-toggle::after{width:0}:host ::ng-deep .icon-misc-arrowup{color:#da1e21}:host ::ng-deep .icon-misc-arrowdown{color:#90c44b}:host ::ng-deep .icon-status-critical{color:#da1e21}:host ::ng-deep .icon-status-error-full,:host ::ng-deep .icon-status-warning{color:#f88400}:host ::ng-deep .icon-status-info{color:#0067c5}:host ::ng-deep .icon-misc-chevrondown,:host ::ng-deep .icon-misc-chevronup{color:#2d6dde}:host ::ng-deep g[id^=icon-status] #glyph{fill:#fff}"]
            }] }
];
/** @nocollapse */
NwfStatusableDropdownComponent.ctorParameters = () => [
    { type: StateService },
    { type: I18NextPipe }
];
NwfStatusableDropdownComponent.propDecorators = {
    statusList: [{ type: Input }],
    stateKey: [{ type: Input }],
    evalFunction: [{ type: Input }],
    createUrl: [{ type: Input }],
    sortBy: [{ type: Input }],
    viewAllNavigation: [{ type: Input }],
    newEventsCount: [{ type: Input }],
    noOfEvents: [{ type: Input }],
    arrowUp: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.statusList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.stateKey;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.evalFunction;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.createUrl;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.sortBy;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.viewAllNavigation;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.newEventsCount;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.noOfEvents;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.arrowUp;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.sortedList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.hasEvents;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.dropdownList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.highestSeverity;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.stateService;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.i18next;
}
//# sourceMappingURL=data:application/json;base64,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