/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
export class MultiselectDropdownComponent {
    constructor() {
        this.disabled = false;
        this.required = false;
        this._selectedModel = [];
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        /* Clone options array for a private model that represents the internal state */
        this._selectedModel = Object.assign([], this.options);
    }
    /**
     * @param {?} value
     * @return {?}
     */
    writeValue(value) {
        if (value !== undefined && value !== null) {
            for (const option of this._selectedModel) {
                if (value.includes(option.value)) {
                    option.checked = true;
                }
                else {
                    option.checked = false;
                }
            }
            this.setLabel();
        }
    }
    /**
     * @param {?} $event
     * @return {?}
     */
    onCheckboxChange($event) {
        const { value, checked } = $event.target;
        for (const option of this._selectedModel) {
            if (option.value === value) {
                option.checked = checked;
                break;
            }
        }
        /** @type {?} */
        const checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        (option) => option.checked));
        /** @type {?} */
        const onlyTrueValues = checkedOpts.map((/**
         * @param {?} option
         * @return {?}
         */
        (option) => option.value));
        this._onChange(onlyTrueValues);
        /* Now set my label */
        this.setLabel();
    }
    /**
     * @return {?}
     */
    setLabel() {
        /** @type {?} */
        const checkedOpts = this._selectedModel.filter((/**
         * @param {?} option
         * @return {?}
         */
        (option) => option.checked));
        /** @type {?} */
        let label = 'Select one or more';
        if (checkedOpts.length) {
            label = checkedOpts.map((/**
             * @param {?} option
             * @return {?}
             */
            (option) => option.label)).join(', ');
        }
        this.label = label;
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) {
        this._onChange = fn;
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * @param {?} isDisabled
     * @return {?}
     */
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
}
MultiselectDropdownComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-multiselect-dropdown',
                template: "<div ngbDropdown placement=\"bottom-left\" autoClose=\"outside\">\n    <button class=\"custom-select\" ngbDropdownToggle [disabled]=\"disabled\">\n      {{label}}\n    </button>\n  <div ngbDropdownMenu style=\"width: 100%\">\n    <div class=\"dropdown-checkbox-item pl-4 mb-1\">\n      <div class=\"custom-control custom-checkbox custom-checkbox-lg\" *ngFor=\"let option of _selectedModel\">\n        <input type=\"checkbox\" (change)=\"onCheckboxChange($event)\" [value]=\"option.value\" [checked]=\"option.checked\" [name]=\"option.label\" [id]=\"option.label | NwfStripWhitespacePipe\" class=\"custom-control-input\">\n        <label class=\"custom-control-label w-100\" [attr.for]=\"option.label | NwfStripWhitespacePipe\">{{option.label}}</label>\n      </div>\n    </div>\n  </div>\n</div>",
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef((/**
                         * @return {?}
                         */
                        () => MultiselectDropdownComponent)),
                        multi: true,
                    },
                ],
                styles: [":host ::ng-deep .dropdown-menu{max-height:calc(100vh - 300px);overflow-y:auto}.custom-select{overflow:hidden;text-overflow:ellipsis;text-align:left}"]
            }] }
];
/** @nocollapse */
MultiselectDropdownComponent.ctorParameters = () => [];
MultiselectDropdownComponent.propDecorators = {
    options: [{ type: Input }],
    disabled: [{ type: Input }],
    required: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    MultiselectDropdownComponent.prototype.options;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.disabled;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.required;
    /** @type {?} */
    MultiselectDropdownComponent.prototype._selectedModel;
    /** @type {?} */
    MultiselectDropdownComponent.prototype.label;
    /**
     * @type {?}
     * @private
     */
    MultiselectDropdownComponent.prototype._onChange;
}
/**
 * @record
 */
function IMultiSelectOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectOption.prototype.label;
    /** @type {?} */
    IMultiSelectOption.prototype.value;
}
/**
 * @record
 */
function IMultiSelectModelOption() { }
if (false) {
    /** @type {?} */
    IMultiSelectModelOption.prototype.checked;
}
//# sourceMappingURL=data:application/json;base64,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