/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input, ViewChild } from '@angular/core';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { DxDataGridComponent } from 'devextreme-angular';
import { filter, sortBy } from 'lodash-es';
export class ColumnVisibilityComponent {
    constructor() {
        this.orderedColumns = []; // our array of the columns in asc order
        // our array of the columns in asc order
        this.visible = {}; // our map of visiblity true / false
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
    /**
     * @return {?}
     */
    ngAfterViewInit() {
        this.myDrop.openChange.subscribe((/**
         * @param {?} dropdownState
         * @return {?}
         */
        (dropdownState) => {
            // dropdownState = true means dropdown is open.
            if (dropdownState) {
                this.gridInstance = this.dataGrid.instance;
                this.setColumns();
            }
        }));
    }
    /**
     * @return {?}
     */
    setColumns() {
        /** @type {?} */
        const columns = this.getAllColumnsOnDxGrid();
        // Remove all columns that are not shown in the column chooser
        /** @type {?} */
        const shownColumns = filter(columns, (/**
         * @param {?} col
         * @return {?}
         */
        (col) => col.hasOwnProperty('showInColumnChooser') ? col.showInColumnChooser : true));
        // we sort columns alphabettically for display.
        /** @type {?} */
        const columnsInVisibleIndexOrder = sortBy(shownColumns, [(/**
             * @param {?} dxColumn
             * @return {?}
             */
            function (dxColumn) { return dxColumn.caption; })]);
        columnsInVisibleIndexOrder.forEach((/**
         * @param {?} __0
         * @param {?} index
         * @return {?}
         */
        ({ dataField }, index) => {
            /** @type {?} */
            const colObj = this.gridInstance.columnOption(dataField);
            this.visible[dataField] = colObj.visible;
            /*
            we update visibleIndex to actual index of columns in visibleIndex order.
            this ensures we dont have holes in between as shownColumns might contain columns not in order.
            */
            colObj.visibleIndex = index;
            this.orderedColumns[colObj.visibleIndex] = colObj;
        }));
        // Below updated required to reset column width if its changed by user
        this.gridInstance.beginUpdate();
        shownColumns.forEach((/**
         * @param {?} colItem
         * @return {?}
         */
        (colItem) => {
            this.gridInstance.columnOption(colItem.dataField, 'width', null);
        }));
        this.gridInstance.endUpdate();
    }
    /**
     * @param {?} event
     * @param {?} col
     * @return {?}
     */
    notify(event, col) {
        // we filter out command(eg checkbox column) columns as visibility only operates on non-command columns.
        // This ensures we dont toggle the visibility of checkbox column.
        /** @type {?} */
        const visibleColumns = this.gridInstance.getVisibleColumns().filter((/**
         * @param {?} item
         * @return {?}
         */
        function (item) { return !item.command; }));
        /*
        if we have more than one visible column, or we are showing a column,
        only then we toggle the visibility of the column.
        this ensures we never run into case of having all hidden columns.
        */
        if (visibleColumns.length > 1 || event.target.checked) {
            this.gridInstance.beginUpdate();
            this.gridInstance.columnOption(col, 'visible', event.target.checked);
            this.gridInstance.endUpdate();
        }
        else {
            // this ensures the last checkbox remains checked.
            // so that we can never have all checkbox as unchecked i.e. all columns are unselected/hidden.
            event.target.checked = true;
        }
    }
    /**
     * We find all columns on dx grid. Instead of using a method available on gridInstance directly, we use this way because
     * gridInstance.columnOption gives a complete column object (including default column settings),
     * whereas column object returned by gridInstance.option('columnms') only contains properties you explicitly set.
     * @private
     * @return {?}
     */
    getAllColumnsOnDxGrid() {
        /** @type {?} */
        const gridInstance = this.gridInstance;
        /** @type {?} */
        const columnsViaOptions = gridInstance && gridInstance.state().columns;
        if (columnsViaOptions) {
            return columnsViaOptions.map((/**
             * @param {?} __0
             * @return {?}
             */
            ({ dataField }) => gridInstance.columnOption(dataField)));
        }
        else {
            return;
        }
    }
}
ColumnVisibilityComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-column-visibility',
                template: "<div ngbDropdown class=\"d-inline-block\" placement=\"bottom-right\" display=\"dynamic\" autoClose=\"outside\">\n  <button type=\"button\" class=\"btn btn-flat btn-sm btn-icon\" ngbDropdownToggle>\n    <nwf-icon iconClass=\"icon-view-visible\"></nwf-icon><span\n      class=\"btn-icon-label\">{{'nwfjs:showHide' | i18next}}</span>\n  </button>\n  <div ngbDropdownMenu>\n    <dx-scroll-view>\n      <div class=\"dropdown-checkbox-item pl-4 mb-1\" *ngFor=\"let column of orderedColumns\">\n        <div class=\"custom-control custom-checkbox\" *ngIf=\"column.allowHiding !== false\">\n          <input type=\"checkbox\" [name]=\"column.dataField\" [id]=\"column.dataField\" class=\"custom-control-input\"\n            [(ngModel)]=\"visible[column.dataField]\" (change)=\"notify($event, column.dataField)\">\n          <label class=\"custom-control-label w-100\" [attr.for]=\"column.dataField\" data-netapp-id=\"nwf-column-visibility-option-label\">{{column.caption}}</label>\n        </div>\n      </div>\n    </dx-scroll-view>\n  </div>\n</div>",
                styles: [":host ::ng-deep .dx-scrollable-container{max-height:50vh}.dropdown-menu{padding-top:20px;padding-bottom:20px;max-height:60vh}.dropdown-checkbox-item{margin-right:20px}.custom-control-label{cursor:pointer;white-space:nowrap}"]
            }] }
];
/** @nocollapse */
ColumnVisibilityComponent.ctorParameters = () => [];
ColumnVisibilityComponent.propDecorators = {
    myDrop: [{ type: ViewChild, args: [NgbDropdown, { static: false },] }],
    dataGrid: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    ColumnVisibilityComponent.prototype.myDrop;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.gridInstance;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.orderedColumns;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.visible;
    /** @type {?} */
    ColumnVisibilityComponent.prototype.dataGrid;
}
//# sourceMappingURL=data:application/json;base64,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