/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { I18NextPipe } from 'angular-i18next';
export class NwfFilterCriterionDateComponent {
    /**
     * @param {?} i18NextPipe
     */
    constructor(i18NextPipe) {
        this.datetime = '';
        // List of default date selections for the user
        this.dateRangeList = [
            { id: 'LAST_1h', label: '' },
            { id: 'LAST_24h', label: '' },
            { id: 'LAST_72h', label: '' },
            { id: 'LAST_7d', label: '' },
            { id: 'LAST_30d', label: '' },
            { id: 'LAST_390d', label: '' },
        ];
        // i18n the values (displayed label in the drop down)
        for (const dateRangeList of this.dateRangeList) {
            // pop in the the label translated (the key is e.g. last_1h)
            dateRangeList.label = i18NextPipe.transform(`nwfjs:${dateRangeList.id.toLowerCase()}`);
        }
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ngOnChanges(changes) {
        // on every operator change, we set the dateTime, dateTimeVisibleValue based on operator value.
        // we can have 3 types of operator.
        // 1. <=, >=, 2. between, 3. in the last(last)
        if (!changes.operator.isFirstChange()) {
            // if current value is <=, >=, we set dateTimeVisibleValue to current Date
            if (['<=', '>='].indexOf(changes.operator.currentValue) !== -1) {
                this.datetime = new Date().toISOString();
                this.datetimeVisibleValue = new Date();
            }
            else if (changes.operator.currentValue === 'between') {
                this.datetime = `${new Date().toISOString()}~${new Date().toISOString()}`;
            }
            else {
                this.datetime = '';
            }
            // sending out new value.
            this.onValueModelChange(this.datetime);
        }
    }
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component.This value is pre-set value to datetime widget.
     * @param {?} value
     * @return {?}
     */
    writeValue(value) {
        // we default datetime to last_72h, in case there is no value set.
        this.datetime = value;
        this.datetimeVisibleValue = new Date(this.datetime);
    }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnChange(fn) { this._onChange = fn; }
    /**
     * @param {?} fn
     * @return {?}
     */
    registerOnTouched(fn) { }
    /**
     * This method is called whenever model tied to the component changes.
     * This is outgoing value from this widget.
     * @param {?} newDateValue
     * @return {?}
     */
    onValueModelChange(newDateValue) {
        this.datetimeVisibleValue = new Date(newDateValue);
        this._onChange(newDateValue);
    }
}
NwfFilterCriterionDateComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-filter-criterion-date',
                template: `
    <select class="form-control custom-select mr-2" required data-netapp-id="filter-widget-select-operator" *ngIf="operator === 'lst'"
    (change)="onValueModelChange($event.target.value)" [(ngModel)]="datetime">
        <option [selected]="!datetime" value>{{'nwfjs:choose' | i18next}}</option>
        <option [selected]="datetime == dateRange.id" *ngFor="let dateRange of dateRangeList" [value]="dateRange.id">{{dateRange.label}}</option>
    </select>

    <div *ngIf="operator === 'between'" (click)="$event.stopPropagation()">
        <nwf-datetime-range-picker [(ngModel)]="datetime" (ngModelChange)="onValueModelChange($event)"></nwf-datetime-range-picker>
    </div>

    <div *ngIf="operator === '>=' || operator === '<='" (click)="$event.stopPropagation()">
        <ng-template #datetimePickerTemplate>
            <nwf-datetime-picker [(ngModel)]="datetime" (ngModelChange)="onValueModelChange($event)"></nwf-datetime-picker>
        </ng-template>
        <button type="button" class="d-flex align-items-center form-control" [ngbPopover]="datetimePickerTemplate" [popoverClass]="'max-width-none is-arrowless'" placement="bottom" data-netapp-id="filter-widget-btn">
            <nwf-icon iconClass="icon-action-calendar"></nwf-icon>
            <label data-netapp-id="dateTimePicker-widget-label">{{ datetimeVisibleValue | i18nextFormat: { format: 'datetime' } }}</label>
        </button>
    </div>
    `,
                providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: NwfFilterCriterionDateComponent,
                        multi: true,
                    }]
            }] }
];
/** @nocollapse */
NwfFilterCriterionDateComponent.ctorParameters = () => [
    { type: I18NextPipe }
];
NwfFilterCriterionDateComponent.propDecorators = {
    operator: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.operator;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetime;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.datetimeVisibleValue;
    /** @type {?} */
    NwfFilterCriterionDateComponent.prototype.dateRangeList;
    /**
     * @type {?}
     * @private
     */
    NwfFilterCriterionDateComponent.prototype._onChange;
}
//# sourceMappingURL=data:application/json;base64,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