/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { BrowserModule } from '@angular/platform-browser';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { I18NextModule } from 'angular-i18next';
import { DxDataGridModule, DxScrollViewModule } from 'devextreme-angular';
import { NwfjsSharedComponentsModule } from '../components/nwfjs.shared-components.module';
import { NwfFormModule } from '../form/form.module';
import { NwfjsSharedPipesModule } from '../pipes/nwfjs.shared-pipes.module';
import { CellHeaderComponent } from './cells/cells-header.component';
import { CellsComponent } from './cells/cells.component';
import { ColumnVisibilityComponent } from './column-visibility/column-visibility.component';
import { FilterCriterionRowComponent } from './filter/filter-criterion-row/filter-criterion-row.component';
import { NwfFilterCriterionDateComponent } from './filter/filter-date/filter-date.component';
import { FilterMultiselectComponent } from './filter/filter-multiselect/filter-multiselect.component';
import { NwfFilterComponent } from './filter/filter.component';
import { FooterComponent } from './footer/footer.component';
import { NwfGridOptionsService } from './grid-options.service';
import { SearchComponent } from './search/search.component';
/** @type {?} */
const allComponents = [
    SearchComponent, ColumnVisibilityComponent,
    NwfFilterComponent, FilterMultiselectComponent, FilterCriterionRowComponent,
    NwfFilterCriterionDateComponent, FooterComponent, CellsComponent, CellHeaderComponent,
];
export class NwfGridModule {
    constructor() { }
}
NwfGridModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    NgbModule,
                    CommonModule,
                    BrowserModule,
                    ReactiveFormsModule,
                    FormsModule,
                    NwfFormModule,
                    I18NextModule,
                    NwfjsSharedComponentsModule,
                    DxDataGridModule,
                    DxScrollViewModule,
                    NwfjsSharedPipesModule,
                ],
                providers: [NwfGridOptionsService],
                declarations: allComponents,
                exports: allComponents,
            },] }
];
/** @nocollapse */
NwfGridModule.ctorParameters = () => [];
//# sourceMappingURL=data:application/json;base64,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