/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { DxiDataGridColumn } from 'devextreme-angular/ui/nested/base/data-grid-column-dxi';
import { assign, get } from 'lodash-es';
export class NwfGridSchemaProcessor {
    /**
     * @param {?} schemaObject
     * @param {?=} schemaIdToDxColumn
     * @param {?=} customSchemaTypeToDxColumn
     */
    constructor(schemaObject, schemaIdToDxColumn = {}, customSchemaTypeToDxColumn) {
        /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
            so we allow the user to provide us with custom schemaType to DxColumns,
            but we also handle a standard dataType provided by nwf, to make it easy.
            Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
        */
        this.columns = [];
        this.filterableColumns = [];
        this.schemaTypeToDxColumn = {
            dateTime: NwfDateColumn,
            metric: NwfMetricColumn,
            number: NwfNumberColumn,
        };
        for (const columnId in schemaObject) {
            if (schemaObject.hasOwnProperty(columnId)) {
                /** @type {?} */
                const schemaProp = schemaObject[columnId];
                /** @type {?} */
                const hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                // updating schemaTypeToDxColumn mapping.
                this.schemaTypeToDxColumn = assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                /** @type {?} */
                const hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                /** @type {?} */
                let dxColumnObject;
                /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                    This is because I want to allow the user to easily customize the cell based on the id.
                    for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                    mapped type.
                */
                if (hasMatchingId) {
                    dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                }
                else if (hasMatchingType) {
                    /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                        This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                    */
                    dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                }
                else {
                    /* now I dont know */
                    dxColumnObject = new NwfSchemaColumn(schemaProp);
                }
                this.columns.push(dxColumnObject);
                // finding all filterable properties.
                if (schemaProp.filterable) {
                    this.filterableColumns.push(schemaProp);
                }
            }
        }
    }
}
if (false) {
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.columns;
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.filterableColumns;
    /**
     * @type {?}
     * @private
     */
    NwfGridSchemaProcessor.prototype.schemaTypeToDxColumn;
}
export class NwfSchemaColumn extends DxiDataGridColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super();
        this.allowHeaderFiltering = false;
        this.visible = true;
        this.allowFiltering = true;
        this.allowSorting = true;
        this.allowHiding = true;
        this.allowReordering = true;
        this.cellTemplate = 'nwfDefaultCellTemplate';
        const { id, label, type, options, visible } = schemaProp;
        // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
        // we identify the column by name later to set options.
        this.name = this.dataField = id;
        // set a descriptive or friendly name for the column.
        this.caption = label;
        // our type field is pretty close to the default dataTypes (which are just lowercased strings)
        // this can be improved if we have other types, but I bet it will work.
        this.dataType = type.toLowerCase();
        // we allow search only for columns having 'resource','string', or associatedObjects dataType;
        this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(this.dataType) !== -1;
        this.allowFiltering = get(schemaProp, 'filterable', this.allowFiltering);
        this.allowSorting = get(schemaProp, 'sortable', this.allowSorting);
        this.allowReordering = get(schemaProp, 'allowReordering', this.allowReordering);
        // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
        this.editorOptions = options;
        this.showInColumnChooser = visible;
    }
}
if (false) {
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHeaderFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.visible;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowSorting;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHiding;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowReordering;
    /** @type {?} */
    NwfSchemaColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfSchemaColumn.prototype._optionPath;
}
export class NwfNumberColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfNumberCellTemplate';
    }
}
if (false) {
    /** @type {?} */
    NwfNumberColumn.prototype.cellTemplate;
}
export class NwfMetricColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfMetricCellTemplate';
        this.unit = schemaProp.unit;
    }
}
if (false) {
    /** @type {?} */
    NwfMetricColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfMetricColumn.prototype.unit;
}
export class NwfDateColumn extends NwfSchemaColumn {
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.cellTemplate = 'nwfDateCellTemplate';
    }
}
if (false) {
    /** @type {?} */
    NwfDateColumn.prototype.cellTemplate;
}
export class NwfStatusColumn extends NwfSchemaColumn {
    // creating a cell template based on UX requirements.
    /**
     * @param {?} schemaProp
     */
    constructor(schemaProp) {
        super(schemaProp);
        this.alignment = 'center';
        this.width = 80;
        this.cellTemplate = 'nwfStatusCellTemplate';
        this.calculateSortValue = (/**
         * @param {?} __0
         * @return {?}
         */
        ({ status }) => {
            // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
            // for possible status values.
            if (status.toLowerCase() === 'critical') {
                status = 'z'; // Critical are always displayed at the top
            }
            return status;
        });
    }
}
if (false) {
    /** @type {?} */
    NwfStatusColumn.prototype.alignment;
    /** @type {?} */
    NwfStatusColumn.prototype.width;
    /** @type {?} */
    NwfStatusColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfStatusColumn.prototype.calculateSortValue;
}
//# sourceMappingURL=data:application/json;base64,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