/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { Subject } from 'rxjs';
import { debounceTime, map } from 'rxjs/operators';
export class SearchComponent {
    /**
     * @param {?} i18NextPipe
     */
    constructor(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.keyUp = new Subject();
        this.value = '';
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.type = this.i18NextPipe.transform(this.typeKey);
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        (data) => {
            /** @type {?} */
            const gridInstance = data.component.instance();
            this.value = gridInstance.state().searchText;
            this.setSearchOnDxGrid();
        }));
        // on keyUp, we get the value of the event,
        // wait for 3s, and then set the search on dxGridInstance.
        this.keyUp
            .pipe(map((/**
         * @param {?} event
         * @return {?}
         */
        (event) => event.target.value)))
            .pipe(debounceTime(1000))
            .subscribe((/**
         * @return {?}
         */
        () => this.setSearchOnDxGrid()));
    }
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    resetInput() {
        this.value = '';
        this.setSearchOnDxGrid();
    }
    /**
     * @return {?}
     */
    setSearchOnDxGrid() {
        // apply search text.
        this.dataGrid.instance.searchByText(this.value);
    }
}
SearchComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-grid-search',
                template: `
    <label class="sr-only" for="grid-search"></label>
    <div class="position-relative">
      <input
        id="grid-search"
        #searchInput
        class="form-control form-control-sm grid-search-input"
        type="text"
        (keyup)="keyUp.next($event)"
        [placeholder]="'nwfjs:searchPlaceholderText' | i18next: { type: type }"
        [(ngModel)]="value"
        data-netapp-id="grid-search"
        name="grid-search"
      />
      <div class="search-actions h-100 d-inline-flex align-items-center pr-2">
        <div class="d-inline-flex pr-1 border-0" [ngClass]="{ invisible: !value }" (click)="resetInput()">
          <nwf-icon iconClass="icon-action-close"></nwf-icon>
        </div>
        <div class="d-inline-flex mag-icon" (click)="searchInput.focus()">
          <nwf-icon iconClass="icon-view-search"></nwf-icon>
        </div>
      </div>
    </div>
  `,
                host: {
                    class: 'text-nowrap',
                },
                styles: [".search-actions{position:absolute;right:0;top:0;color:#2d6dde}:host .grid-search-input{padding-right:45px}:host .grid-search-input[placeholder]{text-overflow:ellipsis}"]
            }] }
];
/** @nocollapse */
SearchComponent.ctorParameters = () => [
    { type: I18NextPipe }
];
SearchComponent.propDecorators = {
    typeKey: [{ type: Input }],
    dataGrid: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    SearchComponent.prototype.typeKey;
    /** @type {?} */
    SearchComponent.prototype.dataGrid;
    /** @type {?} */
    SearchComponent.prototype.keyUp;
    /** @type {?} */
    SearchComponent.prototype.placeholderText;
    /** @type {?} */
    SearchComponent.prototype.value;
    /** @type {?} */
    SearchComponent.prototype.type;
    /**
     * @type {?}
     * @private
     */
    SearchComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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