/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Pipe } from '@angular/core';
import { I18NextFormatPipe } from 'angular-i18next';
export class NwfRoundUnit {
    /**
     * @param {?} i18NextPipeFormatPipe
     */
    constructor(i18NextPipeFormatPipe) {
        this.i18NextPipeFormatPipe = i18NextPipeFormatPipe;
        this.units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB'];
    }
    /**
     * @param {?} value
     * @param {?} config
     * @return {?}
     */
    transform(value, config) {
        // tslint:disable-next-line: prefer-const
        let { unit, statType } = config;
        /** @type {?} */
        const isPercent = (unit === '%');
        if (this.units.indexOf(unit) >= 0) {
            const { value: newValue, unit: newUnit } = this.getReadable(value, unit);
            value = newValue;
            unit = newUnit;
        }
        /** @type {?} */
        let text = this.round(value, isPercent, statType);
        if (text) { // parsing through number locale if value is truthy.if (value !== null) {
            if (!isNaN(parseFloat(text))) {
                // Use i18next formatting for number
                text = this.i18NextPipeFormatPipe.transform(parseFloat(text), { format: 'number' });
            }
            if (unit) { // add unit only if unit is not undefined and not null
                text += (isPercent ? '' : ' ') + unit;
            }
            return text;
        }
        else {
            return 'N/A';
        }
    }
    /**
     * @param {?} value
     * @param {?=} isPercent
     * @param {?=} statType
     * @return {?}
     */
    round(value, isPercent = false, statType = '') {
        if (value === null) { //  return null if null
            return null;
        }
        else if (value === 0) {
            return '0';
        }
        if (isPercent) {
            if (value < 1) { // "<1" if < 1
                return '< 1';
            }
            else { // Whole number otherwise
                return parseFloat(value).toFixed();
            }
        }
        else {
            if (value < 1) {
                switch (statType) {
                    case 'latency':
                        return parseFloat(value).toFixed(3); // 3 decimal points between 0 and 1 for Latency
                    default:
                        return '< 1'; // "<1" if < 1 for everything else
                }
            }
            else if (value < 10 && value >= 1) { // 2 decimal points between 1 and 10
                return parseFloat(value).toFixed(2);
            }
            else if (value < 100 && value >= 10) { // 1 decimal point between 10 and  100
                return parseFloat(value).toFixed(1);
            }
            else if (value >= 100) { // Whole number if greater than 100
                return parseFloat(value).toFixed();
            }
            else {
                return value;
            }
        }
    }
    /**
     * @param {?} value
     * @param {?} unit
     * @return {?}
     */
    getReadable(value, unit) {
        /** @type {?} */
        let idx = this.units.indexOf(unit);
        /** @type {?} */
        let result;
        // we always need a value handling undefined case
        while (value && !(value >= 1 && value < 1024)) {
            if (value < 1) {
                // The current unit is too big
                if (idx > 0) {
                    // Decrease the unit by one level
                    value *= 1024.0;
                    idx -= 1;
                }
                else {
                    // The current unit is KB, there is no smaller unit, we have the result
                    result = { value, unit: this.units[idx] };
                    break;
                }
            }
            if (value >= 1024) {
                // The current unit is too small
                if (idx < this.units.length - 1) {
                    // Increase the unit by one level
                    value /= 1024.0;
                    idx += 1;
                }
                else {
                    // The current unit is PB, there is no bigger unit, we have the result
                    result = { value, unit: this.units[idx] };
                    break;
                }
            }
        }
        if (!result) {
            // The give arguments are proper value and unit
            result = { value, unit: this.units[idx] };
        }
        return result;
    }
}
NwfRoundUnit.decorators = [
    { type: Pipe, args: [{ name: 'NwfRoundUnit' },] }
];
/** @nocollapse */
NwfRoundUnit.ctorParameters = () => [
    { type: I18NextFormatPipe }
];
if (false) {
    /** @type {?} */
    NwfRoundUnit.prototype.units;
    /**
     * @type {?}
     * @private
     */
    NwfRoundUnit.prototype.i18NextPipeFormatPipe;
}
//# sourceMappingURL=data:application/json;base64,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