/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { DOCUMENT } from '@angular/common';
import { Inject } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { StateService, TransitionService } from '@uirouter/core';
import { NwfConfirmationModalComponent } from '../components/modals/confirmation/confirmation-modal.component';
/**
 * @record
 */
function INwfTakeoverModalOptions() { }
if (false) {
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.style;
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.confirmation;
}
export class NwfTakeoverModalService {
    /**
     * @param {?} ngbModal
     * @param {?} stateService
     * @param {?} document
     * @param {?} transitionService
     */
    constructor(ngbModal, stateService, document, transitionService) {
        this.ngbModal = ngbModal;
        this.stateService = stateService;
        this.document = document;
        this.transitionService = transitionService;
    }
    /**
     * @param {?} content
     * @param {?=} options
     * @return {?}
     */
    open(content, options) {
        /** @type {?} */
        let modalOptions = { style: '', confirmation: true };
        if (options) {
            modalOptions = Object.assign({}, modalOptions, options);
        }
        /** @type {?} */
        const takoverModalCls = 'nwf-takeover-modal';
        /** @type {?} */
        const contain = 'main';
        /** @type {?} */
        const fullCls = 'is-full';
        /** @type {?} */
        const doc = this.document.body;
        /** @type {?} */
        let ngbTakeoverCls = takoverModalCls;
        if (modalOptions.style == 'full') {
            ngbTakeoverCls += ` ${fullCls}`;
        }
        doc.classList.add(takoverModalCls);
        /** @type {?} */
        const takeoverModalOptions = {
            windowClass: ngbTakeoverCls,
            backdrop: false,
            container: contain,
        };
        /** @type {?} */
        const tearDown = (/**
         * @return {?}
         */
        function () {
            doc.classList.remove(takoverModalCls);
            window.scrollTo(0, 0);
            exitTrans();
        });
        /* I only do the exit transition trap if they haven't explicitly set the option to false */
        /** @type {?} */
        const exitTrans = this.transitionService.onBefore({}, (/**
         * @param {?} trans
         * @return {?}
         */
        (trans) => {
            if (modalOptions.confirmation !== false) {
                /** @type {?} */
                const confirmModalRef = this.ngbModal.open(NwfConfirmationModalComponent, { backdrop: 'static', container: contain, windowClass: 'nwf-confirmation-modal-dialog' });
                confirmModalRef.componentInstance.title = 'nwfjs:areYouSure';
                confirmModalRef.componentInstance.message = 'nwfjs:loseProgress';
                confirmModalRef.result
                    .then((/**
                 * @return {?}
                 */
                () => {
                    /* Go ahead and dismiss the takeover, snip the transition */
                    exitTrans();
                    modalRef.dismiss();
                    const { name, params } = trans.to();
                    this.stateService.go(name, params);
                }))
                    .catch((/**
                 * @return {?}
                 */
                () => {
                    /* Just swallow the cancel action */
                }));
                /* Returning false, prevents the transition, this is the trap. */
                return false;
            }
            else {
                /* we have no confirmation trap, but we are transitioning out */
                modalRef.dismiss();
            }
        }));
        /** @type {?} */
        const modalRef = this.ngbModal.open(content, takeoverModalOptions);
        modalRef.result.then(tearDown).catch(tearDown);
        return modalRef;
    }
}
/** @nocollapse */
NwfTakeoverModalService.ctorParameters = () => [
    { type: NgbModal },
    { type: StateService },
    { type: Document, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
    { type: TransitionService }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.ngbModal;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.stateService;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.document;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.transitionService;
}
//# sourceMappingURL=data:application/json;base64,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