/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, HostListener, Input } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { AboutModalComponent } from './about-modal.component';
export class AboutComponent {
    /**
     * @param {?} modalService
     */
    constructor(modalService) {
        this.modalService = modalService;
    }
    /**
     * @param {?} e
     * @return {?}
     */
    onClick(e) {
        /** @type {?} */
        const modalRef = this.modalService.open(AboutModalComponent);
        /** @type {?} */
        const ci = modalRef.componentInstance;
        /* I'd like a cleaner way to do this, but this works for now */
        ci.productName = this.productName;
        ci.version = this.version;
        ci.systemId = this.systemId;
        ci.confText = this.confText;
        ci.copyright = this.copyright;
    }
    /**
     * @return {?}
     */
    ngOnInit() {
    }
}
AboutComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-about',
                host: {
                    class: 'dropdown-item',
                },
                template: `{{"nwfjs:about" | i18next}}`
            }] }
];
/** @nocollapse */
AboutComponent.ctorParameters = () => [
    { type: NgbModal }
];
AboutComponent.propDecorators = {
    productName: [{ type: Input }],
    version: [{ type: Input }],
    systemId: [{ type: Input }],
    confText: [{ type: Input }],
    copyright: [{ type: Input }],
    onClick: [{ type: HostListener, args: ['click', ['$event'],] }]
};
if (false) {
    /** @type {?} */
    AboutComponent.prototype.productName;
    /** @type {?} */
    AboutComponent.prototype.version;
    /** @type {?} */
    AboutComponent.prototype.systemId;
    /** @type {?} */
    AboutComponent.prototype.confText;
    /** @type {?} */
    AboutComponent.prototype.copyright;
    /** @type {?} */
    AboutComponent.prototype.modalService;
}
//# sourceMappingURL=data:application/json;base64,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