/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
export class GlobalSearchComponent {
    /**
     * @param {?} i18nextFormat
     */
    constructor(i18nextFormat) {
        this.i18nextFormat = i18nextFormat;
        this.value = '';
        this.subjectLabel = '';
        this.focusOnSearchClick = true;
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.enter = new EventEmitter();
        this.submit = new EventEmitter();
    }
    /**
     * Event emit on search button click.
     * @return {?}
     */
    onSubmit() {
        this.submit.emit(this.value);
        if (this.focusOnSearchClick) {
            this.inputEl.nativeElement.focus();
        }
    }
    /**
     * @return {?}
     */
    clear() {
        this.value = '';
        this.change.emit(this.value);
        this.inputEl.nativeElement.focus();
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.completeSubjectLabel = this.i18nextFormat.transform('nwfjs:searchPlaceholderText', { type: this.subjectLabel });
    }
}
GlobalSearchComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-global-search-input',
                template: "<div class=\"input-group\">\n  <label class=\"sr-only\" for=\"global-search\">{{completeSubjectLabel}}</label>\n  <div class=\"input-container\">\n    <input class=\"form-control py-2 border-0 nwf-global-search-input\" [(ngModel)]=\"value\" type=\"text\"\n      [placeholder]=\"completeSubjectLabel\" id=\"global-search\" autocomplete=\"off\" (input)=\"change.emit(value)\"\n      (keydown.enter)=\"enter.emit(value)\" (focus)=\"focus.emit(value)\" (blur)=\"blur.emit(value)\" #globalSearch>\n    <div class=\"row icon-container\">\n      <div [hidden]=\"!value\" class=\"border-0 close-icon\" (click)=\"clear()\">\n        <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n      </div>\n      <div class=\"border-0\" (click)=\"onSubmit()\">\n        <nwf-icon iconClass=\"icon-view-search\"></nwf-icon>\n      </div>\n    </div>\n  </div>\n</div>\n",
                styles: [".nwf-global-search-input{width:340px!important;color:#fff!important;background-color:#173e77!important;border-color:#173e77!important;padding-right:55px}.input-container{position:relative;width:340px!important}.icon-container{position:absolute;right:25px;top:7px;background-color:transparent;cursor:pointer;color:#fff}.close-icon{padding-right:7px}input[type=text]::-ms-clear{display:none}"]
            }] }
];
/** @nocollapse */
GlobalSearchComponent.ctorParameters = () => [
    { type: I18NextPipe }
];
GlobalSearchComponent.propDecorators = {
    inputEl: [{ type: ViewChild, args: ['globalSearch', { static: false },] }],
    value: [{ type: Input }],
    subjectLabel: [{ type: Input }],
    focusOnSearchClick: [{ type: Input }],
    change: [{ type: Output }],
    focus: [{ type: Output }],
    blur: [{ type: Output }],
    enter: [{ type: Output }],
    submit: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    GlobalSearchComponent.prototype.inputEl;
    /** @type {?} */
    GlobalSearchComponent.prototype.value;
    /** @type {?} */
    GlobalSearchComponent.prototype.subjectLabel;
    /** @type {?} */
    GlobalSearchComponent.prototype.focusOnSearchClick;
    /** @type {?} */
    GlobalSearchComponent.prototype.change;
    /** @type {?} */
    GlobalSearchComponent.prototype.focus;
    /** @type {?} */
    GlobalSearchComponent.prototype.blur;
    /** @type {?} */
    GlobalSearchComponent.prototype.enter;
    /** @type {?} */
    GlobalSearchComponent.prototype.submit;
    /** @type {?} */
    GlobalSearchComponent.prototype.completeSubjectLabel;
    /**
     * @type {?}
     * @private
     */
    GlobalSearchComponent.prototype.i18nextFormat;
}
//# sourceMappingURL=data:application/json;base64,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