/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbCollapse } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/core';
export class LeftnavItemComponent {
    /**
     * @param {?} stateService
     */
    constructor(stateService) {
        this.stateService = stateService;
        this.isTopLevel = false;
    }
    /**
     * @return {?}
     */
    toggleCollapsed() {
        this.item.isCollapsed = !this.item.isCollapsed;
    }
    /**
     * @return {?}
     */
    ngOnChanges() {
        this.itemNtapId = `leftnav-item-${this.item.label.toLowerCase()}-link`;
    }
    /**
     * @return {?}
     */
    onClick() {
        if (this.item.children) {
            this.toggleCollapsed();
        }
        else if (this.stateService.$current.parent.name === this.item.sref) {
            this.stateService.go('^', {}, { reload: true });
        }
        else {
            this.stateService.go(this.item.sref, this.item.srefParams);
        }
    }
}
LeftnavItemComponent.decorators = [
    { type: Component, args: [{
                selector: '[nwfLeftnavItem]',
                template: "<!-- header has a label, no sref, and no children -->\n<div *ngIf=\"item.label && !item.sref && !item.children\" class=\"nwf-leftnav-item-header flex-grow-1\">{{item.label | i18next}}</div>\n\n<!-- item link has a label -->\n<a *ngIf=\"item.label && item.children || item.label && item.sref\" class=\"nwf-leftnav-item-link flex-grow-1\" (click)=\"onClick()\"\n    [attr.data-netapp-id]=\"itemNtapId\" \n    [ngClass]=\"{'is-active': item.isActive, 'is-toplevel': isTopLevel, 'is-open': !item.isCollapsed }\">\n    <span class=\"nwf-leftnav-item-label\">{{item.label | i18next }}</span>\n    <nwf-icon class=\"nwf-leftnav-item-toggler\" *ngIf=\"item.children && item.children.length\"\n        [iconClass]=\"item.isCollapsed ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\"></nwf-icon>\n</a>\n<!-- submenus have optional children -->\n<ul *ngIf=\"item.children && item.children.length\" class=\"nwf-leftnav-items pl-0\" [ngbCollapse]=\"item.isCollapsed\"\n    [attr.data-netapp-id]=\"'leftnav-item-group-' + item.label | lowercase\">\n    <li *ngFor=\"let child of item.children\" nwfLeftnavItem [item]=\"child\"\n        class=\"nwf-leftnav-item is-submenu d-block flex-grow-1\"\n    ></li>\n</ul>\n",
                providers: [NgbCollapse],
                styles: [":host{color:#fff;line-height:16px}:host:hover{color:#fff}:host[istoplevel]:first-child{border-top:1px solid #08214b}:host[istoplevel] ul{border-bottom:1px solid #08214b}.nwf-leftnav-item-header{display:flex;margin-top:30px;border-bottom:1px solid #08214b;color:#a5bfed;align-items:center;padding:8px 8px 8px 24px;text-transform:uppercase;font-size:12px;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link{display:flex;align-items:center;padding:8px 8px 8px 12px;text-transform:capitalize;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link:hover{background:#7ba1e5}.nwf-leftnav-item-link:hover ::ng-deep #base-layer{fill:#fff}.nwf-leftnav-item-link.is-active{background-color:#a5bfed;color:#131313}.nwf-leftnav-item-link.is-open{border-bottom:none!important}.nwf-leftnav-item-link.is-toplevel{border-bottom:1px solid #08214b;padding:12px;border-left:4px solid transparent;letter-spacing:1px;font-weight:700;text-transform:uppercase}.nwf-leftnav-item-link.is-toplevel.is-active{color:#fff;background-color:#08214b;border-left-color:#a5bfed}.nwf-leftnav-item-link.is-toplevel.is-active:hover{background-color:#030d1d}.nwf-leftnav-item-link:not([href]){cursor:pointer}nwf-icon.nwf-leftnav-item-toggler{margin-right:12px}nwf-icon.nwf-leftnav-item-toggler ::ng-deep #base-layer{fill:#a5bfed}.nwf-leftnav-item-label{margin-left:12px;flex-grow:1}.is-submenu .nwf-leftnav-item-label{margin-left:16px}"]
            }] }
];
/** @nocollapse */
LeftnavItemComponent.ctorParameters = () => [
    { type: StateService }
];
LeftnavItemComponent.propDecorators = {
    item: [{ type: Input }],
    isTopLevel: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LeftnavItemComponent.prototype.item;
    /** @type {?} */
    LeftnavItemComponent.prototype.isTopLevel;
    /** @type {?} */
    LeftnavItemComponent.prototype.itemNtapId;
    /**
     * @type {?}
     * @private
     */
    LeftnavItemComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,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