/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Inject, Input } from '@angular/core';
import { StateService, TargetState } from '@uirouter/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { I18NextPipe } from 'angular-i18next';
import { repeat } from 'lodash-es';
import { interval } from 'rxjs';
import { map } from 'rxjs/operators';
import { NwfConfirmationModalComponent } from '../../components/modals/confirmation/confirmation-modal.component';
import { NwfTitleService } from '../title/title.service';
export class LoginComponent {
    /**
     * @param {?} NwfAuthService
     * @param {?} $state
     * @param {?} modalService
     * @param {?} titleService
     * @param {?} i18NextPipe
     */
    constructor(NwfAuthService, $state, modalService, titleService, i18NextPipe) {
        this.NwfAuthService = NwfAuthService;
        this.$state = $state;
        this.modalService = modalService;
        this.titleService = titleService;
        this.i18NextPipe = i18NextPipe;
        this.showHelp = true;
        this.authToken = null;
        this.resetUsername = null;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        // Forgot Password is off by default and enabled when I have provided it
        this.hasForgotPassword = false;
        this.hasResetPassword = false;
        this.forgotPasswordMode = false;
        // Reset Password
        this.resetPasswordMode = false;
        this.resetPasswordMatch = true;
        this.cnter = 0;
        this.loadingObs = interval(1000).pipe(map((/**
         * @param {?} value
         * @return {?}
         */
        (value) => {
            this.cnter++;
            if (this.cnter > 3) {
                this.cnter = 0;
            }
            return repeat('.', this.cnter);
        })));
        this.creds = { username: '', password: '' };
        this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
        this.forgotCreds = { username: '' };
        /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
        if (NwfAuthService.forgotPassword) {
            this.hasForgotPassword = true;
        }
        if (NwfAuthService.resetPassword) {
            this.hasResetPassword = true;
        }
        this.titleService.setTitle('nwfjs:login');
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        if (this.hasResetPassword && this.resetUsername !== null && this.authToken !== null) {
            this.resetPasswordMode = true;
            this.forgotPasswordMode = false;
            this.resetCreds.authToken = this.authToken;
            this.resetCreds.username = this.resetUsername;
        }
        this.updateHrefs();
    }
    /**
     * @return {?}
     */
    authenticate() {
        this.inFlight = true;
        /** @type {?} */
        const returnToOriginalState = (/**
         * @return {?}
         */
        () => {
            /** @type {?} */
            const state = this.returnTo.state();
            /** @type {?} */
            const params = this.returnTo.params();
            /** @type {?} */
            const options = Object.assign({}, this.returnTo.options(), { reload: true });
            this.$state.go(state, params, options);
        });
        /** @type {?} */
        const showError = (/**
         * @param {?} error
         * @return {?}
         */
        (error) => {
            this.inFlight = false;
            /** @type {?} */
            const errorCode = error.status;
            /** @type {?} */
            const failedModal = this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = this.i18NextPipe.transform('nwfjs:error');
            if (errorCode !== 0) {
                failedModal.message = this.i18NextPipe.transform('nwfjs:loginFailedAuthenticationFailed');
            }
            else {
                failedModal.message = this.i18NextPipe.transform('nwfjs:loginFailedUnableAccessServer');
            }
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        const { username, password } = this.creds;
        this.NwfAuthService.authenticate(username, password)
            .then(returnToOriginalState)
            .catch(showError)
            .then();
    }
    /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    updateHrefs() {
        /** @type {?} */
        const netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    }
    // forgot password on submit.
    /**
     * @return {?}
     */
    forgotPasswordSubmit() {
        const { username } = this.forgotCreds;
        this.inFlight = true;
        /** @type {?} */
        const showConfirm = (/**
         * @return {?}
         */
        () => {
            this.inFlight = false;
            /** @type {?} */
            const confirmModalInstance = this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            confirmModalInstance.title = this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = this.i18NextPipe.transform('nwfjs:loginForgetPasswordResetEmailSent', { username });
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        this.NwfAuthService.forgotPassword(username)
            .then(showConfirm)
            .then(stop, stop);
    }
    // Reset password on submit.
    /**
     * @return {?}
     */
    resetPasswordSubmit() {
        // Check if passwords match
        this.resetPasswordMatch = true;
        if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        this.inFlight = true;
        /** @type {?} */
        const showConfirm = (/**
         * @return {?}
         */
        () => {
            this.inFlight = false;
            /** @type {?} */
            const resetPasswordConformationModelRef = this.modalService.open(NwfConfirmationModalComponent);
            resetPasswordConformationModelRef.result.then((/**
             * @return {?}
             */
            () => {
                // after user clicks ok, redirect to home page
                window.location.replace('/');
            }));
            /** @type {?} */
            const confirmModalInstance = resetPasswordConformationModelRef.componentInstance;
            confirmModalInstance.title = this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = this.i18NextPipe.transform('nwfjs:resetPasswordSucceed');
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        /** @type {?} */
        const showError = (/**
         * @param {?} error
         * @return {?}
         */
        (error) => {
            this.inFlight = false;
            /** @type {?} */
            const failedModal = this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = this.i18NextPipe.transform('nwfjs:error');
            failedModal.message = this.i18NextPipe.transform('nwfjs:resetPasswordFailed');
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        const { username, newPassword } = this.resetCreds;
        this.NwfAuthService.resetPassword(username, newPassword, this.authToken)
            .then(showConfirm)
            .catch(showError)
            .then(stop, stop);
    }
    // Reset password on cancel.
    /**
     * @return {?}
     */
    resetPasswordCancelFn() {
        window.location.href = document.location.origin;
    }
    /**
     * @return {?}
     */
    forgotPasswordClick() {
        this.forgotPasswordMode = !this.forgotPasswordMode;
        this.forgotCreds.username = this.creds.username;
    }
}
LoginComponent.decorators = [
    { type: Component, args: [{
                selector: 'nwf-login',
                template: "<div class=\"nwf-login-overlay\">\n    <div class=\"nwf-login-dialog\">\n    <header class=\"nwf-login-banner-logo\"></header>\n    <div class=\"nwf-login-body\">\n        <h2 class=\"nwf-login-dialog-title-primary\">{{appTitle}}</h2>\n        <h3 class=\"nwf-login-dialog-title-secondary\"></h3>\n        <h5>{{message}}</h5>\n        <!-- Login form -->\n        <form #authForm=\"ngForm\" (ngSubmit)=\"authForm.valid && authenticate()\" *ngIf=\"!forgotPasswordMode && !resetPasswordMode\"\n            id=\"nwf-login-form\" class=\"nwf-validatable\" [ngClass]=\"{'ng-submitted': authForm.submitted }\">\n            <div class=\"form-group l-username\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"creds.username\"\n                       [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" autofocus required placeholder=\"{{'nwfjs:username' | i18next}}\">\n                    <div *ngIf=\"username.invalid && (authForm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" type=\"password\" name=\"password\" #password=\"ngModel\" [(ngModel)]=\"creds.password\"\n                        [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-password-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:password' | i18next}}\"\n                        required>\n                    <div *ngIf=\"password.invalid && (authForm.submitted || password.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group l-submit-btn mb-0\">\n                <button [attr.type]=\"inFlight ? 'button': 'submit'\" class=\"nwf-login-input btn btn-primary btn-lg position-relative d-inline-block\"\n                    data-netapp-id=\"loginPage-signIn-button\">\n                    <div>{{'nwfjs:signIn' | i18next}} <span class=\"loading position-absolute\" [hidden]=\"!inFlight\">{{loadingObs | async}}</span></div>\n                </button>\n            </div>\n            <p *ngIf=\"hasForgotPassword\" class=\"nwf-login-forgot\">\n                <a class=\"nwf-is-link-like\" (click)=\"forgotPasswordClick()\" data-netapp-id=\"loginPage-forgot-password-link\">{{'nwfjs:forgetPassword' | i18next}}</a>\n            </p>\n        </form>\n\n        <!-- Forgot Password Form -->\n        <form #forgotFrm=\"ngForm\" class=\"nwf-validatable\" *ngIf=\"forgotPasswordMode\" (ngSubmit)=\"forgotFrm.valid && forgotPasswordSubmit()\" [ngClass]=\"{'ng-submitted': forgotFrm.submitted }\">\n\n            <div class=\"nwf-forgot-password-title-panel\">\n                <div class=\"nwf-forgot-password-text\" data-netapp-id=\"loginPage-forgot-password-text\">\n                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"forgotCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:usernameToReset' | i18next}}\"\n                        required>\n                    <div *ngIf=\"username.invalid && (forgotFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n            <!-- Submit/Cancel for Forgot Password  -->\n            <div class=\"nwf-login-row\">\n                <div class=\"nwf-login-button-panel\">\n                    <button class=\"btn btn-primary mr-2\" data-netapp-id=\"forgotPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                    <button class=\"btn btn-secondary\" (click)=\"forgotPasswordMode = false\" data-netapp-id=\"forgotPassword-cancel-button\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n                </div>\n            </div>\n            </div>\n        </form>\n\n        <!-- Reset password Form -->\n        <form #resetFrm=\"ngForm\"  *ngIf=\"resetPasswordMode\" (ngSubmit)=\"resetFrm.valid && resetPasswordSubmit()\" [ngClass]=\"{'ng-submitted': resetFrm.submitted }\">\n\n            <dl>\n                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" autocomplete=\"off\" [(ngModel)]=\"resetCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" title=\"{{'nwfjs:usernameCannotChange' | i18next}}\" required disabled=\"true\">\n                    <div *ngIf=\"username.invalid && (resetFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:newPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"newPassword\" #newPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.newPassword\" data-netapp-id=\"loginPage-new-password-input\" placeholder=\"{{'nwfjs:typeNewPassword' | i18next}}\" required>\n                    <div *ngIf=\"newPassword.invalid && (resetFrm.submitted || newPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"confirmNewPassword\" #confirmNewPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.confirmNewPassword\" name=\"confirmNewPassword\" data-netapp-id=\"loginPage-confirm-new-password-input\"\n                        placeholder=\"{{'nwfjs:typeNewPasswordAgain' | i18next}}\" required>\n                    <div *ngIf=\"confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                    <div *ngIf=\"!resetPasswordMatch\" class=\"invalid-feedback\">\n                        {{'nwfjs:changePasswordNotMatch' | i18next}}\n                    </div>\n                </dd>\n            </dl>\n\n            <div class=\"nwf-login-button-panel\">\n                <button class=\"btn btn-primary mr-2\" data-netapp-id=\"resetPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                <button class=\"btn btn-secondary\" data-netapp-id=\"resetPassword-cancel-button\" (click)=\"resetPasswordCancelFn()\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n            </div>\n        </form>\n    </div>\n    <footer class=\"nwf-login-links\">\n        <!-- support -->\n        <a *ngIf=\"!isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{'nwfjs:netappSupport' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{supportLabel}}</a>\n        <span *ngIf=\"showHelp\">&nbsp;|&nbsp;</span>\n        <!-- help -->\n        <a *ngIf=\"showHelp\" nwf-help showIcon=\"false\" class=\"nwf-is-link-like\" data-netapp-id=\"help-link\">{{'nwfjs:help' | i18next}}</a>\n        <!-- home -->\n        &nbsp;|&nbsp;\n        <a *ngIf=\"!isOemVendor\" href=\"http://netapp.com\" target=\"_blank\" data-netapp-id=\"home-link\">{{'nwfjs:netapp' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"homeHref\" target=\"_blank\"  data-netapp-id=\"home-link\">{{homeLabel}}</a>\n    </footer>\n    </div>\n</div>",
                styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
            }] }
];
/** @nocollapse */
LoginComponent.ctorParameters = () => [
    { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
    { type: StateService },
    { type: NgbModal },
    { type: NwfTitleService },
    { type: I18NextPipe }
];
LoginComponent.propDecorators = {
    returnTo: [{ type: Input }],
    appTitle: [{ type: Input }],
    supportHref: [{ type: Input }],
    supportLabel: [{ type: Input }],
    helpHref: [{ type: Input }],
    helpLabel: [{ type: Input }],
    homeHref: [{ type: Input }],
    homeLabel: [{ type: Input }],
    showHelp: [{ type: Input }],
    authToken: [{ type: Input }],
    resetUsername: [{ type: Input }]
};
if (false) {
    /** @type {?} */
    LoginComponent.prototype.returnTo;
    /** @type {?} */
    LoginComponent.prototype.appTitle;
    /** @type {?} */
    LoginComponent.prototype.supportHref;
    /** @type {?} */
    LoginComponent.prototype.supportLabel;
    /** @type {?} */
    LoginComponent.prototype.helpHref;
    /** @type {?} */
    LoginComponent.prototype.helpLabel;
    /** @type {?} */
    LoginComponent.prototype.homeHref;
    /** @type {?} */
    LoginComponent.prototype.homeLabel;
    /** @type {?} */
    LoginComponent.prototype.showHelp;
    /** @type {?} */
    LoginComponent.prototype.authToken;
    /** @type {?} */
    LoginComponent.prototype.resetUsername;
    /** @type {?} */
    LoginComponent.prototype.isOemVendor;
    /** @type {?} */
    LoginComponent.prototype.homeVendorHref;
    /** @type {?} */
    LoginComponent.prototype.titleElement;
    /** @type {?} */
    LoginComponent.prototype.username;
    /** @type {?} */
    LoginComponent.prototype.password;
    /** @type {?} */
    LoginComponent.prototype.hasForgotPassword;
    /** @type {?} */
    LoginComponent.prototype.hasResetPassword;
    /** @type {?} */
    LoginComponent.prototype.forgotPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.newPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmNewPassword;
    /** @type {?} */
    LoginComponent.prototype.message;
    /** @type {?} */
    LoginComponent.prototype.success;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMatch;
    /** @type {?} */
    LoginComponent.prototype.cnter;
    /** @type {?} */
    LoginComponent.prototype.loadingObs;
    /** @type {?} */
    LoginComponent.prototype.errorCode;
    /** @type {?} */
    LoginComponent.prototype.inFlight;
    /** @type {?} */
    LoginComponent.prototype.creds;
    /** @type {?} */
    LoginComponent.prototype.resetCreds;
    /** @type {?} */
    LoginComponent.prototype.forgotCreds;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.titleService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9naW4uY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvc2hlbGwvbG9naW4vbG9naW4uY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQVUsTUFBTSxlQUFlLENBQUM7QUFDakUsT0FBTyxFQUFFLFlBQVksRUFBRSxXQUFXLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUUzRCxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sNEJBQTRCLENBQUM7QUFDdEQsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQzlDLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFDbkMsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUNoQyxPQUFPLEVBQUUsR0FBRyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDckMsT0FBTyxFQUFFLDZCQUE2QixFQUFFLE1BQU0sbUVBQW1FLENBQUM7QUFDbEgsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLHdCQUF3QixDQUFDO0FBT3pELE1BQU0sT0FBTyxjQUFjOzs7Ozs7OztJQXVEdkIsWUFBOEMsY0FBbUIsRUFBVSxNQUFvQixFQUFVLFlBQXNCLEVBQVUsWUFBNkIsRUFDbEosV0FBd0I7UUFERSxtQkFBYyxHQUFkLGNBQWMsQ0FBSztRQUFVLFdBQU0sR0FBTixNQUFNLENBQWM7UUFBVSxpQkFBWSxHQUFaLFlBQVksQ0FBVTtRQUFVLGlCQUFZLEdBQVosWUFBWSxDQUFpQjtRQUNsSixnQkFBVyxHQUFYLFdBQVcsQ0FBYTtRQTVDNUIsYUFBUSxHQUFHLElBQUksQ0FBQztRQUNoQixjQUFTLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLGtCQUFhLEdBQUcsSUFBSSxDQUFDO1FBRTlCLGdCQUFXLEdBQUcsS0FBSyxDQUFDO1FBR3BCLGlCQUFZLEdBQUcsSUFBSSxDQUFDO1FBRXBCLGFBQVEsR0FBRyxJQUFJLENBQUM7UUFDaEIsYUFBUSxHQUFHLElBQUksQ0FBQzs7UUFHaEIsc0JBQWlCLEdBQUcsS0FBSyxDQUFDO1FBQzFCLHFCQUFnQixHQUFHLEtBQUssQ0FBQztRQUN6Qix1QkFBa0IsR0FBRyxLQUFLLENBQUM7O1FBUzNCLHNCQUFpQixHQUFHLEtBQUssQ0FBQztRQUMxQix1QkFBa0IsR0FBRyxJQUFJLENBQUM7UUFFMUIsVUFBSyxHQUFHLENBQUMsQ0FBQztRQUNWLGVBQVUsR0FBUSxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUc7Ozs7UUFBQyxDQUFDLEtBQUssRUFBRSxFQUFFO1lBQ3ZELElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUNiLElBQUksSUFBSSxDQUFDLEtBQUssR0FBRyxDQUFDLEVBQUU7Z0JBQ2hCLElBQUksQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO2FBQ2xCO1lBQ0QsT0FBTyxNQUFNLENBQUMsR0FBRyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNuQyxDQUFDLEVBQUMsQ0FBQyxDQUFDO1FBS0csVUFBSyxHQUFHLEVBQUUsUUFBUSxFQUFFLEVBQUUsRUFBRSxRQUFRLEVBQUUsRUFBRSxFQUFFLENBQUM7UUFDdkMsZUFBVSxHQUFHLEVBQUUsUUFBUSxFQUFFLEVBQUUsRUFBRSxXQUFXLEVBQUUsRUFBRSxFQUFFLGtCQUFrQixFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsRUFBRSxFQUFFLENBQUM7UUFDdEYsZ0JBQVcsR0FBRyxFQUFFLFFBQVEsRUFBRSxFQUFFLEVBQUUsQ0FBQztRQUlsQyx5RkFBeUY7UUFDekYsSUFBSSxjQUFjLENBQUMsY0FBYyxFQUFFO1lBQy9CLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUM7U0FDakM7UUFDRCxJQUFJLGNBQWMsQ0FBQyxhQUFhLEVBQUU7WUFDOUIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQztTQUNoQztRQUNELElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7SUFFTSxRQUFRO1FBRVgsMklBQTJJO1FBQzNJLGdEQUFnRDtRQUNoRCxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsYUFBYSxLQUFLLElBQUksSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLElBQUksRUFBRTtZQUNqRixJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDO1lBQzlCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7WUFDaEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUMzQyxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1NBQ2pEO1FBQ0QsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3ZCLENBQUM7Ozs7SUFFTSxZQUFZO1FBQ2YsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7O2NBQ2YscUJBQXFCOzs7UUFBRyxHQUFHLEVBQUU7O2tCQUN6QixLQUFLLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUU7O2tCQUM3QixNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUU7O2tCQUMvQixPQUFPLHFCQUFRLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxFQUFFLEVBQUssRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFLENBQUU7WUFDbkUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxPQUFPLENBQUMsQ0FBQztRQUMzQyxDQUFDLENBQUE7O2NBQ0ssU0FBUzs7OztRQUFHLENBQUMsS0FBSyxFQUFFLEVBQUU7WUFDeEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7O2tCQUNoQixTQUFTLEdBQUcsS0FBSyxDQUFDLE1BQU07O2tCQUN4QixXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsQ0FBQyxpQkFBaUI7WUFDM0YsV0FBVyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUM5RCxJQUFJLFNBQVMsS0FBSyxDQUFDLEVBQUU7Z0JBQ2pCLFdBQVcsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsdUNBQXVDLENBQUMsQ0FBQzthQUM3RjtpQkFBTTtnQkFDSCxXQUFXLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLHFDQUFxQyxDQUFDLENBQUM7YUFDM0Y7WUFDRCxXQUFXLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztZQUMvQixXQUFXLENBQUMsTUFBTSxHQUFHLE9BQU8sQ0FBQztRQUNqQyxDQUFDLENBQUE7Y0FFSyxFQUFFLFFBQVEsRUFBRSxRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSztRQUN6QyxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUUsUUFBUSxDQUFDO2FBQy9DLElBQUksQ0FBQyxxQkFBcUIsQ0FBQzthQUMzQixLQUFLLENBQUMsU0FBUyxDQUFDO2FBQ2hCLElBQUksRUFBRSxDQUFDO0lBQ2hCLENBQUM7Ozs7Ozs7SUFLTSxXQUFXOztjQUVSLFVBQVUsR0FBRyxtQkFBbUI7UUFDdEMsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDaEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUM7U0FDOUI7UUFFRCxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRTtZQUNuQixJQUFJLENBQUMsV0FBVyxHQUFHLDZCQUE2QixDQUFDO1NBQ3BEO1FBRUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7UUFDekIsSUFBSSxJQUFJLENBQUMsUUFBUSxLQUFLLFVBQVUsRUFBRTtZQUM5QixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztTQUMzQjtJQUNMLENBQUM7Ozs7O0lBR00sb0JBQW9CO2NBQ2pCLEVBQUUsUUFBUSxFQUFFLEdBQUcsSUFBSSxDQUFDLFdBQVc7UUFDckMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7O2NBQ2YsV0FBVzs7O1FBQUcsR0FBRyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDOztrQkFDaEIsb0JBQW9CLEdBQWtDLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDLENBQUMsaUJBQWlCO1lBQ25JLG9CQUFvQixDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUN0RSxvQkFBb0IsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMseUNBQXlDLEVBQUUsRUFBRSxRQUFRLEVBQUUsQ0FBQyxDQUFDO1lBQ25ILG9CQUFvQixDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDeEMsb0JBQW9CLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUN6QyxDQUFDLENBQUE7UUFFRCxJQUFJLENBQUMsY0FBYyxDQUFDLGNBQWMsQ0FBQyxRQUFRLENBQUM7YUFDdkMsSUFBSSxDQUFDLFdBQVcsQ0FBQzthQUNqQixJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzFCLENBQUM7Ozs7O0lBR00sbUJBQW1CO1FBQ3RCLDJCQUEyQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1FBQy9CLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLEtBQUssSUFBSSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsRUFBRTtZQUNwRSxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLE9BQU87U0FDVjtRQUVELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDOztjQUNmLFdBQVc7OztRQUFHLEdBQUcsRUFBRTtZQUNyQixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQzs7a0JBQ2hCLGlDQUFpQyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLDZCQUE2QixDQUFDO1lBQy9GLGlDQUFpQyxDQUFDLE1BQU0sQ0FBQyxJQUFJOzs7WUFBQyxHQUFHLEVBQUU7Z0JBQy9DLDhDQUE4QztnQkFDOUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDakMsQ0FBQyxFQUFDLENBQUM7O2tCQUNHLG9CQUFvQixHQUFrQyxpQ0FBaUMsQ0FBQyxpQkFBaUI7WUFDL0csb0JBQW9CLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQ3RFLG9CQUFvQixDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1lBQ3hGLG9CQUFvQixDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDeEMsb0JBQW9CLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUN6QyxDQUFDLENBQUE7O2NBRUssU0FBUzs7OztRQUFHLENBQUMsS0FBSyxFQUFFLEVBQUU7WUFDeEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7O2tCQUNoQixXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsNkJBQTZCLENBQUMsQ0FBQyxpQkFBaUI7WUFDM0YsV0FBVyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUM5RCxXQUFXLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLDJCQUEyQixDQUFDLENBQUM7WUFDOUUsV0FBVyxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDL0IsV0FBVyxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUM7UUFDakMsQ0FBQyxDQUFBO2NBQ0ssRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFLEdBQUcsSUFBSSxDQUFDLFVBQVU7UUFDakQsSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLENBQUMsUUFBUSxFQUFFLFdBQVcsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO2FBQ25FLElBQUksQ0FBQyxXQUFXLENBQUM7YUFDakIsS0FBSyxDQUFDLFNBQVMsQ0FBQzthQUNoQixJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzFCLENBQUM7Ozs7O0lBR00scUJBQXFCO1FBQ3hCLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxHQUFHLFFBQVEsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDO0lBQ3BELENBQUM7Ozs7SUFFTSxtQkFBbUI7UUFDdEIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1FBQ25ELElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO0lBQ3BELENBQUM7OztZQXZNSixTQUFTLFNBQUM7Z0JBQ1AsUUFBUSxFQUFFLFdBQVc7Z0JBQ3JCLG1uUUFBcUM7O2FBRXhDOzs7OzRDQXdEZ0IsTUFBTSxTQUFDLGdCQUFnQjtZQXRFL0IsWUFBWTtZQUVaLFFBQVE7WUFNUixlQUFlO1lBTGYsV0FBVzs7O3VCQWNmLEtBQUs7dUJBRUwsS0FBSzswQkFDTCxLQUFLOzJCQUNMLEtBQUs7dUJBQ0wsS0FBSzt3QkFDTCxLQUFLO3VCQUNMLEtBQUs7d0JBQ0wsS0FBSzt1QkFFTCxLQUFLO3dCQUNMLEtBQUs7NEJBQ0wsS0FBSzs7OztJQVpOLGtDQUFzQzs7SUFFdEMsa0NBQWlDOztJQUNqQyxxQ0FBb0M7O0lBQ3BDLHNDQUFxQzs7SUFDckMsa0NBQWlDOztJQUNqQyxtQ0FBa0M7O0lBQ2xDLGtDQUFpQzs7SUFDakMsbUNBQWtDOztJQUVsQyxrQ0FBZ0M7O0lBQ2hDLG1DQUFpQzs7SUFDakMsdUNBQXFDOztJQUVyQyxxQ0FBMkI7O0lBQzNCLHdDQUFzQjs7SUFFdEIsc0NBQTJCOztJQUUzQixrQ0FBdUI7O0lBQ3ZCLGtDQUF1Qjs7SUFHdkIsMkNBQWlDOztJQUNqQywwQ0FBZ0M7O0lBQ2hDLDRDQUFrQzs7SUFDbEMscUNBQW1COztJQUNuQix5Q0FBdUI7O0lBQ3ZCLDRDQUEwQjs7SUFFMUIsaUNBQWU7O0lBQ2YsaUNBQWU7O0lBR2YsMkNBQWlDOztJQUNqQyw0Q0FBaUM7O0lBRWpDLCtCQUFpQjs7SUFDakIsb0NBTUk7O0lBRUosbUNBQWlCOztJQUNqQixrQ0FBZ0I7O0lBRWhCLCtCQUE4Qzs7SUFDOUMsb0NBQTZGOztJQUM3RixxQ0FBc0M7Ozs7O0lBRTFCLHdDQUFxRDs7Ozs7SUFBRSxnQ0FBNEI7Ozs7O0lBQUUsc0NBQThCOzs7OztJQUFFLHNDQUFxQzs7Ozs7SUFDMUoscUNBQWdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBJbmplY3QsIElucHV0LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IFN0YXRlU2VydmljZSwgVGFyZ2V0U3RhdGUgfSBmcm9tICdAdWlyb3V0ZXIvY29yZSc7XG5cbmltcG9ydCB7IE5nYk1vZGFsIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuaW1wb3J0IHsgSTE4TmV4dFBpcGUgfSBmcm9tICdhbmd1bGFyLWkxOG5leHQnO1xuaW1wb3J0IHsgcmVwZWF0IH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IGludGVydmFsIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBtYXAgfSBmcm9tICdyeGpzL29wZXJhdG9ycyc7XG5pbXBvcnQgeyBOd2ZDb25maXJtYXRpb25Nb2RhbENvbXBvbmVudCB9IGZyb20gJy4uLy4uL2NvbXBvbmVudHMvbW9kYWxzL2NvbmZpcm1hdGlvbi9jb25maXJtYXRpb24tbW9kYWwuY29tcG9uZW50JztcbmltcG9ydCB7IE53ZlRpdGxlU2VydmljZSB9IGZyb20gJy4uL3RpdGxlL3RpdGxlLnNlcnZpY2UnO1xuXG5AQ29tcG9uZW50KHtcbiAgICBzZWxlY3RvcjogJ253Zi1sb2dpbicsXG4gICAgdGVtcGxhdGVVcmw6ICcuL2xvZ2luLmNvbXBvbmVudC5odG1sJyxcbiAgICBzdHlsZVVybHM6IFsnLi9sb2dpbi5jb21wb25lbnQuc2NzcyddLFxufSlcbmV4cG9ydCBjbGFzcyBMb2dpbkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XG5cbiAgICBASW5wdXQoKSBwdWJsaWMgcmV0dXJuVG86IFRhcmdldFN0YXRlO1xuXG4gICAgQElucHV0KCkgcHVibGljIGFwcFRpdGxlOiBzdHJpbmc7XG4gICAgQElucHV0KCkgcHVibGljIHN1cHBvcnRIcmVmOiBzdHJpbmc7XG4gICAgQElucHV0KCkgcHVibGljIHN1cHBvcnRMYWJlbDogc3RyaW5nO1xuICAgIEBJbnB1dCgpIHB1YmxpYyBoZWxwSHJlZjogc3RyaW5nO1xuICAgIEBJbnB1dCgpIHB1YmxpYyBoZWxwTGFiZWw6IHN0cmluZztcbiAgICBASW5wdXQoKSBwdWJsaWMgaG9tZUhyZWY6IHN0cmluZztcbiAgICBASW5wdXQoKSBwdWJsaWMgaG9tZUxhYmVsOiBzdHJpbmc7XG5cbiAgICBASW5wdXQoKSBwdWJsaWMgc2hvd0hlbHAgPSB0cnVlO1xuICAgIEBJbnB1dCgpIHB1YmxpYyBhdXRoVG9rZW4gPSBudWxsO1xuICAgIEBJbnB1dCgpIHB1YmxpYyByZXNldFVzZXJuYW1lID0gbnVsbDtcblxuICAgIHB1YmxpYyBpc09lbVZlbmRvciA9IGZhbHNlO1xuICAgIHB1YmxpYyBob21lVmVuZG9ySHJlZjtcblxuICAgIHB1YmxpYyB0aXRsZUVsZW1lbnQgPSBudWxsO1xuXG4gICAgcHVibGljIHVzZXJuYW1lID0gbnVsbDtcbiAgICBwdWJsaWMgcGFzc3dvcmQgPSBudWxsO1xuXG4gICAgLy8gRm9yZ290IFBhc3N3b3JkIGlzIG9mZiBieSBkZWZhdWx0IGFuZCBlbmFibGVkIHdoZW4gSSBoYXZlIHByb3ZpZGVkIGl0XG4gICAgcHVibGljIGhhc0ZvcmdvdFBhc3N3b3JkID0gZmFsc2U7XG4gICAgcHVibGljIGhhc1Jlc2V0UGFzc3dvcmQgPSBmYWxzZTtcbiAgICBwdWJsaWMgZm9yZ290UGFzc3dvcmRNb2RlID0gZmFsc2U7XG4gICAgcHVibGljIG5ld1Bhc3N3b3JkO1xuICAgIHB1YmxpYyBjb25maXJtUGFzc3dvcmQ7XG4gICAgcHVibGljIGNvbmZpcm1OZXdQYXNzd29yZDtcblxuICAgIHB1YmxpYyBtZXNzYWdlO1xuICAgIHB1YmxpYyBzdWNjZXNzO1xuXG4gICAgLy8gUmVzZXQgUGFzc3dvcmRcbiAgICBwdWJsaWMgcmVzZXRQYXNzd29yZE1vZGUgPSBmYWxzZTtcbiAgICBwdWJsaWMgcmVzZXRQYXNzd29yZE1hdGNoID0gdHJ1ZTtcblxuICAgIHB1YmxpYyBjbnRlciA9IDA7XG4gICAgcHVibGljIGxvYWRpbmdPYnM6IGFueSA9IGludGVydmFsKDEwMDApLnBpcGUobWFwKCh2YWx1ZSkgPT4ge1xuICAgICAgICB0aGlzLmNudGVyKys7XG4gICAgICAgIGlmICh0aGlzLmNudGVyID4gMykge1xuICAgICAgICAgICAgdGhpcy5jbnRlciA9IDA7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHJlcGVhdCgnLicsIHRoaXMuY250ZXIpO1xuICAgIH0pKTtcblxuICAgIHB1YmxpYyBlcnJvckNvZGU7XG4gICAgcHVibGljIGluRmxpZ2h0O1xuXG4gICAgcHVibGljIGNyZWRzID0geyB1c2VybmFtZTogJycsIHBhc3N3b3JkOiAnJyB9O1xuICAgIHB1YmxpYyByZXNldENyZWRzID0geyB1c2VybmFtZTogJycsIG5ld1Bhc3N3b3JkOiAnJywgY29uZmlybU5ld1Bhc3N3b3JkOiAnJywgYXV0aFRva2VuOiAnJyB9O1xuICAgIHB1YmxpYyBmb3Jnb3RDcmVkcyA9IHsgdXNlcm5hbWU6ICcnIH07XG5cbiAgICBjb25zdHJ1Y3RvcihASW5qZWN0KCdOd2ZBdXRoU2VydmljZScpIHByaXZhdGUgTndmQXV0aFNlcnZpY2U6IGFueSwgcHJpdmF0ZSAkc3RhdGU6IFN0YXRlU2VydmljZSwgcHJpdmF0ZSBtb2RhbFNlcnZpY2U6IE5nYk1vZGFsLCBwcml2YXRlIHRpdGxlU2VydmljZTogTndmVGl0bGVTZXJ2aWNlLFxuICAgICAgICAgICAgICAgIHByaXZhdGUgaTE4TmV4dFBpcGU6IEkxOE5leHRQaXBlKSB7XG4gICAgICAgIC8qIEkgZGV0ZWN0IHRoZSBwcmVzZW5jZSBvZiBhIGZvcmdvdFBhc3N3b3JkIGFuZCByZXNldFBhc3N3b3JkIG1ldGhvZHMgaW4gdGhlIHN0cmF0ZWd5ICovXG4gICAgICAgIGlmIChOd2ZBdXRoU2VydmljZS5mb3Jnb3RQYXNzd29yZCkge1xuICAgICAgICAgICAgdGhpcy5oYXNGb3Jnb3RQYXNzd29yZCA9IHRydWU7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKE53ZkF1dGhTZXJ2aWNlLnJlc2V0UGFzc3dvcmQpIHtcbiAgICAgICAgICAgIHRoaXMuaGFzUmVzZXRQYXNzd29yZCA9IHRydWU7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy50aXRsZVNlcnZpY2Uuc2V0VGl0bGUoJ253ZmpzOmxvZ2luJyk7XG4gICAgfVxuXG4gICAgcHVibGljIG5nT25Jbml0KCkge1xuXG4gICAgICAgIC8vIElmIHRoZSBzZXJ2ZXIgc2VuZHMgYSB1c2VyIGFuZCBhdXRoVG9rZW4sIHRoZSBvbmx5IHVzZSBjYXNlIHdlIGhhdmUgaXMgdGhhdCB1c2VyIGhhcyBzZW5kIGEgcmVxdWVzdCB0byByZXNldCB0aGUgcGFzc3dvcmQgd2l0aCB0aGlzIFVSTC5cbiAgICAgICAgLy8gU2V0IHRoZSBib29sZWFuIHRvIHJlc2V0IHBhc3N3b3JkIHRvIGJlIHRydWUuXG4gICAgICAgIGlmICh0aGlzLmhhc1Jlc2V0UGFzc3dvcmQgJiYgdGhpcy5yZXNldFVzZXJuYW1lICE9PSBudWxsICYmIHRoaXMuYXV0aFRva2VuICE9PSBudWxsKSB7XG4gICAgICAgICAgICB0aGlzLnJlc2V0UGFzc3dvcmRNb2RlID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMuZm9yZ290UGFzc3dvcmRNb2RlID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLnJlc2V0Q3JlZHMuYXV0aFRva2VuID0gdGhpcy5hdXRoVG9rZW47XG4gICAgICAgICAgICB0aGlzLnJlc2V0Q3JlZHMudXNlcm5hbWUgPSB0aGlzLnJlc2V0VXNlcm5hbWU7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy51cGRhdGVIcmVmcygpO1xuICAgIH1cblxuICAgIHB1YmxpYyBhdXRoZW50aWNhdGUoKSB7XG4gICAgICAgIHRoaXMuaW5GbGlnaHQgPSB0cnVlO1xuICAgICAgICBjb25zdCByZXR1cm5Ub09yaWdpbmFsU3RhdGUgPSAoKSA9PiB7XG4gICAgICAgICAgICBjb25zdCBzdGF0ZSA9IHRoaXMucmV0dXJuVG8uc3RhdGUoKTtcbiAgICAgICAgICAgIGNvbnN0IHBhcmFtcyA9IHRoaXMucmV0dXJuVG8ucGFyYW1zKCk7XG4gICAgICAgICAgICBjb25zdCBvcHRpb25zID0geyAuLi50aGlzLnJldHVyblRvLm9wdGlvbnMoKSwgLi4ueyByZWxvYWQ6IHRydWUgfSB9O1xuICAgICAgICAgICAgdGhpcy4kc3RhdGUuZ28oc3RhdGUsIHBhcmFtcywgb3B0aW9ucyk7XG4gICAgICAgIH07XG4gICAgICAgIGNvbnN0IHNob3dFcnJvciA9IChlcnJvcikgPT4ge1xuICAgICAgICAgICAgdGhpcy5pbkZsaWdodCA9IGZhbHNlO1xuICAgICAgICAgICAgY29uc3QgZXJyb3JDb2RlID0gZXJyb3Iuc3RhdHVzO1xuICAgICAgICAgICAgY29uc3QgZmFpbGVkTW9kYWwgPSB0aGlzLm1vZGFsU2VydmljZS5vcGVuKE53ZkNvbmZpcm1hdGlvbk1vZGFsQ29tcG9uZW50KS5jb21wb25lbnRJbnN0YW5jZTtcbiAgICAgICAgICAgIGZhaWxlZE1vZGFsLnRpdGxlID0gdGhpcy5pMThOZXh0UGlwZS50cmFuc2Zvcm0oJ253ZmpzOmVycm9yJyk7XG4gICAgICAgICAgICBpZiAoZXJyb3JDb2RlICE9PSAwKSB7XG4gICAgICAgICAgICAgICAgZmFpbGVkTW9kYWwubWVzc2FnZSA9IHRoaXMuaTE4TmV4dFBpcGUudHJhbnNmb3JtKCdud2Zqczpsb2dpbkZhaWxlZEF1dGhlbnRpY2F0aW9uRmFpbGVkJyk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGZhaWxlZE1vZGFsLm1lc3NhZ2UgPSB0aGlzLmkxOE5leHRQaXBlLnRyYW5zZm9ybSgnbndmanM6bG9naW5GYWlsZWRVbmFibGVBY2Nlc3NTZXJ2ZXInKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGZhaWxlZE1vZGFsLnNob3dDYW5jZWwgPSBmYWxzZTtcbiAgICAgICAgICAgIGZhaWxlZE1vZGFsLnN0YXR1cyA9ICdlcnJvcic7XG4gICAgICAgIH07XG5cbiAgICAgICAgY29uc3QgeyB1c2VybmFtZSwgcGFzc3dvcmQgfSA9IHRoaXMuY3JlZHM7XG4gICAgICAgIHRoaXMuTndmQXV0aFNlcnZpY2UuYXV0aGVudGljYXRlKHVzZXJuYW1lLCBwYXNzd29yZClcbiAgICAgICAgICAgIC50aGVuKHJldHVyblRvT3JpZ2luYWxTdGF0ZSlcbiAgICAgICAgICAgIC5jYXRjaChzaG93RXJyb3IpXG4gICAgICAgICAgICAudGhlbigpO1xuICAgIH1cblxuICAgIC8qXG4gICAgcmVzcG9uc2libGUgZm9yIGhhdmluZyB0aGUgcmlnaHQgbGlua3MgYW5kIGRldGVybWluaW5nIGlmIHRoaXMgaXMgdmVuZG9yaXplZCBvciBub3RcbiAgICAqL1xuICAgIHB1YmxpYyB1cGRhdGVIcmVmcygpIHtcblxuICAgICAgICBjb25zdCBuZXRhcHBIb21lID0gJ2h0dHA6Ly9uZXRhcHAuY29tJztcbiAgICAgICAgaWYgKCF0aGlzLmhvbWVIcmVmKSB7XG4gICAgICAgICAgICB0aGlzLmhvbWVIcmVmID0gbmV0YXBwSG9tZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy5zdXBwb3J0SHJlZikge1xuICAgICAgICAgICAgdGhpcy5zdXBwb3J0SHJlZiA9ICdodHRwOi8vbXlzdXBwb3J0Lm5ldGFwcC5jb20nO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5pc09lbVZlbmRvciA9IGZhbHNlO1xuICAgICAgICBpZiAodGhpcy5ob21lSHJlZiAhPT0gbmV0YXBwSG9tZSkge1xuICAgICAgICAgICAgdGhpcy5pc09lbVZlbmRvciA9IHRydWU7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvLyBmb3Jnb3QgcGFzc3dvcmQgb24gc3VibWl0LlxuICAgIHB1YmxpYyBmb3Jnb3RQYXNzd29yZFN1Ym1pdCgpIHtcbiAgICAgICAgY29uc3QgeyB1c2VybmFtZSB9ID0gdGhpcy5mb3Jnb3RDcmVkcztcbiAgICAgICAgdGhpcy5pbkZsaWdodCA9IHRydWU7XG4gICAgICAgIGNvbnN0IHNob3dDb25maXJtID0gKCkgPT4ge1xuICAgICAgICAgICAgdGhpcy5pbkZsaWdodCA9IGZhbHNlO1xuICAgICAgICAgICAgY29uc3QgY29uZmlybU1vZGFsSW5zdGFuY2U6IE53ZkNvbmZpcm1hdGlvbk1vZGFsQ29tcG9uZW50ID0gdGhpcy5tb2RhbFNlcnZpY2Uub3BlbihOd2ZDb25maXJtYXRpb25Nb2RhbENvbXBvbmVudCkuY29tcG9uZW50SW5zdGFuY2U7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS50aXRsZSA9IHRoaXMuaTE4TmV4dFBpcGUudHJhbnNmb3JtKCdud2ZqczppbmZvJyk7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5tZXNzYWdlID0gdGhpcy5pMThOZXh0UGlwZS50cmFuc2Zvcm0oJ253ZmpzOmxvZ2luRm9yZ2V0UGFzc3dvcmRSZXNldEVtYWlsU2VudCcsIHsgdXNlcm5hbWUgfSk7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5zaG93Q2FuY2VsID0gZmFsc2U7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5zdGF0dXMgPSAnaW5mbyc7XG4gICAgICAgIH07XG5cbiAgICAgICAgdGhpcy5Od2ZBdXRoU2VydmljZS5mb3Jnb3RQYXNzd29yZCh1c2VybmFtZSlcbiAgICAgICAgICAgIC50aGVuKHNob3dDb25maXJtKVxuICAgICAgICAgICAgLnRoZW4oc3RvcCwgc3RvcCk7XG4gICAgfVxuXG4gICAgLy8gUmVzZXQgcGFzc3dvcmQgb24gc3VibWl0LlxuICAgIHB1YmxpYyByZXNldFBhc3N3b3JkU3VibWl0KCkge1xuICAgICAgICAvLyBDaGVjayBpZiBwYXNzd29yZHMgbWF0Y2hcbiAgICAgICAgdGhpcy5yZXNldFBhc3N3b3JkTWF0Y2ggPSB0cnVlO1xuICAgICAgICBpZiAodGhpcy5yZXNldENyZWRzLm5ld1Bhc3N3b3JkICE9PSB0aGlzLnJlc2V0Q3JlZHMuY29uZmlybU5ld1Bhc3N3b3JkKSB7XG4gICAgICAgICAgICB0aGlzLnJlc2V0UGFzc3dvcmRNYXRjaCA9IGZhbHNlO1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5pbkZsaWdodCA9IHRydWU7XG4gICAgICAgIGNvbnN0IHNob3dDb25maXJtID0gKCkgPT4ge1xuICAgICAgICAgICAgdGhpcy5pbkZsaWdodCA9IGZhbHNlO1xuICAgICAgICAgICAgY29uc3QgcmVzZXRQYXNzd29yZENvbmZvcm1hdGlvbk1vZGVsUmVmID0gdGhpcy5tb2RhbFNlcnZpY2Uub3BlbihOd2ZDb25maXJtYXRpb25Nb2RhbENvbXBvbmVudCk7XG4gICAgICAgICAgICByZXNldFBhc3N3b3JkQ29uZm9ybWF0aW9uTW9kZWxSZWYucmVzdWx0LnRoZW4oKCkgPT4ge1xuICAgICAgICAgICAgICAgIC8vIGFmdGVyIHVzZXIgY2xpY2tzIG9rLCByZWRpcmVjdCB0byBob21lIHBhZ2VcbiAgICAgICAgICAgICAgICB3aW5kb3cubG9jYXRpb24ucmVwbGFjZSgnLycpO1xuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICBjb25zdCBjb25maXJtTW9kYWxJbnN0YW5jZTogTndmQ29uZmlybWF0aW9uTW9kYWxDb21wb25lbnQgPSByZXNldFBhc3N3b3JkQ29uZm9ybWF0aW9uTW9kZWxSZWYuY29tcG9uZW50SW5zdGFuY2U7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS50aXRsZSA9IHRoaXMuaTE4TmV4dFBpcGUudHJhbnNmb3JtKCdud2ZqczppbmZvJyk7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5tZXNzYWdlID0gdGhpcy5pMThOZXh0UGlwZS50cmFuc2Zvcm0oJ253ZmpzOnJlc2V0UGFzc3dvcmRTdWNjZWVkJyk7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5zaG93Q2FuY2VsID0gZmFsc2U7XG4gICAgICAgICAgICBjb25maXJtTW9kYWxJbnN0YW5jZS5zdGF0dXMgPSAnaW5mbyc7XG4gICAgICAgIH07XG5cbiAgICAgICAgY29uc3Qgc2hvd0Vycm9yID0gKGVycm9yKSA9PiB7XG4gICAgICAgICAgICB0aGlzLmluRmxpZ2h0ID0gZmFsc2U7XG4gICAgICAgICAgICBjb25zdCBmYWlsZWRNb2RhbCA9IHRoaXMubW9kYWxTZXJ2aWNlLm9wZW4oTndmQ29uZmlybWF0aW9uTW9kYWxDb21wb25lbnQpLmNvbXBvbmVudEluc3RhbmNlO1xuICAgICAgICAgICAgZmFpbGVkTW9kYWwudGl0bGUgPSB0aGlzLmkxOE5leHRQaXBlLnRyYW5zZm9ybSgnbndmanM6ZXJyb3InKTtcbiAgICAgICAgICAgIGZhaWxlZE1vZGFsLm1lc3NhZ2UgPSB0aGlzLmkxOE5leHRQaXBlLnRyYW5zZm9ybSgnbndmanM6cmVzZXRQYXNzd29yZEZhaWxlZCcpO1xuICAgICAgICAgICAgZmFpbGVkTW9kYWwuc2hvd0NhbmNlbCA9IGZhbHNlO1xuICAgICAgICAgICAgZmFpbGVkTW9kYWwuc3RhdHVzID0gJ2Vycm9yJztcbiAgICAgICAgfTtcbiAgICAgICAgY29uc3QgeyB1c2VybmFtZSwgbmV3UGFzc3dvcmQgfSA9IHRoaXMucmVzZXRDcmVkcztcbiAgICAgICAgdGhpcy5Od2ZBdXRoU2VydmljZS5yZXNldFBhc3N3b3JkKHVzZXJuYW1lLCBuZXdQYXNzd29yZCwgdGhpcy5hdXRoVG9rZW4pXG4gICAgICAgICAgICAudGhlbihzaG93Q29uZmlybSlcbiAgICAgICAgICAgIC5jYXRjaChzaG93RXJyb3IpXG4gICAgICAgICAgICAudGhlbihzdG9wLCBzdG9wKTtcbiAgICB9XG5cbiAgICAvLyBSZXNldCBwYXNzd29yZCBvbiBjYW5jZWwuXG4gICAgcHVibGljIHJlc2V0UGFzc3dvcmRDYW5jZWxGbigpIHtcbiAgICAgICAgd2luZG93LmxvY2F0aW9uLmhyZWYgPSBkb2N1bWVudC5sb2NhdGlvbi5vcmlnaW47XG4gICAgfVxuXG4gICAgcHVibGljIGZvcmdvdFBhc3N3b3JkQ2xpY2soKSB7XG4gICAgICAgIHRoaXMuZm9yZ290UGFzc3dvcmRNb2RlID0gIXRoaXMuZm9yZ290UGFzc3dvcmRNb2RlO1xuICAgICAgICB0aGlzLmZvcmdvdENyZWRzLnVzZXJuYW1lID0gdGhpcy5jcmVkcy51c2VybmFtZTtcbiAgICB9XG5cbn1cbiJdfQ==