/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { NgModule } from '@angular/core';
import { NwfjsSharedComponentsModule } from './lib/components/nwfjs.shared-components.module';
import { NwfFormModule } from './lib/form/form.module';
import { NwfGridModule } from './lib/grid/grid.module';
import { NwfjsSharedPipesModule } from './lib/pipes/nwfjs.shared-pipes.module';
import { NwfServicesModule } from './lib/services/services.module';
import { NwfShellModule } from './lib/shell/shell.module';
import { NwfjsConfigService } from './nwfjs.config.service';
export class NwfjsComponentsModule {
    /**
     * @param {?} config
     * @return {?}
     */
    static forRoot(config) {
        return {
            ngModule: NwfServicesModule,
            providers: [
                { provide: NwfjsConfigService, useValue: config },
            ],
        };
    }
}
NwfjsComponentsModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    NwfShellModule,
                    NwfGridModule,
                    NwfServicesModule,
                    NwfFormModule,
                    NwfjsSharedComponentsModule,
                    NwfjsSharedPipesModule,
                ],
                exports: [
                    NwfShellModule,
                    NwfGridModule,
                    NwfServicesModule,
                    NwfFormModule,
                    NwfjsSharedComponentsModule,
                    NwfjsSharedPipesModule,
                ],
            },] }
];
//# sourceMappingURL=data:application/json;base64,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