/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Inject, Injectable, InjectionToken, Optional } from '@angular/core';
import { filter, first } from 'rxjs/operators';
/** @type {?} */
export var ANALYTICS_CONFIG = new InjectionToken('nwfAnalyticsConfig');
var AnalyticsInjectorService = /** @class */ (function () {
    function AnalyticsInjectorService(config, authService) {
        var _this = this;
        this.config = config;
        if (authService) {
            ((/** @type {?} */ (authService.isAuthenticated$()))).pipe(filter((/**
             * @param {?} value
             * @return {?}
             */
            function (value) { return value; })), first()).subscribe((/**
             * @return {?}
             */
            function () {
                _this.injectMatomo();
            }));
        }
        else {
            this.injectMatomo();
        }
    }
    /**
     * @private
     * @return {?}
     */
    AnalyticsInjectorService.prototype.injectMatomo = /**
     * @private
     * @return {?}
     */
    function () {
        var _a = this.config, url = _a.url, src = _a.src;
        window['_paq'] = window['_paq'] || [];
        window['_paq'].push(['enableLinkTracking']);
        ((/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var d = document;
            window['_paq'].push(['setTrackerUrl', url]);
            window['_paq'].push(['setSiteId', 1]);
            /** @type {?} */
            var g = d.createElement('script');
            /** @type {?} */
            var s = d.getElementsByTagName('script')[0];
            g.type = 'text/javascript';
            g.async = true;
            g.defer = true;
            g.src = src;
            s.parentNode.insertBefore(g, s);
        }))();
    };
    AnalyticsInjectorService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    AnalyticsInjectorService.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: [ANALYTICS_CONFIG,] }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: ['NwfAuthService',] }] }
    ]; };
    return AnalyticsInjectorService;
}());
export { AnalyticsInjectorService };
if (false) {
    /**
     * @type {?}
     * @private
     */
    AnalyticsInjectorService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,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