/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { debounceTime, share } from 'rxjs/operators';
/**
 * This service is for observing column changes of the dxdatagrid through the onColumnsChanging event.
 *
 * Example:
 * onInitialized: (e) => {
 *     e.component.option("onColumnsChanging", (e) => {
 *         this.columnsChangingService.onColumnsChanging(e);
 *     });
 * }
 */
var NwfColumnsChangingService = /** @class */ (function () {
    function NwfColumnsChangingService() {
        this.columnsChanging = new Subject();
        this.columnsChanging$ = this.columnsChanging.asObservable().pipe(debounceTime(10), share());
    }
    /**
     * @param {?} event
     * @return {?}
     */
    NwfColumnsChangingService.prototype.onColumnsChanging = /**
     * @param {?} event
     * @return {?}
     */
    function (event) {
        this.columnsChanging.next(event);
    };
    NwfColumnsChangingService.decorators = [
        { type: Injectable }
    ];
    return NwfColumnsChangingService;
}());
export { NwfColumnsChangingService };
if (false) {
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging;
    /** @type {?} */
    NwfColumnsChangingService.prototype.columnsChanging$;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JpZC1jb2x1bW5zLWNoYW5naW5nLnNlcnZpY2UuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AbmV0YXBwL253ZmpzX2FuZ3VsYXJfY29tcG9uZW50cy8iLCJzb3VyY2VzIjpbImxpYi9jb21wb25lbnRzL2dyaWQtY29sdW1ucy1jaGFuZ2luZy5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sRUFBYyxPQUFPLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDM0MsT0FBTyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQzs7Ozs7Ozs7Ozs7QUFZckQ7SUFBQTtRQUdXLG9CQUFlLEdBQWlCLElBQUksT0FBTyxFQUFFLENBQUM7UUFDOUMscUJBQWdCLEdBQW9CLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBS25ILENBQUM7Ozs7O0lBSFUscURBQWlCOzs7O0lBQXhCLFVBQXlCLEtBQUs7UUFDMUIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDckMsQ0FBQzs7Z0JBUkosVUFBVTs7SUFTWCxnQ0FBQztDQUFBLEFBVEQsSUFTQztTQVJZLHlCQUF5Qjs7O0lBRWxDLG9EQUFxRDs7SUFDckQscURBQStHIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgU3ViamVjdCB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgZGVib3VuY2VUaW1lLCBzaGFyZSB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcblxuLyoqXG4gKiBUaGlzIHNlcnZpY2UgaXMgZm9yIG9ic2VydmluZyBjb2x1bW4gY2hhbmdlcyBvZiB0aGUgZHhkYXRhZ3JpZCB0aHJvdWdoIHRoZSBvbkNvbHVtbnNDaGFuZ2luZyBldmVudC5cbiAqXG4gKiBFeGFtcGxlOlxuICogb25Jbml0aWFsaXplZDogKGUpID0+IHtcbiAqICAgICBlLmNvbXBvbmVudC5vcHRpb24oXCJvbkNvbHVtbnNDaGFuZ2luZ1wiLCAoZSkgPT4ge1xuICogICAgICAgICB0aGlzLmNvbHVtbnNDaGFuZ2luZ1NlcnZpY2Uub25Db2x1bW5zQ2hhbmdpbmcoZSk7XG4gKiAgICAgfSk7XG4gKiB9XG4gKi9cbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBOd2ZDb2x1bW5zQ2hhbmdpbmdTZXJ2aWNlIHtcblxuICAgIHB1YmxpYyBjb2x1bW5zQ2hhbmdpbmc6IFN1YmplY3Q8YW55PiA9IG5ldyBTdWJqZWN0KCk7XG4gICAgcHVibGljIGNvbHVtbnNDaGFuZ2luZyQ6IE9ic2VydmFibGU8YW55PiA9IHRoaXMuY29sdW1uc0NoYW5naW5nLmFzT2JzZXJ2YWJsZSgpLnBpcGUoZGVib3VuY2VUaW1lKDEwKSwgc2hhcmUoKSk7XG5cbiAgICBwdWJsaWMgb25Db2x1bW5zQ2hhbmdpbmcoZXZlbnQpIHtcbiAgICAgICAgdGhpcy5jb2x1bW5zQ2hhbmdpbmcubmV4dChldmVudCk7XG4gICAgfVxufVxuIl19