/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
import { NwfHelpConfig } from './help.config.service';
var HelpService = /** @class */ (function () {
    function HelpService(config) {
        this.config = config;
        /** @type {?} */
        var basePath = this.config.helpBasePath;
        /** @type {?} */
        var context = this.config.helpContext;
        //  Beginning of Webworks help API
        /** @type {?} */
        var WWHAPI_Object = (/**
         * @param {?} ParamHelpURL
         * @param {?} ParamTargetWindow
         * @return {?}
         */
        function (ParamHelpURL, ParamTargetWindow) {
            // Location of the WebWorks Help system to be launched.
            // Location should be an absolute URL.
            //
            this.mAPIURL = ParamHelpURL + '/wwhelp/wwhimpl/api.htm';
            this.mWindow = null;
            this.mTargetWindow = ParamTargetWindow;
            this.fLaunchHelp = WWHAPI_LaunchHelp;
            this.fCloseHelp = WWHAPI_CloseHelp;
            this.fDisplayHelp = WWHAPI_DisplayHelp;
            this.fDisplayHelpWithNavigation = WWHAPI_DisplayHelpWithNavigation;
            this.fDisplayHelpWithContents = WWHAPI_DisplayHelpWithContents;
            this.fDisplayHelpWithIndex = WWHAPI_DisplayHelpWithIndex;
            this.fDisplayHelpWithSearch = WWHAPI_DisplayHelpWithSearch;
            this.fDisplayHelpWithFavorites = WWHAPI_DisplayHelpWithFavorites;
            this.fDisplayHelpNavigation = WWHAPI_DisplayHelpNavigation;
            this.fDisplayHelpContents = WWHAPI_DisplayHelpContents;
            this.fDisplayHelpIndex = WWHAPI_DisplayHelpIndex;
            this.fDisplayHelpSearch = WWHAPI_DisplayHelpSearch;
            this.fDisplayHelpFavorites = WWHAPI_DisplayHelpFavorites;
        });
        /**
         * @param {?} bParamSingle
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @param {?} ParamTab
         * @return {?}
         */
        function WWHAPI_LaunchHelp(bParamSingle, ParamContext, ParamTopic, ParamTab) {
            /** @type {?} */
            var VarParameters;
            /** @type {?} */
            var VarURL;
            /** @type {?} */
            var VarIndex;
            /** @type {?} */
            var VarMaxIndex;
            // Define parameters
            //
            VarParameters = new Array();
            if (bParamSingle) {
                VarParameters[VarParameters.length] = 'single=true';
            }
            if (ParamContext != null) {
                VarParameters[VarParameters.length] = 'context=' + ParamContext;
                // Use the global configuration for the help context if one exists
            }
            else if (context != null) {
                VarParameters[VarParameters.length] = 'context=' + context;
            }
            if (ParamTopic != null) {
                VarParameters[VarParameters.length] = 'topic=' + ParamTopic;
            }
            if (ParamTab) {
                VarParameters[VarParameters.length] = 'tab=' + ParamTab;
            }
            // Create URL
            //
            VarURL = this.mAPIURL;
            for (VarIndex = 0, VarMaxIndex = VarParameters.length; VarIndex < VarMaxIndex; VarIndex++) {
                if (VarIndex == 0) {
                    VarURL += '?' + VarParameters[VarIndex];
                }
                else {
                    VarURL += '&' + VarParameters[VarIndex];
                }
            }
            // Check to see if the window exists.  If it does, make the native call directly.
            // Otherwise, initialize the help system at the topic using URL params.
            //
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.focus();
                this.mWindow.WWHHelp.fSetContextDocument(VarURL);
            }
            else {
                /* Customized this for our needs ! */
                /** @type {?} */
                var netappDesiredWidthAndHeight = 'height=768, width=1024';
                if ((typeof (this.mTargetWindow) != 'undefined') &&
                    (this.mTargetWindow != null)) {
                    this.mWindow = window.open(VarURL, this.mTargetWindow, netappDesiredWidthAndHeight);
                }
                else {
                    this.mWindow = window.open(VarURL, null, netappDesiredWidthAndHeight);
                }
                // Ensure window is brought to the foreground
                //
                this.mWindow.focus();
            }
        }
        /**
         * @return {?}
         */
        function WWHAPI_CloseHelp() {
            if ((this.mWindow != null) &&
                (typeof (this.mWindow) != 'undefined') &&
                (!this.mWindow.closed) &&
                (this.mWindow.WWHHelp != null) &&
                (typeof (this.mWindow.WWHHelp) != 'undefined')) {
                this.mWindow.close();
            }
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelp(ParamContext, ParamTopic) {
            this.fLaunchHelp(true, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithNavigation(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, null);
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithContents(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'contents');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithIndex(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'index');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithSearch(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'search');
        }
        /**
         * @param {?} ParamContext
         * @param {?} ParamTopic
         * @return {?}
         */
        function WWHAPI_DisplayHelpWithFavorites(ParamContext, ParamTopic) {
            this.fLaunchHelp(false, ParamContext, ParamTopic, 'favorites');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpNavigation() {
            this.fLaunchHelp(false, null, null, null);
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpContents() {
            this.fLaunchHelp(false, null, null, 'contents');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpIndex() {
            this.fLaunchHelp(false, null, null, 'index');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpSearch() {
            this.fLaunchHelp(false, null, null, 'search');
        }
        /**
         * @return {?}
         */
        function WWHAPI_DisplayHelpFavorites() {
            this.fLaunchHelp(false, null, null, 'favorites');
        }
        // End of Webworks help API
        /* Now create me , we should not have two things, but one to configure. Fix later. */
        this.helpDirectiveWindow = new WWHAPI_Object(basePath + context, 'help_window');
    }
    HelpService.decorators = [
        { type: Injectable }
    ];
    /** @nocollapse */
    HelpService.ctorParameters = function () { return [
        { type: NwfHelpConfig }
    ]; };
    return HelpService;
}());
export { HelpService };
if (false) {
    /** @type {?} */
    HelpService.prototype.helpDirectiveWindow;
    /**
     * @type {?}
     * @private
     */
    HelpService.prototype.config;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVscC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvY29tcG9uZW50cy9oZWxwL2hlbHAuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUMzQyxPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFFdEQ7SUFLRSxxQkFBb0IsTUFBcUI7UUFBckIsV0FBTSxHQUFOLE1BQU0sQ0FBZTs7WUFDakMsUUFBUSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWTs7WUFDbkMsT0FBTyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVzs7O1lBR2pDLGFBQWE7Ozs7O1FBQUcsVUFBUyxZQUFZLEVBQ1osaUJBQWlCO1lBQzlDLHVEQUF1RDtZQUN2RCxzQ0FBc0M7WUFDdEMsRUFBRTtZQUNGLElBQUksQ0FBQyxPQUFPLEdBQUcsWUFBWSxHQUFHLHlCQUF5QixDQUFDO1lBQ3hELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLElBQUksQ0FBQyxhQUFhLEdBQUcsaUJBQWlCLENBQUM7WUFFdkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxpQkFBaUIsQ0FBQztZQUNyQyxJQUFJLENBQUMsVUFBVSxHQUFHLGdCQUFnQixDQUFDO1lBQ25DLElBQUksQ0FBQyxZQUFZLEdBQUcsa0JBQWtCLENBQUM7WUFDdkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLGdDQUFnQyxDQUFDO1lBQ25FLElBQUksQ0FBQyx3QkFBd0IsR0FBRyw4QkFBOEIsQ0FBQztZQUMvRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsMkJBQTJCLENBQUM7WUFDekQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLDRCQUE0QixDQUFDO1lBQzNELElBQUksQ0FBQyx5QkFBeUIsR0FBRywrQkFBK0IsQ0FBQztZQUNqRSxJQUFJLENBQUMsc0JBQXNCLEdBQUcsNEJBQTRCLENBQUM7WUFDM0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLDBCQUEwQixDQUFDO1lBQ3ZELElBQUksQ0FBQyxpQkFBaUIsR0FBRyx1QkFBdUIsQ0FBQztZQUNqRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsd0JBQXdCLENBQUM7WUFDbkQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLDJCQUEyQixDQUFDO1FBQzNELENBQUMsQ0FBQTs7Ozs7Ozs7UUFFRCxTQUFTLGlCQUFpQixDQUFDLFlBQVksRUFDWixZQUFZLEVBQ1osVUFBVSxFQUNWLFFBQVE7O2dCQUM3QixhQUFhOztnQkFDYixNQUFNOztnQkFDTixRQUFROztnQkFDUixXQUFXO1lBRWYsb0JBQW9CO1lBQ3BCLEVBQUU7WUFDRixhQUFhLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUM1QixJQUFJLFlBQVksRUFBRTtnQkFDaEIsYUFBYSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsR0FBRyxhQUFhLENBQUM7YUFDckQ7WUFDRCxJQUFJLFlBQVksSUFBSSxJQUFJLEVBQUU7Z0JBQ3hCLGFBQWEsQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUFDLEdBQUcsVUFBVSxHQUFHLFlBQVksQ0FBQztnQkFDbEUsa0VBQWtFO2FBQ2pFO2lCQUFNLElBQUksT0FBTyxJQUFJLElBQUksRUFBRTtnQkFDMUIsYUFBYSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsR0FBRyxVQUFVLEdBQUcsT0FBTyxDQUFDO2FBQzVEO1lBQ0QsSUFBSSxVQUFVLElBQUksSUFBSSxFQUFFO2dCQUN0QixhQUFhLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxHQUFHLFFBQVEsR0FBRyxVQUFVLENBQUM7YUFDN0Q7WUFDRCxJQUFJLFFBQVEsRUFBRTtnQkFDWixhQUFhLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxHQUFHLE1BQU0sR0FBRyxRQUFRLENBQUM7YUFDekQ7WUFFRCxhQUFhO1lBQ2IsRUFBRTtZQUNGLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQ3RCLEtBQUssUUFBUSxHQUFHLENBQUMsRUFBRSxXQUFXLEdBQUcsYUFBYSxDQUFDLE1BQU0sRUFBRSxRQUFRLEdBQUcsV0FBVyxFQUFFLFFBQVEsRUFBRSxFQUFFO2dCQUN6RixJQUFJLFFBQVEsSUFBSSxDQUFDLEVBQUU7b0JBQ2pCLE1BQU0sSUFBSSxHQUFHLEdBQUcsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO2lCQUN6QztxQkFBTTtvQkFDTCxNQUFNLElBQUksR0FBRyxHQUFHLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztpQkFDekM7YUFDRjtZQUVELGlGQUFpRjtZQUNqRix1RUFBdUU7WUFDdkUsRUFBRTtZQUNGLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQztnQkFDeEIsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLFdBQVcsQ0FBQztnQkFDdEMsQ0FBQyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO2dCQUN0QixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQztnQkFDOUIsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxXQUFXLENBQUMsRUFBRTtnQkFDaEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDckIsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsbUJBQW1CLENBQUMsTUFBTSxDQUFDLENBQUM7YUFDbEQ7aUJBQU07OztvQkFFQywyQkFBMkIsR0FBRyx3QkFBd0I7Z0JBQzVELElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLFdBQVcsQ0FBQztvQkFDOUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxJQUFJLElBQUksQ0FBQyxFQUFFO29CQUM5QixJQUFJLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxhQUFhLEVBQUUsMkJBQTJCLENBQUMsQ0FBQztpQkFDckY7cUJBQU07b0JBQ0wsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLEVBQUUsMkJBQTJCLENBQUMsQ0FBQztpQkFDdkU7Z0JBQ0QsNkNBQTZDO2dCQUM3QyxFQUFFO2dCQUNGLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUM7YUFDdEI7UUFDSCxDQUFDOzs7O1FBRUQsU0FBUyxnQkFBZ0I7WUFDdkIsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDO2dCQUN4QixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksV0FBVyxDQUFDO2dCQUN0QyxDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUM7Z0JBQ3RCLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDO2dCQUM5QixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLFdBQVcsQ0FBQyxFQUFFO2dCQUNoRCxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFDO2FBQ3RCO1FBQ0gsQ0FBQzs7Ozs7O1FBRUQsU0FBUyxrQkFBa0IsQ0FBQyxZQUFZLEVBQ1osVUFBVTtZQUNwQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pELENBQUM7Ozs7OztRQUVELFNBQVMsZ0NBQWdDLENBQUMsWUFBWSxFQUNaLFVBQVU7WUFDbEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMxRCxDQUFDOzs7Ozs7UUFFRCxTQUFTLDhCQUE4QixDQUFDLFlBQVksRUFDWixVQUFVO1lBQ2hELElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDaEUsQ0FBQzs7Ozs7O1FBRUQsU0FBUywyQkFBMkIsQ0FBQyxZQUFZLEVBQ1osVUFBVTtZQUM3QyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxZQUFZLEVBQUUsVUFBVSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQzdELENBQUM7Ozs7OztRQUVELFNBQVMsNEJBQTRCLENBQUMsWUFBWSxFQUNaLFVBQVU7WUFDOUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUM5RCxDQUFDOzs7Ozs7UUFFRCxTQUFTLCtCQUErQixDQUFDLFlBQVksRUFDWixVQUFVO1lBQ2pELElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRSxVQUFVLEVBQUUsV0FBVyxDQUFDLENBQUM7UUFDakUsQ0FBQzs7OztRQUVELFNBQVMsNEJBQTRCO1lBQ25DLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDNUMsQ0FBQzs7OztRQUVELFNBQVMsMEJBQTBCO1lBQ2pDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDbEQsQ0FBQzs7OztRQUVELFNBQVMsdUJBQXVCO1lBQzlCLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDL0MsQ0FBQzs7OztRQUVELFNBQVMsd0JBQXdCO1lBQy9CLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDaEQsQ0FBQzs7OztRQUVELFNBQVMsMkJBQTJCO1lBQ2xDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsV0FBVyxDQUFDLENBQUM7UUFDbkQsQ0FBQztRQUNELDJCQUEyQjtRQUUzQixxRkFBcUY7UUFDckYsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksYUFBYSxDQUFDLFFBQVEsR0FBRyxPQUFPLEVBQUUsYUFBYSxDQUFDLENBQUM7SUFFbEYsQ0FBQzs7Z0JBbEtGLFVBQVU7Ozs7Z0JBRkYsYUFBYTs7SUFzS3RCLGtCQUFDO0NBQUEsQUFwS0QsSUFvS0M7U0FuS1ksV0FBVzs7O0lBRXRCLDBDQUEyQjs7Ozs7SUFFZiw2QkFBNkIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBOd2ZIZWxwQ29uZmlnIH0gZnJvbSAnLi9oZWxwLmNvbmZpZy5zZXJ2aWNlJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIEhlbHBTZXJ2aWNlIHtcblxuICBwdWJsaWMgaGVscERpcmVjdGl2ZVdpbmRvdztcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIGNvbmZpZzogTndmSGVscENvbmZpZykge1xuICAgIGNvbnN0IGJhc2VQYXRoID0gdGhpcy5jb25maWcuaGVscEJhc2VQYXRoO1xuICAgIGNvbnN0IGNvbnRleHQgPSB0aGlzLmNvbmZpZy5oZWxwQ29udGV4dDtcblxuICAgIC8vICBCZWdpbm5pbmcgb2YgV2Vid29ya3MgaGVscCBBUElcbiAgICBjb25zdCBXV0hBUElfT2JqZWN0ID0gZnVuY3Rpb24oUGFyYW1IZWxwVVJMLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbVRhcmdldFdpbmRvdykge1xuICAgICAgLy8gTG9jYXRpb24gb2YgdGhlIFdlYldvcmtzIEhlbHAgc3lzdGVtIHRvIGJlIGxhdW5jaGVkLlxuICAgICAgLy8gTG9jYXRpb24gc2hvdWxkIGJlIGFuIGFic29sdXRlIFVSTC5cbiAgICAgIC8vXG4gICAgICB0aGlzLm1BUElVUkwgPSBQYXJhbUhlbHBVUkwgKyAnL3d3aGVscC93d2hpbXBsL2FwaS5odG0nO1xuICAgICAgdGhpcy5tV2luZG93ID0gbnVsbDtcbiAgICAgIHRoaXMubVRhcmdldFdpbmRvdyA9IFBhcmFtVGFyZ2V0V2luZG93O1xuXG4gICAgICB0aGlzLmZMYXVuY2hIZWxwID0gV1dIQVBJX0xhdW5jaEhlbHA7XG4gICAgICB0aGlzLmZDbG9zZUhlbHAgPSBXV0hBUElfQ2xvc2VIZWxwO1xuICAgICAgdGhpcy5mRGlzcGxheUhlbHAgPSBXV0hBUElfRGlzcGxheUhlbHA7XG4gICAgICB0aGlzLmZEaXNwbGF5SGVscFdpdGhOYXZpZ2F0aW9uID0gV1dIQVBJX0Rpc3BsYXlIZWxwV2l0aE5hdmlnYXRpb247XG4gICAgICB0aGlzLmZEaXNwbGF5SGVscFdpdGhDb250ZW50cyA9IFdXSEFQSV9EaXNwbGF5SGVscFdpdGhDb250ZW50cztcbiAgICAgIHRoaXMuZkRpc3BsYXlIZWxwV2l0aEluZGV4ID0gV1dIQVBJX0Rpc3BsYXlIZWxwV2l0aEluZGV4O1xuICAgICAgdGhpcy5mRGlzcGxheUhlbHBXaXRoU2VhcmNoID0gV1dIQVBJX0Rpc3BsYXlIZWxwV2l0aFNlYXJjaDtcbiAgICAgIHRoaXMuZkRpc3BsYXlIZWxwV2l0aEZhdm9yaXRlcyA9IFdXSEFQSV9EaXNwbGF5SGVscFdpdGhGYXZvcml0ZXM7XG4gICAgICB0aGlzLmZEaXNwbGF5SGVscE5hdmlnYXRpb24gPSBXV0hBUElfRGlzcGxheUhlbHBOYXZpZ2F0aW9uO1xuICAgICAgdGhpcy5mRGlzcGxheUhlbHBDb250ZW50cyA9IFdXSEFQSV9EaXNwbGF5SGVscENvbnRlbnRzO1xuICAgICAgdGhpcy5mRGlzcGxheUhlbHBJbmRleCA9IFdXSEFQSV9EaXNwbGF5SGVscEluZGV4O1xuICAgICAgdGhpcy5mRGlzcGxheUhlbHBTZWFyY2ggPSBXV0hBUElfRGlzcGxheUhlbHBTZWFyY2g7XG4gICAgICB0aGlzLmZEaXNwbGF5SGVscEZhdm9yaXRlcyA9IFdXSEFQSV9EaXNwbGF5SGVscEZhdm9yaXRlcztcbiAgICB9O1xuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0xhdW5jaEhlbHAoYlBhcmFtU2luZ2xlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFBhcmFtQ29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbVRvcGljLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFBhcmFtVGFiKSB7XG4gICAgICBsZXQgVmFyUGFyYW1ldGVycztcbiAgICAgIGxldCBWYXJVUkw7XG4gICAgICBsZXQgVmFySW5kZXg7XG4gICAgICBsZXQgVmFyTWF4SW5kZXg7XG5cbiAgICAgIC8vIERlZmluZSBwYXJhbWV0ZXJzXG4gICAgICAvL1xuICAgICAgVmFyUGFyYW1ldGVycyA9IG5ldyBBcnJheSgpO1xuICAgICAgaWYgKGJQYXJhbVNpbmdsZSkge1xuICAgICAgICBWYXJQYXJhbWV0ZXJzW1ZhclBhcmFtZXRlcnMubGVuZ3RoXSA9ICdzaW5nbGU9dHJ1ZSc7XG4gICAgICB9XG4gICAgICBpZiAoUGFyYW1Db250ZXh0ICE9IG51bGwpIHtcbiAgICAgICAgVmFyUGFyYW1ldGVyc1tWYXJQYXJhbWV0ZXJzLmxlbmd0aF0gPSAnY29udGV4dD0nICsgUGFyYW1Db250ZXh0O1xuICAgICAgLy8gVXNlIHRoZSBnbG9iYWwgY29uZmlndXJhdGlvbiBmb3IgdGhlIGhlbHAgY29udGV4dCBpZiBvbmUgZXhpc3RzXG4gICAgICB9IGVsc2UgaWYgKGNvbnRleHQgIT0gbnVsbCkge1xuICAgICAgICBWYXJQYXJhbWV0ZXJzW1ZhclBhcmFtZXRlcnMubGVuZ3RoXSA9ICdjb250ZXh0PScgKyBjb250ZXh0O1xuICAgICAgfVxuICAgICAgaWYgKFBhcmFtVG9waWMgIT0gbnVsbCkge1xuICAgICAgICBWYXJQYXJhbWV0ZXJzW1ZhclBhcmFtZXRlcnMubGVuZ3RoXSA9ICd0b3BpYz0nICsgUGFyYW1Ub3BpYztcbiAgICAgIH1cbiAgICAgIGlmIChQYXJhbVRhYikge1xuICAgICAgICBWYXJQYXJhbWV0ZXJzW1ZhclBhcmFtZXRlcnMubGVuZ3RoXSA9ICd0YWI9JyArIFBhcmFtVGFiO1xuICAgICAgfVxuXG4gICAgICAvLyBDcmVhdGUgVVJMXG4gICAgICAvL1xuICAgICAgVmFyVVJMID0gdGhpcy5tQVBJVVJMO1xuICAgICAgZm9yIChWYXJJbmRleCA9IDAsIFZhck1heEluZGV4ID0gVmFyUGFyYW1ldGVycy5sZW5ndGg7IFZhckluZGV4IDwgVmFyTWF4SW5kZXg7IFZhckluZGV4KyspIHtcbiAgICAgICAgaWYgKFZhckluZGV4ID09IDApIHtcbiAgICAgICAgICBWYXJVUkwgKz0gJz8nICsgVmFyUGFyYW1ldGVyc1tWYXJJbmRleF07XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgVmFyVVJMICs9ICcmJyArIFZhclBhcmFtZXRlcnNbVmFySW5kZXhdO1xuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIC8vIENoZWNrIHRvIHNlZSBpZiB0aGUgd2luZG93IGV4aXN0cy4gIElmIGl0IGRvZXMsIG1ha2UgdGhlIG5hdGl2ZSBjYWxsIGRpcmVjdGx5LlxuICAgICAgLy8gT3RoZXJ3aXNlLCBpbml0aWFsaXplIHRoZSBoZWxwIHN5c3RlbSBhdCB0aGUgdG9waWMgdXNpbmcgVVJMIHBhcmFtcy5cbiAgICAgIC8vXG4gICAgICBpZiAoKHRoaXMubVdpbmRvdyAhPSBudWxsKSAmJlxuICAgICAgICAodHlwZW9mICh0aGlzLm1XaW5kb3cpICE9ICd1bmRlZmluZWQnKSAmJlxuICAgICAgICAoIXRoaXMubVdpbmRvdy5jbG9zZWQpICYmXG4gICAgICAgICh0aGlzLm1XaW5kb3cuV1dISGVscCAhPSBudWxsKSAmJlxuICAgICAgICAodHlwZW9mICh0aGlzLm1XaW5kb3cuV1dISGVscCkgIT0gJ3VuZGVmaW5lZCcpKSB7XG4gICAgICAgIHRoaXMubVdpbmRvdy5mb2N1cygpO1xuICAgICAgICB0aGlzLm1XaW5kb3cuV1dISGVscC5mU2V0Q29udGV4dERvY3VtZW50KFZhclVSTCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvKiBDdXN0b21pemVkIHRoaXMgZm9yIG91ciBuZWVkcyAhICovXG4gICAgICAgIGNvbnN0IG5ldGFwcERlc2lyZWRXaWR0aEFuZEhlaWdodCA9ICdoZWlnaHQ9NzY4LCB3aWR0aD0xMDI0JztcbiAgICAgICAgaWYgKCh0eXBlb2YgKHRoaXMubVRhcmdldFdpbmRvdykgIT0gJ3VuZGVmaW5lZCcpICYmXG4gICAgICAgICAgKHRoaXMubVRhcmdldFdpbmRvdyAhPSBudWxsKSkge1xuICAgICAgICAgIHRoaXMubVdpbmRvdyA9IHdpbmRvdy5vcGVuKFZhclVSTCwgdGhpcy5tVGFyZ2V0V2luZG93LCBuZXRhcHBEZXNpcmVkV2lkdGhBbmRIZWlnaHQpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHRoaXMubVdpbmRvdyA9IHdpbmRvdy5vcGVuKFZhclVSTCwgbnVsbCwgbmV0YXBwRGVzaXJlZFdpZHRoQW5kSGVpZ2h0KTtcbiAgICAgICAgfVxuICAgICAgICAvLyBFbnN1cmUgd2luZG93IGlzIGJyb3VnaHQgdG8gdGhlIGZvcmVncm91bmRcbiAgICAgICAgLy9cbiAgICAgICAgdGhpcy5tV2luZG93LmZvY3VzKCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Nsb3NlSGVscCgpIHtcbiAgICAgIGlmICgodGhpcy5tV2luZG93ICE9IG51bGwpICYmXG4gICAgICAgICh0eXBlb2YgKHRoaXMubVdpbmRvdykgIT0gJ3VuZGVmaW5lZCcpICYmXG4gICAgICAgICghdGhpcy5tV2luZG93LmNsb3NlZCkgJiZcbiAgICAgICAgKHRoaXMubVdpbmRvdy5XV0hIZWxwICE9IG51bGwpICYmXG4gICAgICAgICh0eXBlb2YgKHRoaXMubVdpbmRvdy5XV0hIZWxwKSAhPSAndW5kZWZpbmVkJykpIHtcbiAgICAgICAgdGhpcy5tV2luZG93LmNsb3NlKCk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Rpc3BsYXlIZWxwKFBhcmFtQ29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUGFyYW1Ub3BpYykge1xuICAgICAgdGhpcy5mTGF1bmNoSGVscCh0cnVlLCBQYXJhbUNvbnRleHQsIFBhcmFtVG9waWMsIG51bGwpO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIFdXSEFQSV9EaXNwbGF5SGVscFdpdGhOYXZpZ2F0aW9uKFBhcmFtQ29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQYXJhbVRvcGljKSB7XG4gICAgICB0aGlzLmZMYXVuY2hIZWxwKGZhbHNlLCBQYXJhbUNvbnRleHQsIFBhcmFtVG9waWMsIG51bGwpO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIFdXSEFQSV9EaXNwbGF5SGVscFdpdGhDb250ZW50cyhQYXJhbUNvbnRleHQsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFBhcmFtVG9waWMpIHtcbiAgICAgIHRoaXMuZkxhdW5jaEhlbHAoZmFsc2UsIFBhcmFtQ29udGV4dCwgUGFyYW1Ub3BpYywgJ2NvbnRlbnRzJyk7XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Rpc3BsYXlIZWxwV2l0aEluZGV4KFBhcmFtQ29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUGFyYW1Ub3BpYykge1xuICAgICAgdGhpcy5mTGF1bmNoSGVscChmYWxzZSwgUGFyYW1Db250ZXh0LCBQYXJhbVRvcGljLCAnaW5kZXgnKTtcbiAgICB9XG5cbiAgICBmdW5jdGlvbiBXV0hBUElfRGlzcGxheUhlbHBXaXRoU2VhcmNoKFBhcmFtQ29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFBhcmFtVG9waWMpIHtcbiAgICAgIHRoaXMuZkxhdW5jaEhlbHAoZmFsc2UsIFBhcmFtQ29udGV4dCwgUGFyYW1Ub3BpYywgJ3NlYXJjaCcpO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIFdXSEFQSV9EaXNwbGF5SGVscFdpdGhGYXZvcml0ZXMoUGFyYW1Db250ZXh0LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUGFyYW1Ub3BpYykge1xuICAgICAgdGhpcy5mTGF1bmNoSGVscChmYWxzZSwgUGFyYW1Db250ZXh0LCBQYXJhbVRvcGljLCAnZmF2b3JpdGVzJyk7XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Rpc3BsYXlIZWxwTmF2aWdhdGlvbigpIHtcbiAgICAgIHRoaXMuZkxhdW5jaEhlbHAoZmFsc2UsIG51bGwsIG51bGwsIG51bGwpO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIFdXSEFQSV9EaXNwbGF5SGVscENvbnRlbnRzKCkge1xuICAgICAgdGhpcy5mTGF1bmNoSGVscChmYWxzZSwgbnVsbCwgbnVsbCwgJ2NvbnRlbnRzJyk7XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Rpc3BsYXlIZWxwSW5kZXgoKSB7XG4gICAgICB0aGlzLmZMYXVuY2hIZWxwKGZhbHNlLCBudWxsLCBudWxsLCAnaW5kZXgnKTtcbiAgICB9XG5cbiAgICBmdW5jdGlvbiBXV0hBUElfRGlzcGxheUhlbHBTZWFyY2goKSB7XG4gICAgICB0aGlzLmZMYXVuY2hIZWxwKGZhbHNlLCBudWxsLCBudWxsLCAnc2VhcmNoJyk7XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gV1dIQVBJX0Rpc3BsYXlIZWxwRmF2b3JpdGVzKCkge1xuICAgICAgdGhpcy5mTGF1bmNoSGVscChmYWxzZSwgbnVsbCwgbnVsbCwgJ2Zhdm9yaXRlcycpO1xuICAgIH1cbiAgICAvLyBFbmQgb2YgV2Vid29ya3MgaGVscCBBUElcblxuICAgIC8qIE5vdyBjcmVhdGUgbWUgLCB3ZSBzaG91bGQgbm90IGhhdmUgdHdvIHRoaW5ncywgYnV0IG9uZSB0byBjb25maWd1cmUuIEZpeCBsYXRlci4gKi9cbiAgICB0aGlzLmhlbHBEaXJlY3RpdmVXaW5kb3cgPSBuZXcgV1dIQVBJX09iamVjdChiYXNlUGF0aCArIGNvbnRleHQsICdoZWxwX3dpbmRvdycpO1xuXG4gIH1cblxufVxuIl19