/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, EventEmitter, Input, Output } from '@angular/core';
var HeaderComponent = /** @class */ (function () {
    function HeaderComponent(element) {
        this.element = element;
        this.status = '';
        this.showDimissX = true;
        this.onDismiss = new EventEmitter();
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    HeaderComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        /** @type {?} */
        var status = changes.status.currentValue;
        if (status === 'error') {
            status = 'critical';
            this.status = status;
        }
        /** @type {?} */
        var stateCls = status ? "is-" + status : '';
        if (stateCls) {
            this.element.nativeElement.classList.add(stateCls);
        }
    };
    HeaderComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-modal-header',
                    template: "<nwf-icon [severity]=\"status\" *ngIf=\"status\" class=\"mr-1\"></nwf-icon>\n<h4 class=\"modal-title\">\n  <ng-content></ng-content>\n</h4>\n<nwf-dismiss-button *ngIf=\"showDimissX\" (onClose)=\"onDismiss.emit()\"></nwf-dismiss-button>\n",
                    host: { class: 'modal-header' }
                }] }
    ];
    /** @nocollapse */
    HeaderComponent.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    HeaderComponent.propDecorators = {
        status: [{ type: Input }],
        showDimissX: [{ type: Input }],
        onDismiss: [{ type: Output }]
    };
    return HeaderComponent;
}());
export { HeaderComponent };
if (false) {
    /** @type {?} */
    HeaderComponent.prototype.status;
    /** @type {?} */
    HeaderComponent.prototype.showDimissX;
    /** @type {?} */
    HeaderComponent.prototype.onDismiss;
    /**
     * @type {?}
     * @private
     */
    HeaderComponent.prototype.element;
}
//# sourceMappingURL=data:application/json;base64,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