/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { StateService } from '@uirouter/core';
import { I18NextPipe } from 'angular-i18next';
import { orderBy } from 'lodash-es';
var NwfStatusableDropdownComponent = /** @class */ (function () {
    function NwfStatusableDropdownComponent(stateService, i18next) {
        this.stateService = stateService;
        this.i18next = i18next;
        this.statusList = [];
        this.noOfEvents = 0;
        this.arrowUp = false;
        this.hasEvents = false;
        this.dropdownList = [];
        this.highestSeverity = 'info';
    }
    /**
     * @return {?}
     */
    NwfStatusableDropdownComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.newEventsCount = this.newEventsCount == '0' ? this.i18next.transform('nwfjs:no') : this.newEventsCount;
        if (this.statusList) {
            /** @type {?} */
            var isListEmpty = this.statusList.length == 0;
            this.hasEvents = this.evalFunction ? this.statusList.some(this.evalFunction) : (isListEmpty ? false : true);
            this.getHighestSeverity();
            this.loadDropdownList();
        }
    };
    /**
     * @return {?}
     */
    NwfStatusableDropdownComponent.prototype.loadDropdownList = /**
     * @return {?}
     */
    function () {
        this.dropdownList = this.evalFunction ? this.statusList.filter(this.evalFunction) : this.statusList;
        this.sortedList = this.sortBy ? orderBy(this.dropdownList, this.sortBy, 'desc') : this.dropdownList;
    };
    // set the icon on the dropdown button to the highest severity in the event list
    // set the icon on the dropdown button to the highest severity in the event list
    /**
     * @return {?}
     */
    NwfStatusableDropdownComponent.prototype.getHighestSeverity = 
    // set the icon on the dropdown button to the highest severity in the event list
    /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var severityList = this.statusList.map((/**
         * @param {?} events
         * @return {?}
         */
        function (events) { return events.severity; }));
        if (severityList.includes('critical')) {
            return 'critical';
        }
        else if (severityList.includes('error')) {
            return 'error';
        }
        else if (severityList.includes('warning')) {
            return 'warning';
        }
        else {
            return 'information';
        }
    };
    /**
     * @param {?} stateName
     * @param {?} stateParams
     * @return {?}
     */
    NwfStatusableDropdownComponent.prototype.getLink = /**
     * @param {?} stateName
     * @param {?} stateParams
     * @return {?}
     */
    function (stateName, stateParams) {
        return this.createUrl(stateName, stateParams);
    };
    NwfStatusableDropdownComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-statusable-dropdown',
                    template: "<div *ngIf=\"!hasEvents\" class=\"border\">\n    <div class=\"btn d-flex justify-content-start\">\n        <nwf-icon iconClass=\"icon-info-online\" data-netapp-id=\"nwf-statusable-dropdown-success-icon\"> </nwf-icon>\n        <span class=\"btn-icon-label\">{{ 'nwfjs:allHealthy' | i18next}}</span>\n    </div>\n</div>\n<div *ngIf=\"hasEvents\" class=\"border\">\n    <div ngbDropdown class=\"d-flex\" #myDrop=\"ngbDropdown\">\n        <button type=\"button\" class=\"btn\" ngbDropdownToggle>\n            <nwf-icon severity=\"{{getHighestSeverity()}}\"\n                data-netapp-id=\"nwf-statusable-dropdown-highest-severity-icon\"></nwf-icon>\n            <span\n                class=\"btn-icon-label pr-2\">{{'nwfjs:events' | i18next:{count: noOfEvents} }}{{ 'nwfjs:newEvents' | i18next:{newEventsCount: newEventsCount} }}</span>\n            <nwf-icon *ngIf=\"arrowUp\" data-netapp-id=\"nwf-statusable-dropdown-uparrow-icon\"\n                iconClass=\"icon-misc-arrowup\"></nwf-icon>\n            <nwf-icon *ngIf=\"!arrowUp\" data-netapp-id=\"nwf-statusable-dropdown-downarrow-icon\"\n                iconClass=\"icon-misc-arrowdown\"></nwf-icon>\n            <div class=\"ml-auto\">\n                <nwf-icon data-netapp-id=\"nwf-statusable-dropdown-chevrondown-icon\"\n                    [iconClass]=\"myDrop.isOpen() ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\">\n                </nwf-icon>\n            </div>\n        </button>\n\n        <div ngbDropdownMenu>\n            <button ngbDropdownItem class=\"dropdown-item-metadata\" *ngFor=\"let issue of sortedList | slice:0:4\">\n                <nwf-icon [severity]=\"issue.severity\" data-netapp-id=\"nwf-statusable-dropdown-severity-icon\"></nwf-icon>\n                <span class=\"pl-1 align-text-bottom\"><a href=\"{{getLink(issue.stateName, issue.stateParams)}}\">{{issue.label | i18next}}</a></span>\n                <small *ngIf=\"issue.source_full_name\" class=\"text-muted d-block pt-1 pl-4\">{{issue.source_full_name}}</small>\n            </button>\n            <button ngbDropdownItem>\n                <a href=\"{{viewAllNavigation()}}\">{{ 'nwfjs:viewAll' | i18next }}</a>\n            </button>\n        </div>\n    </div>\n</div>",
                    styles: [".btn{width:100%;background-color:#fff;padding:0 10px;justify-content:left}.btn[aria-expanded=true],.btn[aria-expanded=true]:hover:not(:disabled){background-color:#fff}.dropdown-menu{min-width:100%}.btn-icon-label{margin-left:4px;color:#454545}.dropdown-toggle{white-space:unset}.dropdown-toggle::after{width:0}:host ::ng-deep .icon-misc-arrowup{color:#da1e21}:host ::ng-deep .icon-misc-arrowdown{color:#90c44b}:host ::ng-deep .icon-status-critical{color:#da1e21}:host ::ng-deep .icon-status-error-full,:host ::ng-deep .icon-status-warning{color:#f88400}:host ::ng-deep .icon-status-info{color:#0067c5}:host ::ng-deep .icon-misc-chevrondown,:host ::ng-deep .icon-misc-chevronup{color:#2d6dde}:host ::ng-deep g[id^=icon-status] #glyph{fill:#fff}"]
                }] }
    ];
    /** @nocollapse */
    NwfStatusableDropdownComponent.ctorParameters = function () { return [
        { type: StateService },
        { type: I18NextPipe }
    ]; };
    NwfStatusableDropdownComponent.propDecorators = {
        statusList: [{ type: Input }],
        stateKey: [{ type: Input }],
        evalFunction: [{ type: Input }],
        createUrl: [{ type: Input }],
        sortBy: [{ type: Input }],
        viewAllNavigation: [{ type: Input }],
        newEventsCount: [{ type: Input }],
        noOfEvents: [{ type: Input }],
        arrowUp: [{ type: Input }]
    };
    return NwfStatusableDropdownComponent;
}());
export { NwfStatusableDropdownComponent };
if (false) {
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.statusList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.stateKey;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.evalFunction;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.createUrl;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.sortBy;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.viewAllNavigation;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.newEventsCount;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.noOfEvents;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.arrowUp;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.sortedList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.hasEvents;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.dropdownList;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.highestSeverity;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.stateService;
    /** @type {?} */
    NwfStatusableDropdownComponent.prototype.i18next;
}
//# sourceMappingURL=data:application/json;base64,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