/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component } from '@angular/core';
var CellHeaderComponent = /** @class */ (function () {
    function CellHeaderComponent() {
    }
    /**
     * @param {?} dataCell
     * @param {?} order
     * @return {?}
     */
    CellHeaderComponent.prototype.sortBy = /**
     * @param {?} dataCell
     * @param {?} order
     * @return {?}
     */
    function (dataCell, order) {
        var dataField = dataCell.column.dataField;
        /** @type {?} */
        var dataGrid = dataCell.component;
        dataGrid.beginUpdate();
        dataGrid.clearSorting();
        dataGrid.columnOption(dataField, 'sortOrder', order);
        dataGrid.endUpdate();
        dataGrid.refresh();
    };
    /**
     * @param {?} data
     * @return {?}
     */
    CellHeaderComponent.prototype.filterBy = /**
     * @param {?} data
     * @return {?}
     */
    function (data) {
        data.component.nwfFilteringWidget.addCriterion(data.column);
    };
    CellHeaderComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-headercell-templates',
                    template: "<div *dxTemplate=\"let data of 'nwfHeaderCellTemplate-viewMenu'\" [attr.title]=\"data.column.caption\"\n     [attr.data-netapp-id]=\"'grid-header-cell-' + data.column.dataField\" ngbDropdown class=\"d-inline-block nwf-header-cell\"\n    container=\"body\" display=\"dynamic\" [placement]=\"data.column.alignment == 'right' ? 'bottom-right bottom-left' : 'bottom-left bottom-right'\"\n    [ngClass]=\"{ 'nwf-header-cell-left': data.column.alignment == 'left', 'nwf-header-cell-right': data.column.alignment == 'right' }\">\n    <span *ngIf=\"data.column.allowSorting || data.column.allowFiltering;else caption_without_link\" ngbDropdownToggle class=\"header-link\" id=\"{{data.column.dataField}}\" (click)=\"$event.stopPropagation()\"\n        [ngClass]=\"{ 'justify-content-center': data.column.alignment == 'center', 'justify-content-end': data.column.alignment == 'right' }\">\n        {{data.column.caption}}\n    </span>\n    \n    <div ngbDropdownMenu [attr.aria-labelledby]=\"data.column.dataField\" *ngIf=\"data.column.allowSorting || data.column.allowFiltering\">\n        <button class=\"dropdown-item\" *ngIf=\"data.column.allowSorting\" (click)=\"sortBy(data, 'asc')\">\n            <nwf-icon iconClass=\"icon-columnsort-up\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:sortAsc' | i18next}}</span>\n        </button>\n        <button class=\"dropdown-item\" *ngIf=\"data.column.allowSorting\" (click)=\"sortBy(data, 'desc')\">\n            <nwf-icon iconClass=\"icon-columnsort-down\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:sortDesc' | i18next}}</span>\n        </button>\n        <button class=\"dropdown-item\" (click)=\"filterBy(data)\" *ngIf=\"data.column.allowFiltering\">\n            <nwf-icon iconClass=\"icon-action-filter\" class=\"text-dark\"></nwf-icon><span class=\"ml-2\">{{'nwfjs:filter' | i18next}}</span>\n        </button>\n    </div>\n\n    <ng-template #caption_without_link>\n        <span id=\"{{data.column.dataField}}\" (click)=\"$event.stopPropagation()\" class=\"header\"\n        [ngClass]=\"{ 'justify-content-center': data.column.alignment == 'center', 'justify-content-end': data.column.alignment == 'right' }\">\n        {{data.column.caption}}\n    </span>\n    </ng-template>\n</div>",
                    styles: [".header-link{display:inline-flex;width:inherit;height:inherit;align-items:center}.header-link:hover{cursor:pointer;text-decoration:underline}.header{display:inline-flex;width:inherit;height:inherit;align-items:center}.nwf-header-cell{height:100%;width:100%}.nwf-header-cell.show{background:#eff4ff}.nwf-header-cell-left .header,.nwf-header-cell-left .header-link{padding-left:12px}.nwf-header-cell-right .header,.nwf-header-cell-right .header-link{padding-right:12px}::ng-deep td[role=columnheader]{padding:0!important;height:42px}::ng-deep td[role=columnheader] .dropdown-toggle::after{display:none}::ng-deep td[role=columnheader] .dx-column-indicators{height:100%;display:inline-flex;align-items:center}::ng-deep td[role=columnheader] .dx-sort-indicator{max-width:calc(100% - 27px)}::ng-deep td[role=columnheader] .dx-datagrid-text-content{width:100%;height:100%;margin:0!important}"]
                }] }
    ];
    return CellHeaderComponent;
}());
export { CellHeaderComponent };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2VsbHMtaGVhZGVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL2dyaWQvY2VsbHMvY2VsbHMtaGVhZGVyLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUUxQztJQUFBO0lBb0JBLENBQUM7Ozs7OztJQWRRLG9DQUFNOzs7OztJQUFiLFVBQWMsUUFBUSxFQUFFLEtBQXFCO1FBQ25DLElBQUEscUNBQVM7O1lBQ1gsUUFBUSxHQUFHLFFBQVEsQ0FBQyxTQUFTO1FBQ25DLFFBQVEsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUN2QixRQUFRLENBQUMsWUFBWSxFQUFFLENBQUM7UUFDeEIsUUFBUSxDQUFDLFlBQVksQ0FBQyxTQUFTLEVBQUUsV0FBVyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3JELFFBQVEsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUNyQixRQUFRLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDckIsQ0FBQzs7Ozs7SUFFTSxzQ0FBUTs7OztJQUFmLFVBQWdCLElBQUk7UUFDbEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzlELENBQUM7O2dCQWxCRixTQUFTLFNBQUM7b0JBQ1QsUUFBUSxFQUFFLCtCQUErQjtvQkFDekMsOHJFQUE0Qzs7aUJBRTdDOztJQWdCRCwwQkFBQztDQUFBLEFBcEJELElBb0JDO1NBZlksbUJBQW1CIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ253Zi1ncmlkLWhlYWRlcmNlbGwtdGVtcGxhdGVzJyxcbiAgdGVtcGxhdGVVcmw6ICcuL2NlbGxzLWhlYWRlci5jb21wb25lbnQuaHRtbCcsXG4gIHN0eWxlVXJsczogWycuL2NlbGxzLWhlYWRlci5jb21wb25lbnQuc2NzcyddLFxufSlcbmV4cG9ydCBjbGFzcyBDZWxsSGVhZGVyQ29tcG9uZW50IHtcbiAgcHVibGljIHNvcnRCeShkYXRhQ2VsbCwgb3JkZXI6ICdhc2MnIHwgJ2Rlc2MnKSB7XG4gICAgY29uc3QgeyBkYXRhRmllbGQgfSA9IGRhdGFDZWxsLmNvbHVtbjtcbiAgICBjb25zdCBkYXRhR3JpZCA9IGRhdGFDZWxsLmNvbXBvbmVudDtcbiAgICBkYXRhR3JpZC5iZWdpblVwZGF0ZSgpO1xuICAgIGRhdGFHcmlkLmNsZWFyU29ydGluZygpO1xuICAgIGRhdGFHcmlkLmNvbHVtbk9wdGlvbihkYXRhRmllbGQsICdzb3J0T3JkZXInLCBvcmRlcik7XG4gICAgZGF0YUdyaWQuZW5kVXBkYXRlKCk7XG4gICAgZGF0YUdyaWQucmVmcmVzaCgpO1xuICB9XG5cbiAgcHVibGljIGZpbHRlckJ5KGRhdGEpIHtcbiAgICBkYXRhLmNvbXBvbmVudC5ud2ZGaWx0ZXJpbmdXaWRnZXQuYWRkQ3JpdGVyaW9uKGRhdGEuY29sdW1uKTtcbiAgfVxuXG59XG4iXX0=