/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Output } from '@angular/core';
/* TODO - the 'nwf*cellTemplate' stuff should really be constants since they are shared in the../schema/schema' */
/* nwf-grid-cell-templates
 this component contains all the templates that are common across all the grids.
 Currently it contains templates for checkboxTemplate, metricCellTemplate, dateCellTemplate, statusCellTemplate, and a headerCell template for the view menu
 metric, date cellTemplates are i18n compliant.
*/
var CellsComponent = /** @class */ (function () {
    function CellsComponent() {
        // Output Event handler. This selects a row on the grid.
        this.onRowSelect = new EventEmitter();
    }
    /**
     * @param {?} data
     * @return {?}
     */
    CellsComponent.prototype.onSelect = /**
     * @param {?} data
     * @return {?}
     */
    function (data) {
        // emit the onRowSelect event containing rowData.
        // This event is handled by the consumer.
        this.onRowSelect.emit(data);
    };
    CellsComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-cell-templates',
                    template: "<div *dxTemplate=\"let cellInfo of 'nwfRadioBoxCellTemplate'\">\n    <div class=\"custom-control custom-radio\">\n        <input type=\"radio\" id=\"dx-data-grid-checkid-{{cellInfo.value}}\" data-netapp-id=\"cell-radiobtn\"\n            class=\"custom-control-input\" [value]=\"cellInfo.value\"\n            [checked]=\"cellInfo.component.isRowSelected(cellInfo.key) ? true : null\" (click)=\"onSelect(cellInfo)\">\n        <label class=\"custom-control-label\" for=\"dx-data-grid-checkid-{{cellInfo.value}}\"></label>\n    </div>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfNumberCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'number'} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDateCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | i18nextFormat : { format: 'datetime' } }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfStatusCellTemplate'\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    <nwf-icon ontapSeverity=\"true\" [severity]=\"cellInfo.value\"></nwf-icon>\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfMetricCellTemplate'\" [attr.title]=\"cellInfo.value\"\n     attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value | NwfRoundUnit : {unit: cellInfo.column.unit, statType: cellInfo.column.name} }}\n</div>\n\n<div *dxTemplate=\"let cellInfo of 'nwfDefaultCellTemplate'\" [attr.title]=\"cellInfo.value\"\n    attr.data-netapp-id=\"cell-{{cellInfo.column.dataField}}\">\n    {{cellInfo.value}}\n</div>\n"
                }] }
    ];
    /** @nocollapse */
    CellsComponent.ctorParameters = function () { return []; };
    CellsComponent.propDecorators = {
        onRowSelect: [{ type: Output }]
    };
    return CellsComponent;
}());
export { CellsComponent };
if (false) {
    /** @type {?} */
    CellsComponent.prototype.onRowSelect;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2VsbHMuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Im5nOi8vQG5ldGFwcC9ud2Zqc19hbmd1bGFyX2NvbXBvbmVudHMvIiwic291cmNlcyI6WyJsaWIvZ3JpZC9jZWxscy9jZWxscy5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsWUFBWSxFQUFFLE1BQU0sRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7OztBQVFoRTtJQU9FOztRQURpQixnQkFBVyxHQUF1QixJQUFJLFlBQVksRUFBTyxDQUFDO0lBQzNELENBQUM7Ozs7O0lBRVYsaUNBQVE7Ozs7SUFBZixVQUFnQixJQUFJO1FBQ2xCLGlEQUFpRDtRQUNqRCx5Q0FBeUM7UUFDekMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDOUIsQ0FBQzs7Z0JBYkYsU0FBUyxTQUFDO29CQUNULFFBQVEsRUFBRSx5QkFBeUI7b0JBQ25DLHdxREFBcUM7aUJBQ3RDOzs7Ozs4QkFHRSxNQUFNOztJQVFULHFCQUFDO0NBQUEsQUFkRCxJQWNDO1NBVlksY0FBYzs7O0lBRXpCLHFDQUEyRSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgRXZlbnRFbWl0dGVyLCBPdXRwdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbi8qIFRPRE8gLSB0aGUgJ253ZipjZWxsVGVtcGxhdGUnIHN0dWZmIHNob3VsZCByZWFsbHkgYmUgY29uc3RhbnRzIHNpbmNlIHRoZXkgYXJlIHNoYXJlZCBpbiB0aGUuLi9zY2hlbWEvc2NoZW1hJyAqL1xuXG4vKiBud2YtZ3JpZC1jZWxsLXRlbXBsYXRlc1xuIHRoaXMgY29tcG9uZW50IGNvbnRhaW5zIGFsbCB0aGUgdGVtcGxhdGVzIHRoYXQgYXJlIGNvbW1vbiBhY3Jvc3MgYWxsIHRoZSBncmlkcy5cbiBDdXJyZW50bHkgaXQgY29udGFpbnMgdGVtcGxhdGVzIGZvciBjaGVja2JveFRlbXBsYXRlLCBtZXRyaWNDZWxsVGVtcGxhdGUsIGRhdGVDZWxsVGVtcGxhdGUsIHN0YXR1c0NlbGxUZW1wbGF0ZSwgYW5kIGEgaGVhZGVyQ2VsbCB0ZW1wbGF0ZSBmb3IgdGhlIHZpZXcgbWVudVxuIG1ldHJpYywgZGF0ZSBjZWxsVGVtcGxhdGVzIGFyZSBpMThuIGNvbXBsaWFudC5cbiovXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdud2YtZ3JpZC1jZWxsLXRlbXBsYXRlcycsXG4gIHRlbXBsYXRlVXJsOiAnLi9jZWxscy5jb21wb25lbnQuaHRtbCcsXG59KVxuZXhwb3J0IGNsYXNzIENlbGxzQ29tcG9uZW50IHtcbiAgLy8gT3V0cHV0IEV2ZW50IGhhbmRsZXIuIFRoaXMgc2VsZWN0cyBhIHJvdyBvbiB0aGUgZ3JpZC5cbiAgQE91dHB1dCgpIHB1YmxpYyBvblJvd1NlbGVjdD86IEV2ZW50RW1pdHRlcjxhbnk+ID0gbmV3IEV2ZW50RW1pdHRlcjxhbnk+KCk7XG4gIGNvbnN0cnVjdG9yKCkgeyB9XG5cbiAgcHVibGljIG9uU2VsZWN0KGRhdGEpIHtcbiAgICAvLyBlbWl0IHRoZSBvblJvd1NlbGVjdCBldmVudCBjb250YWluaW5nIHJvd0RhdGEuXG4gICAgLy8gVGhpcyBldmVudCBpcyBoYW5kbGVkIGJ5IHRoZSBjb25zdW1lci5cbiAgICB0aGlzLm9uUm93U2VsZWN0LmVtaXQoZGF0YSk7XG4gIH1cbn1cbiJdfQ==