/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { find } from 'lodash-es';
import FilterConfig from '../filter-config';
/**
 * A filter criterion consist of filter property, operator and a value.
 * Each filter-property have a list of operators.
 * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
 * Filter property and type means same thing and are interchangeable
 */
var FilterCriterionRowComponent = /** @class */ (function () {
    function FilterCriterionRowComponent() {
        this.deleteCriterion = new EventEmitter();
        this.config = FilterConfig;
    }
    /**
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // on birth, we set the operator and value based on incoming filter property.
        this.setColumnBasedOnCriteria();
    };
    /**
     * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @param id
     */
    /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateCriterion = /**
     * \@description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @return {?}
     */
    function () {
        // updating the new criterion.
        this.setColumnBasedOnCriteria();
        // resetting the form group with default criteria.
        this.criteria.reset(this.initCriterion(this.selectedColumn));
    };
    /**
     * @param {?} change
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.updateOperator = /**
     * @param {?} change
     * @return {?}
     */
    function (change) {
        var _this = this;
        /** @type {?} */
        var selectedOperator = change.target.value;
        // If there is a default value associate with the selected operator we want to set the criteria to have that value
        /** @type {?} */
        var defaultValue = find(this.config[this.selectedColumn.dataType].options, (/**
         * @param {?} option
         * @return {?}
         */
        function (option) { return option.value === selectedOperator; })).default;
        if (defaultValue) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: defaultValue });
            // If the current value of the criteria is the same as the default value associated with the previous operator we want to clear it away
        }
        else if (this.previousOperator &&
            find(this.config[this.selectedColumn.dataType].options, (/**
             * @param {?} option
             * @return {?}
             */
            function (option) { return option.value === _this.previousOperator; })).default === this.criteria.controls.value.value) {
            this.criteria.reset({ property: this.selectedColumn.dataField, operator: selectedOperator, value: '' });
        }
        this.previousOperator = selectedOperator;
    };
    /**
     * Method to get the default filter critierion based on filter property.
     * @param property Filter property (type)
     */
    /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.initCriterion = /**
     * Method to get the default filter critierion based on filter property.
     * @private
     * @param {?} __0
     * @return {?}
     */
    function (_a) {
        var dataField = _a.dataField, dataType = _a.dataType;
        this.previousOperator = this.config[dataType].options[0].value;
        return {
            property: dataField,
            operator: this.config[dataType].options[0].value,
            value: '',
        };
    };
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     */
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    FilterCriterionRowComponent.prototype.setColumnBasedOnCriteria = /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     * @private
     * @return {?}
     */
    function () {
        var _this = this;
        // update property based on new selection.
        this.selectedColumn = this.dxColumns.filter((/**
         * @param {?} prop
         * @return {?}
         */
        function (prop) {
            return prop.dataField === _this.criteria.value.property;
        }))[0];
        // update prevoious operator based on criteria
        this.previousOperator = this.criteria.controls.operator.value;
        // updating operator list based on new filter property.
        this.propertyTypeConfig = this.config[this.selectedColumn.dataType];
    };
    FilterCriterionRowComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-criterion-row',
                    template: "<div [formGroup]=\"criteria\" class=\"d-flex mb-2 w-100\">\n\n    <!-- Property -->\n    <div class=\"filter-criterion-control mr-2\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-type\" (change)=\"updateCriterion()\"\n            formControlName=\"property\">\n            <option *ngFor=\"let dxColumn of dxColumns\" [value]=\"dxColumn.dataField\">{{dxColumn.caption}}</option>\n        </select>\n    </div>\n\n    <!-- Operator -->\n    <div class=\"filter-criterion-control mr-2\">\n        <select class=\"custom-select\" data-netapp-id=\"filter-widget-select-operator\" (change)=\"updateOperator($event)\"\n            formControlName=\"operator\">\n            <option *ngFor=\"let operator of propertyTypeConfig.options\" [value]=\"operator.value\">\n                {{operator.name | i18next}}\n            </option>\n        </select>\n    </div>\n\n    <!-- Value -->\n    <div class=\"filter-criterion-control mr-2\" [ngSwitch]=\"propertyTypeConfig.inputType\">\n        <div *ngSwitchCase=\"'text'\" class=\"align-items-center\">\n            <input type=\"text\"\n                [hidden]=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n                class=\"form-control filter-criterion-control\" required data-netapp-id=\"filter-searchText\"\n                formControlName=\"value\">\n            <div *ngIf=\"criteria.controls.operator.value === '<>' || criteria.controls.operator.value === '='\"\n                class=\"form-control\">\n                {{'nwfjs:empty' | i18next}}\n            </div>\n        </div>\n\n        <div *ngSwitchCase=\"'number'\" class=\"d-flex align-items-center\">\n            <input type=\"number\" *ngSwitchCase=\"'number'\" class=\"form-control filter-criterion-control\" required\n                data-netapp-id=\"filter-searchText\" formControlName=\"value\" step=\"any\">\n            <!-- unit -->\n            <div class=\"px-2\" *ngIf=\"selectedColumn.unit\" data-netapp-id=\"filter-widget-unit\">{{selectedColumn.unit}}\n            </div>\n        </div>\n        <select class=\"custom-select filter-criterion-control\" data-netapp-id=\"filter-widget-property-options\" required\n            formControlName=\"value\" *ngSwitchCase=\"'select'\">\n            <option [selected]=\"!criteria.value\" value>{{'nwfjs:choose' | i18next}}</option>\n            <option [selected]=\"criteria.value.value == option.id\" *ngFor=\"let option of selectedColumn.editorOptions\"\n                [value]=\"option.id\">{{option.label}}\n            </option>\n        </select>\n\n        <nwf-grid-filter-multiselect [options]=\"selectedColumn.editorOptions\" required *ngSwitchCase=\"'multiselect'\"\n            formControlName=\"value\">\n        </nwf-grid-filter-multiselect>\n\n        <nwf-grid-filter-criterion-date [operator]=\"criteria.controls.operator.value\" *ngSwitchCase=\"'dateTime'\"\n            formControlName=\"value\"></nwf-grid-filter-criterion-date>\n\n        <div *ngIf=\"criteria.invalid && (criteria.controls.value.touched || criteria.controls.value.dirty)\"\n            class=\"invalid-feedback\">\n            <span *ngSwitchCase=\"'select'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'multiselect'\">{{'nwfjs:isRequiredAtLeastOne' | i18next}}</span>\n            <span *ngSwitchCase=\"'dateTime'\">{{'nwfjs:isInvalidTimeMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'text'\">{{'nwfjs:isRequiredInvalidMessage' | i18next}}</span>\n            <span *ngSwitchCase=\"'number'\">{{'nwfjs:isNumberInvalidMessage' | i18next}}</span>\n        </div>\n    </div>\n\n    <!-- remove button -->\n    <div class=\"d-flex flex-fill justify-content-end\">\n        <button type=\"button\" class=\"btn btn-icon btn-flat btn-delete-criterion\"\n            data-netapp-id=\"filter-widget-remove-criteria-btn\"\n            (click)=\"deleteCriterion.emit();$event.stopPropagation();\">\n            <nwf-icon iconClass=\"icon-action-delete\"></nwf-icon>\n        </button>\n    </div>\n</div>",
                    styles: ["\n        .filter-criterion-control {\n            min-width: 200px;\n        }\n        .custom-select {\n            width: 200px;\n        }\n        "]
                }] }
    ];
    /** @nocollapse */
    FilterCriterionRowComponent.ctorParameters = function () { return []; };
    FilterCriterionRowComponent.propDecorators = {
        dxColumns: [{ type: Input }],
        criteria: [{ type: Input }],
        deleteCriterion: [{ type: Output }]
    };
    return FilterCriterionRowComponent;
}());
export { FilterCriterionRowComponent };
if (false) {
    /** @type {?} */
    FilterCriterionRowComponent.prototype.dxColumns;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.criteria;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.deleteCriterion;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.selectedColumn;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.propertyTypeConfig;
    /** @type {?} */
    FilterCriterionRowComponent.prototype.config;
    /**
     * Track operator changes to set default and remove defaults based on changes
     * @type {?}
     */
    FilterCriterionRowComponent.prototype.previousOperator;
}
//# sourceMappingURL=data:application/json;base64,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