/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
/** @type {?} */
var nextId = 0;
var FilterMultiselectComponent = /** @class */ (function () {
    function FilterMultiselectComponent() {
        this.id = "nwf-filter-multiselect-" + nextId++;
        this.valueModel = {};
        // the private data used within
        this._optionsIconClasses = [
            'ok',
            'warning',
            'critical',
            'error',
            'information',
        ];
        this._valDelimiter = '|';
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    FilterMultiselectComponent.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (changes.options) {
            // I need to intitalize my options
            this.setOptionIcons();
        }
    };
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param value
     */
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param {?} value
     * @return {?}
     */
    FilterMultiselectComponent.prototype.writeValue = /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param {?} value
     * @return {?}
     */
    function (value) {
        var _this = this;
        if (value) {
            // each multiselect is a string separated by a '|'. So we split the string on '|' to get individual values selected on a multiselect.
            // eg: a|b|c. This translates to a b c should be selected in multiselect widget, hence setting them to true.
            value.split(this._valDelimiter).forEach((/**
             * @param {?} iValue
             * @return {?}
             */
            function (iValue) { return _this.valueModel[iValue] = true; }));
        }
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    FilterMultiselectComponent.prototype.registerOnChange = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { this._onChange = fn; };
    /**
     * @param {?} fn
     * @return {?}
     */
    FilterMultiselectComponent.prototype.registerOnTouched = /**
     * @param {?} fn
     * @return {?}
     */
    function (fn) { };
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     */
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     * @return {?}
     */
    FilterMultiselectComponent.prototype.onValueModelChange = /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     * @return {?}
     */
    function () {
        /** @type {?} */
        var vArr = [];
        // looping over the entire object and pulling out keys that have true value
        for (var val in this.valueModel) {
            // filter out keys whose value is false.
            if (!this.valueModel[val]) {
                continue;
            }
            vArr.push(val);
        }
        // joining keys by '|' delimiter.
        this._onChange(vArr.join(this._valDelimiter));
    };
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     */
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     * @return {?}
     */
    FilterMultiselectComponent.prototype.setOptionIcons = /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     * @return {?}
     */
    function () {
        var _this = this;
        // reset model if options are set.
        this.valueModel = {};
        this.options.map((/**
         * @param {?} option
         * @return {?}
         */
        function (option) {
            /** @type {?} */
            var optionLowercase = option.id.toLowerCase();
            // setting all checkboxes as unchecked initially.
            _this.valueModel[option.id] = false;
            if (_this._optionsIconClasses.indexOf(optionLowercase) !== -1) {
                option.iconClass = optionLowercase;
            }
        }));
    };
    FilterMultiselectComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-filter-multiselect',
                    template: "\n    <div class=\"border border-secondary filter-multiselect-list w-100\">\n        <div data-netapp-id=\"filter-multiselect-list-option\" class=\"d-flex align-items-center p-1 filter-multiselect-list-option\" *ngFor=\"let option of options; let i = index\">\n            <div class=\"custom-control custom-checkbox text-nowrap mt-0\">\n                <input type=\"checkbox\" id=\"{{id}}-{{i}}\" data-netapp-id=\"filter-multiselect-list-option-checkbox\" class=\"custom-control-input p-2\" name=\"filter-multiselect-list-option-checkbox\"  [(ngModel)]=\"valueModel[option.id]\" (change)=\"onValueModelChange()\">\n                <label class=\"custom-control-label d-flex align-items-center\" for=\"{{id}}-{{i}}\">\n                    <nwf-icon ontapSeverity=\"true\" *ngIf=\"option.iconClass\" severity=\"{{option.iconClass}}\" class=\"option-icon\"></nwf-icon>\n                    <span class=\"pl-2\">{{ option.label ? option.label : option.id }}</span>\n                </label>\n            </div>\n        </div>\n    </div>\n    ",
                    providers: [{
                            provide: NG_VALUE_ACCESSOR,
                            useExisting: FilterMultiselectComponent,
                            multi: true,
                        }],
                    styles: [".filter-multiselect-list{max-height:100px;overflow-y:auto}.filter-multiselect-list-option:hover{cursor:pointer}.filter-multiselect-list-option-label{width:170px}"]
                }] }
    ];
    FilterMultiselectComponent.propDecorators = {
        options: [{ type: Input }],
        id: [{ type: Input }]
    };
    return FilterMultiselectComponent;
}());
export { FilterMultiselectComponent };
if (false) {
    /** @type {?} */
    FilterMultiselectComponent.prototype.options;
    /** @type {?} */
    FilterMultiselectComponent.prototype.id;
    /** @type {?} */
    FilterMultiselectComponent.prototype.valueModel;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._optionsIconClasses;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._onChange;
    /**
     * @type {?}
     * @private
     */
    FilterMultiselectComponent.prototype._valDelimiter;
}
//# sourceMappingURL=data:application/json;base64,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