/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { DxiDataGridColumn } from 'devextreme-angular/ui/nested/base/data-grid-column-dxi';
import { assign, get } from 'lodash-es';
var NwfGridSchemaProcessor = /** @class */ (function () {
    function NwfGridSchemaProcessor(schemaObject, schemaIdToDxColumn, customSchemaTypeToDxColumn) {
        /* First, we take the schemaIdToDxColumn and mix it over our own standard definition ,
            so we allow the user to provide us with custom schemaType to DxColumns,
            but we also handle a standard dataType provided by nwf, to make it easy.
            Note: this schemaTypeToDxColumn we have in this class is married to um's ftm.
        */
        if (schemaIdToDxColumn === void 0) { schemaIdToDxColumn = {}; }
        this.columns = [];
        this.filterableColumns = [];
        this.schemaTypeToDxColumn = {
            dateTime: NwfDateColumn,
            metric: NwfMetricColumn,
            number: NwfNumberColumn,
        };
        for (var columnId in schemaObject) {
            if (schemaObject.hasOwnProperty(columnId)) {
                /** @type {?} */
                var schemaProp = schemaObject[columnId];
                /** @type {?} */
                var hasMatchingId = columnId in schemaIdToDxColumn ? true : false;
                // updating schemaTypeToDxColumn mapping.
                this.schemaTypeToDxColumn = assign({}, this.schemaTypeToDxColumn, customSchemaTypeToDxColumn);
                /** @type {?} */
                var hasMatchingType = schemaProp.type in this.schemaTypeToDxColumn ? true : false;
                /** @type {?} */
                var dxColumnObject = void 0;
                /* First I see if the id has an associated columnId from the caller's schemaIdToDxColumn map.
                    This is because I want to allow the user to easily customize the cell based on the id.
                    for example, they tell me how to render a clusterObject. If it has a matching id, it wins over the nwf
                    mapped type.
                */
                if (hasMatchingId) {
                    dxColumnObject = new schemaIdToDxColumn[schemaProp.id](schemaProp);
                }
                else if (hasMatchingType) {
                    /* There is no matching Id, so I next try to create a column based on the schemaProp's type.
                        This is so I can best render a column's value based on the type (date, number) to a nice i18n default.
                    */
                    dxColumnObject = new this.schemaTypeToDxColumn[schemaProp.type](schemaProp);
                }
                else {
                    /* now I dont know */
                    dxColumnObject = new NwfSchemaColumn(schemaProp);
                }
                this.columns.push(dxColumnObject);
                // finding all filterable properties.
                if (schemaProp.filterable) {
                    this.filterableColumns.push(schemaProp);
                }
            }
        }
    }
    return NwfGridSchemaProcessor;
}());
export { NwfGridSchemaProcessor };
if (false) {
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.columns;
    /** @type {?} */
    NwfGridSchemaProcessor.prototype.filterableColumns;
    /**
     * @type {?}
     * @private
     */
    NwfGridSchemaProcessor.prototype.schemaTypeToDxColumn;
}
var NwfSchemaColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfSchemaColumn, _super);
    function NwfSchemaColumn(schemaProp) {
        var _this = _super.call(this) || this;
        _this.allowHeaderFiltering = false;
        _this.visible = true;
        _this.allowFiltering = true;
        _this.allowSorting = true;
        _this.allowHiding = true;
        _this.allowReordering = true;
        _this.cellTemplate = 'nwfDefaultCellTemplate';
        var id = schemaProp.id, label = schemaProp.label, type = schemaProp.type, options = schemaProp.options, visible = schemaProp.visible;
        // the dataField is how dx identifies the column, for us it is the same as the id, name is needed because that is how
        // we identify the column by name later to set options.
        _this.name = _this.dataField = id;
        // set a descriptive or friendly name for the column.
        _this.caption = label;
        // our type field is pretty close to the default dataTypes (which are just lowercased strings)
        // this can be improved if we have other types, but I bet it will work.
        _this.dataType = type.toLowerCase();
        // we allow search only for columns having 'resource','string', or associatedObjects dataType;
        _this.allowSearch = ['resource', 'string', 'associatedObjects'].indexOf(_this.dataType) !== -1;
        _this.allowFiltering = get(schemaProp, 'filterable', _this.allowFiltering);
        _this.allowSorting = get(schemaProp, 'sortable', _this.allowSorting);
        _this.allowReordering = get(schemaProp, 'allowReordering', _this.allowReordering);
        // editorOptions becomes options for 'enum-single' and 'enum-multiple' values.
        _this.editorOptions = options;
        _this.showInColumnChooser = visible;
        return _this;
    }
    return NwfSchemaColumn;
}(DxiDataGridColumn));
export { NwfSchemaColumn };
if (false) {
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHeaderFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.visible;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowFiltering;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowSorting;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowHiding;
    /** @type {?} */
    NwfSchemaColumn.prototype.allowReordering;
    /** @type {?} */
    NwfSchemaColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfSchemaColumn.prototype._optionPath;
}
var NwfNumberColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfNumberColumn, _super);
    function NwfNumberColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfNumberCellTemplate';
        return _this;
    }
    return NwfNumberColumn;
}(NwfSchemaColumn));
export { NwfNumberColumn };
if (false) {
    /** @type {?} */
    NwfNumberColumn.prototype.cellTemplate;
}
var NwfMetricColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfMetricColumn, _super);
    function NwfMetricColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfMetricCellTemplate';
        _this.unit = schemaProp.unit;
        return _this;
    }
    return NwfMetricColumn;
}(NwfSchemaColumn));
export { NwfMetricColumn };
if (false) {
    /** @type {?} */
    NwfMetricColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfMetricColumn.prototype.unit;
}
var NwfDateColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfDateColumn, _super);
    function NwfDateColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.cellTemplate = 'nwfDateCellTemplate';
        return _this;
    }
    return NwfDateColumn;
}(NwfSchemaColumn));
export { NwfDateColumn };
if (false) {
    /** @type {?} */
    NwfDateColumn.prototype.cellTemplate;
}
var NwfStatusColumn = /** @class */ (function (_super) {
    tslib_1.__extends(NwfStatusColumn, _super);
    // creating a cell template based on UX requirements.
    function NwfStatusColumn(schemaProp) {
        var _this = _super.call(this, schemaProp) || this;
        _this.alignment = 'center';
        _this.width = 80;
        _this.cellTemplate = 'nwfStatusCellTemplate';
        _this.calculateSortValue = (/**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var status = _a.status;
            // we assign 'z' to critical so that it shows as first,last when sorted alphabettically
            // for possible status values.
            if (status.toLowerCase() === 'critical') {
                status = 'z'; // Critical are always displayed at the top
            }
            return status;
        });
        return _this;
    }
    return NwfStatusColumn;
}(NwfSchemaColumn));
export { NwfStatusColumn };
if (false) {
    /** @type {?} */
    NwfStatusColumn.prototype.alignment;
    /** @type {?} */
    NwfStatusColumn.prototype.width;
    /** @type {?} */
    NwfStatusColumn.prototype.cellTemplate;
    /** @type {?} */
    NwfStatusColumn.prototype.calculateSortValue;
}
//# sourceMappingURL=data:application/json;base64,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