/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
import { DxDataGridComponent } from 'devextreme-angular';
import { Subject } from 'rxjs';
import { debounceTime, map } from 'rxjs/operators';
var SearchComponent = /** @class */ (function () {
    function SearchComponent(i18NextPipe) {
        this.i18NextPipe = i18NextPipe;
        this.keyUp = new Subject();
        this.value = '';
    }
    /**
     * @return {?}
     */
    SearchComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.type = this.i18NextPipe.transform(this.typeKey);
    };
    /**
     * @return {?}
     */
    SearchComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.dataGrid.onContentReady.subscribe((/**
         * @param {?} data
         * @return {?}
         */
        function (data) {
            /** @type {?} */
            var gridInstance = data.component.instance();
            _this.value = gridInstance.state().searchText;
            _this.setSearchOnDxGrid();
        }));
        // on keyUp, we get the value of the event,
        // wait for 3s, and then set the search on dxGridInstance.
        this.keyUp
            .pipe(map((/**
         * @param {?} event
         * @return {?}
         */
        function (event) { return event.target.value; })))
            .pipe(debounceTime(1000))
            .subscribe((/**
         * @return {?}
         */
        function () { return _this.setSearchOnDxGrid(); }));
    };
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     */
    /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    SearchComponent.prototype.resetInput = /**
     * Method to reset the input to empty, and update dxGrid instance.
     * @return {?}
     */
    function () {
        this.value = '';
        this.setSearchOnDxGrid();
    };
    /**
     * @return {?}
     */
    SearchComponent.prototype.setSearchOnDxGrid = /**
     * @return {?}
     */
    function () {
        // apply search text.
        this.dataGrid.instance.searchByText(this.value);
    };
    SearchComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-grid-search',
                    template: "\n    <label class=\"sr-only\" for=\"grid-search\"></label>\n    <div class=\"position-relative\">\n      <input\n        id=\"grid-search\"\n        #searchInput\n        class=\"form-control form-control-sm grid-search-input\"\n        type=\"text\"\n        (keyup)=\"keyUp.next($event)\"\n        [placeholder]=\"'nwfjs:searchPlaceholderText' | i18next: { type: type }\"\n        [(ngModel)]=\"value\"\n        data-netapp-id=\"grid-search\"\n        name=\"grid-search\"\n      />\n      <div class=\"search-actions h-100 d-inline-flex align-items-center pr-2\">\n        <div class=\"d-inline-flex pr-1 border-0\" [ngClass]=\"{ invisible: !value }\" (click)=\"resetInput()\">\n          <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n        </div>\n        <div class=\"d-inline-flex mag-icon\" (click)=\"searchInput.focus()\">\n          <nwf-icon iconClass=\"icon-view-search\"></nwf-icon>\n        </div>\n      </div>\n    </div>\n  ",
                    host: {
                        class: 'text-nowrap',
                    },
                    styles: [".search-actions{position:absolute;right:0;top:0;color:#2d6dde}:host .grid-search-input{padding-right:45px}:host .grid-search-input[placeholder]{text-overflow:ellipsis}"]
                }] }
    ];
    /** @nocollapse */
    SearchComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    SearchComponent.propDecorators = {
        typeKey: [{ type: Input }],
        dataGrid: [{ type: Input }]
    };
    return SearchComponent;
}());
export { SearchComponent };
if (false) {
    /** @type {?} */
    SearchComponent.prototype.typeKey;
    /** @type {?} */
    SearchComponent.prototype.dataGrid;
    /** @type {?} */
    SearchComponent.prototype.keyUp;
    /** @type {?} */
    SearchComponent.prototype.placeholderText;
    /** @type {?} */
    SearchComponent.prototype.value;
    /** @type {?} */
    SearchComponent.prototype.type;
    /**
     * @type {?}
     * @private
     */
    SearchComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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