/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { DOCUMENT } from '@angular/common';
import { Inject } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { StateService, TransitionService } from '@uirouter/core';
import { NwfConfirmationModalComponent } from '../components/modals/confirmation/confirmation-modal.component';
/**
 * @record
 */
function INwfTakeoverModalOptions() { }
if (false) {
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.style;
    /** @type {?|undefined} */
    INwfTakeoverModalOptions.prototype.confirmation;
}
var NwfTakeoverModalService = /** @class */ (function () {
    function NwfTakeoverModalService(ngbModal, stateService, document, transitionService) {
        this.ngbModal = ngbModal;
        this.stateService = stateService;
        this.document = document;
        this.transitionService = transitionService;
    }
    /**
     * @param {?} content
     * @param {?=} options
     * @return {?}
     */
    NwfTakeoverModalService.prototype.open = /**
     * @param {?} content
     * @param {?=} options
     * @return {?}
     */
    function (content, options) {
        var _this = this;
        /** @type {?} */
        var modalOptions = { style: '', confirmation: true };
        if (options) {
            modalOptions = Object.assign({}, modalOptions, options);
        }
        /** @type {?} */
        var takoverModalCls = 'nwf-takeover-modal';
        /** @type {?} */
        var contain = 'main';
        /** @type {?} */
        var fullCls = 'is-full';
        /** @type {?} */
        var doc = this.document.body;
        /** @type {?} */
        var ngbTakeoverCls = takoverModalCls;
        if (modalOptions.style == 'full') {
            ngbTakeoverCls += " " + fullCls;
        }
        doc.classList.add(takoverModalCls);
        /** @type {?} */
        var takeoverModalOptions = {
            windowClass: ngbTakeoverCls,
            backdrop: false,
            container: contain,
        };
        /** @type {?} */
        var tearDown = (/**
         * @return {?}
         */
        function () {
            doc.classList.remove(takoverModalCls);
            window.scrollTo(0, 0);
            exitTrans();
        });
        /* I only do the exit transition trap if they haven't explicitly set the option to false */
        /** @type {?} */
        var exitTrans = this.transitionService.onBefore({}, (/**
         * @param {?} trans
         * @return {?}
         */
        function (trans) {
            if (modalOptions.confirmation !== false) {
                /** @type {?} */
                var confirmModalRef = _this.ngbModal.open(NwfConfirmationModalComponent, { backdrop: 'static', container: contain, windowClass: 'nwf-confirmation-modal-dialog' });
                confirmModalRef.componentInstance.title = 'nwfjs:areYouSure';
                confirmModalRef.componentInstance.message = 'nwfjs:loseProgress';
                confirmModalRef.result
                    .then((/**
                 * @return {?}
                 */
                function () {
                    /* Go ahead and dismiss the takeover, snip the transition */
                    exitTrans();
                    modalRef.dismiss();
                    var _a = trans.to(), name = _a.name, params = _a.params;
                    _this.stateService.go(name, params);
                }))
                    .catch((/**
                 * @return {?}
                 */
                function () {
                    /* Just swallow the cancel action */
                }));
                /* Returning false, prevents the transition, this is the trap. */
                return false;
            }
            else {
                /* we have no confirmation trap, but we are transitioning out */
                modalRef.dismiss();
            }
        }));
        /** @type {?} */
        var modalRef = this.ngbModal.open(content, takeoverModalOptions);
        modalRef.result.then(tearDown).catch(tearDown);
        return modalRef;
    };
    /** @nocollapse */
    NwfTakeoverModalService.ctorParameters = function () { return [
        { type: NgbModal },
        { type: StateService },
        { type: Document, decorators: [{ type: Inject, args: [DOCUMENT,] }] },
        { type: TransitionService }
    ]; };
    return NwfTakeoverModalService;
}());
export { NwfTakeoverModalService };
if (false) {
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.ngbModal;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.stateService;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.document;
    /**
     * @type {?}
     * @private
     */
    NwfTakeoverModalService.prototype.transitionService;
}
//# sourceMappingURL=data:application/json;base64,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