/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, ElementRef, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { I18NextPipe } from 'angular-i18next';
var GlobalSearchComponent = /** @class */ (function () {
    function GlobalSearchComponent(i18nextFormat) {
        this.i18nextFormat = i18nextFormat;
        this.value = '';
        this.subjectLabel = '';
        this.focusOnSearchClick = true;
        this.change = new EventEmitter();
        this.focus = new EventEmitter();
        this.blur = new EventEmitter();
        this.enter = new EventEmitter();
        this.submit = new EventEmitter();
    }
    /**
     * Event emit on search button click.
     */
    /**
     * Event emit on search button click.
     * @return {?}
     */
    GlobalSearchComponent.prototype.onSubmit = /**
     * Event emit on search button click.
     * @return {?}
     */
    function () {
        this.submit.emit(this.value);
        if (this.focusOnSearchClick) {
            this.inputEl.nativeElement.focus();
        }
    };
    /**
     * @return {?}
     */
    GlobalSearchComponent.prototype.clear = /**
     * @return {?}
     */
    function () {
        this.value = '';
        this.change.emit(this.value);
        this.inputEl.nativeElement.focus();
    };
    /**
     * @return {?}
     */
    GlobalSearchComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.completeSubjectLabel = this.i18nextFormat.transform('nwfjs:searchPlaceholderText', { type: this.subjectLabel });
    };
    GlobalSearchComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-global-search-input',
                    template: "<div class=\"input-group\">\n  <label class=\"sr-only\" for=\"global-search\">{{completeSubjectLabel}}</label>\n  <div class=\"input-container\">\n    <input class=\"form-control py-2 border-0 nwf-global-search-input\" [(ngModel)]=\"value\" type=\"text\"\n      [placeholder]=\"completeSubjectLabel\" id=\"global-search\" autocomplete=\"off\" (input)=\"change.emit(value)\"\n      (keydown.enter)=\"enter.emit(value)\" (focus)=\"focus.emit(value)\" (blur)=\"blur.emit(value)\" #globalSearch>\n    <div class=\"row icon-container\">\n      <div [hidden]=\"!value\" class=\"border-0 close-icon\" (click)=\"clear()\">\n        <nwf-icon iconClass=\"icon-action-close\"></nwf-icon>\n      </div>\n      <div class=\"border-0\" (click)=\"onSubmit()\">\n        <nwf-icon iconClass=\"icon-view-search\"></nwf-icon>\n      </div>\n    </div>\n  </div>\n</div>\n",
                    styles: [".nwf-global-search-input{width:340px!important;color:#fff!important;background-color:#173e77!important;border-color:#173e77!important;padding-right:55px}.input-container{position:relative;width:340px!important}.icon-container{position:absolute;right:25px;top:7px;background-color:transparent;cursor:pointer;color:#fff}.close-icon{padding-right:7px}input[type=text]::-ms-clear{display:none}"]
                }] }
    ];
    /** @nocollapse */
    GlobalSearchComponent.ctorParameters = function () { return [
        { type: I18NextPipe }
    ]; };
    GlobalSearchComponent.propDecorators = {
        inputEl: [{ type: ViewChild, args: ['globalSearch', { static: false },] }],
        value: [{ type: Input }],
        subjectLabel: [{ type: Input }],
        focusOnSearchClick: [{ type: Input }],
        change: [{ type: Output }],
        focus: [{ type: Output }],
        blur: [{ type: Output }],
        enter: [{ type: Output }],
        submit: [{ type: Output }]
    };
    return GlobalSearchComponent;
}());
export { GlobalSearchComponent };
if (false) {
    /** @type {?} */
    GlobalSearchComponent.prototype.inputEl;
    /** @type {?} */
    GlobalSearchComponent.prototype.value;
    /** @type {?} */
    GlobalSearchComponent.prototype.subjectLabel;
    /** @type {?} */
    GlobalSearchComponent.prototype.focusOnSearchClick;
    /** @type {?} */
    GlobalSearchComponent.prototype.change;
    /** @type {?} */
    GlobalSearchComponent.prototype.focus;
    /** @type {?} */
    GlobalSearchComponent.prototype.blur;
    /** @type {?} */
    GlobalSearchComponent.prototype.enter;
    /** @type {?} */
    GlobalSearchComponent.prototype.submit;
    /** @type {?} */
    GlobalSearchComponent.prototype.completeSubjectLabel;
    /**
     * @type {?}
     * @private
     */
    GlobalSearchComponent.prototype.i18nextFormat;
}
//# sourceMappingURL=data:application/json;base64,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