/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Component, Input } from '@angular/core';
import { NgbCollapse } from '@ng-bootstrap/ng-bootstrap';
import { StateService } from '@uirouter/core';
var LeftnavItemComponent = /** @class */ (function () {
    function LeftnavItemComponent(stateService) {
        this.stateService = stateService;
        this.isTopLevel = false;
    }
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.toggleCollapsed = /**
     * @return {?}
     */
    function () {
        this.item.isCollapsed = !this.item.isCollapsed;
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.ngOnChanges = /**
     * @return {?}
     */
    function () {
        this.itemNtapId = "leftnav-item-" + this.item.label.toLowerCase() + "-link";
    };
    /**
     * @return {?}
     */
    LeftnavItemComponent.prototype.onClick = /**
     * @return {?}
     */
    function () {
        if (this.item.children) {
            this.toggleCollapsed();
        }
        else if (this.stateService.$current.parent.name === this.item.sref) {
            this.stateService.go('^', {}, { reload: true });
        }
        else {
            this.stateService.go(this.item.sref, this.item.srefParams);
        }
    };
    LeftnavItemComponent.decorators = [
        { type: Component, args: [{
                    selector: '[nwfLeftnavItem]',
                    template: "<!-- header has a label, no sref, and no children -->\n<div *ngIf=\"item.label && !item.sref && !item.children\" class=\"nwf-leftnav-item-header flex-grow-1\">{{item.label | i18next}}</div>\n\n<!-- item link has a label -->\n<a *ngIf=\"item.label && item.children || item.label && item.sref\" class=\"nwf-leftnav-item-link flex-grow-1\" (click)=\"onClick()\"\n    [attr.data-netapp-id]=\"itemNtapId\" \n    [ngClass]=\"{'is-active': item.isActive, 'is-toplevel': isTopLevel, 'is-open': !item.isCollapsed }\">\n    <span class=\"nwf-leftnav-item-label\">{{item.label | i18next }}</span>\n    <nwf-icon class=\"nwf-leftnav-item-toggler\" *ngIf=\"item.children && item.children.length\"\n        [iconClass]=\"item.isCollapsed ? 'icon-misc-chevrondown' : 'icon-misc-chevronup'\"></nwf-icon>\n</a>\n<!-- submenus have optional children -->\n<ul *ngIf=\"item.children && item.children.length\" class=\"nwf-leftnav-items pl-0\" [ngbCollapse]=\"item.isCollapsed\"\n    [attr.data-netapp-id]=\"'leftnav-item-group-' + item.label | lowercase\">\n    <li *ngFor=\"let child of item.children\" nwfLeftnavItem [item]=\"child\"\n        class=\"nwf-leftnav-item is-submenu d-block flex-grow-1\"\n    ></li>\n</ul>\n",
                    providers: [NgbCollapse],
                    styles: [":host{color:#fff;line-height:16px}:host:hover{color:#fff}:host[istoplevel]:first-child{border-top:1px solid #08214b}:host[istoplevel] ul{border-bottom:1px solid #08214b}.nwf-leftnav-item-header{display:flex;margin-top:30px;border-bottom:1px solid #08214b;color:#a5bfed;align-items:center;padding:8px 8px 8px 24px;text-transform:uppercase;font-size:12px;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link{display:flex;align-items:center;padding:8px 8px 8px 12px;text-transform:capitalize;font-weight:400;letter-spacing:0}.nwf-leftnav-item-link:hover{background:#7ba1e5}.nwf-leftnav-item-link:hover ::ng-deep #base-layer{fill:#fff}.nwf-leftnav-item-link.is-active{background-color:#a5bfed;color:#131313}.nwf-leftnav-item-link.is-open{border-bottom:none!important}.nwf-leftnav-item-link.is-toplevel{border-bottom:1px solid #08214b;padding:12px;border-left:4px solid transparent;letter-spacing:1px;font-weight:700;text-transform:uppercase}.nwf-leftnav-item-link.is-toplevel.is-active{color:#fff;background-color:#08214b;border-left-color:#a5bfed}.nwf-leftnav-item-link.is-toplevel.is-active:hover{background-color:#030d1d}.nwf-leftnav-item-link:not([href]){cursor:pointer}nwf-icon.nwf-leftnav-item-toggler{margin-right:12px}nwf-icon.nwf-leftnav-item-toggler ::ng-deep #base-layer{fill:#a5bfed}.nwf-leftnav-item-label{margin-left:12px;flex-grow:1}.is-submenu .nwf-leftnav-item-label{margin-left:16px}"]
                }] }
    ];
    /** @nocollapse */
    LeftnavItemComponent.ctorParameters = function () { return [
        { type: StateService }
    ]; };
    LeftnavItemComponent.propDecorators = {
        item: [{ type: Input }],
        isTopLevel: [{ type: Input }]
    };
    return LeftnavItemComponent;
}());
export { LeftnavItemComponent };
if (false) {
    /** @type {?} */
    LeftnavItemComponent.prototype.item;
    /** @type {?} */
    LeftnavItemComponent.prototype.isTopLevel;
    /** @type {?} */
    LeftnavItemComponent.prototype.itemNtapId;
    /**
     * @type {?}
     * @private
     */
    LeftnavItemComponent.prototype.stateService;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGVmdG5hdi1pdGVtLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL0BuZXRhcHAvbndmanNfYW5ndWxhcl9jb21wb25lbnRzLyIsInNvdXJjZXMiOlsibGliL3NoZWxsL2xlZnRuYXYvbGVmdG5hdi1pdGVtLmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQWEsTUFBTSxlQUFlLENBQUM7QUFDNUQsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBQ3pELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUU5QztJQVdFLDhCQUFvQixZQUEwQjtRQUExQixpQkFBWSxHQUFaLFlBQVksQ0FBYztRQUg5QixlQUFVLEdBQVksS0FBSyxDQUFDO0lBR0ssQ0FBQzs7OztJQUUzQyw4Q0FBZTs7O0lBQXRCO1FBQ0UsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUNqRCxDQUFDOzs7O0lBRU0sMENBQVc7OztJQUFsQjtRQUNFLElBQUksQ0FBQyxVQUFVLEdBQUcsa0JBQWdCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsRUFBRSxVQUFPLENBQUM7SUFDekUsQ0FBQzs7OztJQUVNLHNDQUFPOzs7SUFBZDtRQUNFLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDdEIsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1NBQ3hCO2FBQU0sSUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFO1lBQ3BFLElBQUksQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUNqRDthQUFNO1lBQ0wsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztTQUM1RDtJQUNILENBQUM7O2dCQTdCRixTQUFTLFNBQUM7b0JBQ1QsUUFBUSxFQUFFLGtCQUFrQjtvQkFDNUIsOHJDQUE0QztvQkFFNUMsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDOztpQkFDekI7Ozs7Z0JBUFEsWUFBWTs7O3VCQVNsQixLQUFLOzZCQUNMLEtBQUs7O0lBc0JSLDJCQUFDO0NBQUEsQUE5QkQsSUE4QkM7U0F4Qlksb0JBQW9COzs7SUFDL0Isb0NBQTBCOztJQUMxQiwwQ0FBNEM7O0lBQzVDLDBDQUEwQjs7Ozs7SUFFZCw0Q0FBa0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIElucHV0LCBPbkNoYW5nZXMgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE5nYkNvbGxhcHNlIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuaW1wb3J0IHsgU3RhdGVTZXJ2aWNlIH0gZnJvbSAnQHVpcm91dGVyL2NvcmUnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdbbndmTGVmdG5hdkl0ZW1dJyxcbiAgdGVtcGxhdGVVcmw6ICcuL2xlZnRuYXYtaXRlbS5jb21wb25lbnQuaHRtbCcsXG4gIHN0eWxlVXJsczogWycuL2xlZnRuYXYtaXRlbS5zY3NzJ10sXG4gIHByb3ZpZGVyczogW05nYkNvbGxhcHNlXSxcbn0pXG5leHBvcnQgY2xhc3MgTGVmdG5hdkl0ZW1Db21wb25lbnQgaW1wbGVtZW50cyBPbkNoYW5nZXMge1xuICBASW5wdXQoKSBwdWJsaWMgaXRlbTogYW55O1xuICBASW5wdXQoKSBwdWJsaWMgaXNUb3BMZXZlbDogYm9vbGVhbiA9IGZhbHNlO1xuICBwdWJsaWMgaXRlbU50YXBJZDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgc3RhdGVTZXJ2aWNlOiBTdGF0ZVNlcnZpY2UpIHt9XG5cbiAgcHVibGljIHRvZ2dsZUNvbGxhcHNlZCgpIHtcbiAgICB0aGlzLml0ZW0uaXNDb2xsYXBzZWQgPSAhdGhpcy5pdGVtLmlzQ29sbGFwc2VkO1xuICB9XG5cbiAgcHVibGljIG5nT25DaGFuZ2VzKCkge1xuICAgIHRoaXMuaXRlbU50YXBJZCA9IGBsZWZ0bmF2LWl0ZW0tJHt0aGlzLml0ZW0ubGFiZWwudG9Mb3dlckNhc2UoKX0tbGlua2A7XG4gIH1cblxuICBwdWJsaWMgb25DbGljaygpIHtcbiAgICBpZiAodGhpcy5pdGVtLmNoaWxkcmVuKSB7XG4gICAgICB0aGlzLnRvZ2dsZUNvbGxhcHNlZCgpO1xuICAgIH0gZWxzZSBpZiAodGhpcy5zdGF0ZVNlcnZpY2UuJGN1cnJlbnQucGFyZW50Lm5hbWUgPT09IHRoaXMuaXRlbS5zcmVmKSB7XG4gICAgICB0aGlzLnN0YXRlU2VydmljZS5nbygnXicsIHt9LCB7IHJlbG9hZDogdHJ1ZSB9KTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5zdGF0ZVNlcnZpY2UuZ28odGhpcy5pdGVtLnNyZWYsIHRoaXMuaXRlbS5zcmVmUGFyYW1zKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==