/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { Component, Inject, Input } from '@angular/core';
import { StateService, TargetState } from '@uirouter/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { I18NextPipe } from 'angular-i18next';
import { repeat } from 'lodash-es';
import { interval } from 'rxjs';
import { map } from 'rxjs/operators';
import { NwfConfirmationModalComponent } from '../../components/modals/confirmation/confirmation-modal.component';
import { NwfTitleService } from '../title/title.service';
var LoginComponent = /** @class */ (function () {
    function LoginComponent(NwfAuthService, $state, modalService, titleService, i18NextPipe) {
        var _this = this;
        this.NwfAuthService = NwfAuthService;
        this.$state = $state;
        this.modalService = modalService;
        this.titleService = titleService;
        this.i18NextPipe = i18NextPipe;
        this.showHelp = true;
        this.authToken = null;
        this.resetUsername = null;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        // Forgot Password is off by default and enabled when I have provided it
        this.hasForgotPassword = false;
        this.hasResetPassword = false;
        this.forgotPasswordMode = false;
        // Reset Password
        this.resetPasswordMode = false;
        this.resetPasswordMatch = true;
        this.cnter = 0;
        this.loadingObs = interval(1000).pipe(map((/**
         * @param {?} value
         * @return {?}
         */
        function (value) {
            _this.cnter++;
            if (_this.cnter > 3) {
                _this.cnter = 0;
            }
            return repeat('.', _this.cnter);
        })));
        this.creds = { username: '', password: '' };
        this.resetCreds = { username: '', newPassword: '', confirmNewPassword: '', authToken: '' };
        this.forgotCreds = { username: '' };
        /* I detect the presence of a forgotPassword and resetPassword methods in the strategy */
        if (NwfAuthService.forgotPassword) {
            this.hasForgotPassword = true;
        }
        if (NwfAuthService.resetPassword) {
            this.hasResetPassword = true;
        }
        this.titleService.setTitle('nwfjs:login');
    }
    /**
     * @return {?}
     */
    LoginComponent.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        // If the server sends a user and authToken, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        if (this.hasResetPassword && this.resetUsername !== null && this.authToken !== null) {
            this.resetPasswordMode = true;
            this.forgotPasswordMode = false;
            this.resetCreds.authToken = this.authToken;
            this.resetCreds.username = this.resetUsername;
        }
        this.updateHrefs();
    };
    /**
     * @return {?}
     */
    LoginComponent.prototype.authenticate = /**
     * @return {?}
     */
    function () {
        var _this = this;
        this.inFlight = true;
        /** @type {?} */
        var returnToOriginalState = (/**
         * @return {?}
         */
        function () {
            /** @type {?} */
            var state = _this.returnTo.state();
            /** @type {?} */
            var params = _this.returnTo.params();
            /** @type {?} */
            var options = tslib_1.__assign({}, _this.returnTo.options(), { reload: true });
            _this.$state.go(state, params, options);
        });
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            _this.inFlight = false;
            /** @type {?} */
            var errorCode = error.status;
            /** @type {?} */
            var failedModal = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = _this.i18NextPipe.transform('nwfjs:error');
            if (errorCode !== 0) {
                failedModal.message = _this.i18NextPipe.transform('nwfjs:loginFailedAuthenticationFailed');
            }
            else {
                failedModal.message = _this.i18NextPipe.transform('nwfjs:loginFailedUnableAccessServer');
            }
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        var _a = this.creds, username = _a.username, password = _a.password;
        this.NwfAuthService.authenticate(username, password)
            .then(returnToOriginalState)
            .catch(showError)
            .then();
    };
    /*
    responsible for having the right links and determining if this is vendorized or not
    */
    /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    LoginComponent.prototype.updateHrefs = /*
        responsible for having the right links and determining if this is vendorized or not
        */
    /**
     * @return {?}
     */
    function () {
        /** @type {?} */
        var netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    };
    // forgot password on submit.
    // forgot password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.forgotPasswordSubmit = 
    // forgot password on submit.
    /**
     * @return {?}
     */
    function () {
        var _this = this;
        var username = this.forgotCreds.username;
        this.inFlight = true;
        /** @type {?} */
        var showConfirm = (/**
         * @return {?}
         */
        function () {
            _this.inFlight = false;
            /** @type {?} */
            var confirmModalInstance = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            confirmModalInstance.title = _this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = _this.i18NextPipe.transform('nwfjs:loginForgetPasswordResetEmailSent', { username: username });
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        this.NwfAuthService.forgotPassword(username)
            .then(showConfirm)
            .then(stop, stop);
    };
    // Reset password on submit.
    // Reset password on submit.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordSubmit = 
    // Reset password on submit.
    /**
     * @return {?}
     */
    function () {
        var _this = this;
        // Check if passwords match
        this.resetPasswordMatch = true;
        if (this.resetCreds.newPassword !== this.resetCreds.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        this.inFlight = true;
        /** @type {?} */
        var showConfirm = (/**
         * @return {?}
         */
        function () {
            _this.inFlight = false;
            /** @type {?} */
            var resetPasswordConformationModelRef = _this.modalService.open(NwfConfirmationModalComponent);
            resetPasswordConformationModelRef.result.then((/**
             * @return {?}
             */
            function () {
                // after user clicks ok, redirect to home page
                window.location.replace('/');
            }));
            /** @type {?} */
            var confirmModalInstance = resetPasswordConformationModelRef.componentInstance;
            confirmModalInstance.title = _this.i18NextPipe.transform('nwfjs:info');
            confirmModalInstance.message = _this.i18NextPipe.transform('nwfjs:resetPasswordSucceed');
            confirmModalInstance.showCancel = false;
            confirmModalInstance.status = 'info';
        });
        /** @type {?} */
        var showError = (/**
         * @param {?} error
         * @return {?}
         */
        function (error) {
            _this.inFlight = false;
            /** @type {?} */
            var failedModal = _this.modalService.open(NwfConfirmationModalComponent).componentInstance;
            failedModal.title = _this.i18NextPipe.transform('nwfjs:error');
            failedModal.message = _this.i18NextPipe.transform('nwfjs:resetPasswordFailed');
            failedModal.showCancel = false;
            failedModal.status = 'error';
        });
        var _a = this.resetCreds, username = _a.username, newPassword = _a.newPassword;
        this.NwfAuthService.resetPassword(username, newPassword, this.authToken)
            .then(showConfirm)
            .catch(showError)
            .then(stop, stop);
    };
    // Reset password on cancel.
    // Reset password on cancel.
    /**
     * @return {?}
     */
    LoginComponent.prototype.resetPasswordCancelFn = 
    // Reset password on cancel.
    /**
     * @return {?}
     */
    function () {
        window.location.href = document.location.origin;
    };
    /**
     * @return {?}
     */
    LoginComponent.prototype.forgotPasswordClick = /**
     * @return {?}
     */
    function () {
        this.forgotPasswordMode = !this.forgotPasswordMode;
        this.forgotCreds.username = this.creds.username;
    };
    LoginComponent.decorators = [
        { type: Component, args: [{
                    selector: 'nwf-login',
                    template: "<div class=\"nwf-login-overlay\">\n    <div class=\"nwf-login-dialog\">\n    <header class=\"nwf-login-banner-logo\"></header>\n    <div class=\"nwf-login-body\">\n        <h2 class=\"nwf-login-dialog-title-primary\">{{appTitle}}</h2>\n        <h3 class=\"nwf-login-dialog-title-secondary\"></h3>\n        <h5>{{message}}</h5>\n        <!-- Login form -->\n        <form #authForm=\"ngForm\" (ngSubmit)=\"authForm.valid && authenticate()\" *ngIf=\"!forgotPasswordMode && !resetPasswordMode\"\n            id=\"nwf-login-form\" class=\"nwf-validatable\" [ngClass]=\"{'ng-submitted': authForm.submitted }\">\n            <div class=\"form-group l-username\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"creds.username\"\n                       [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" autofocus required placeholder=\"{{'nwfjs:username' | i18next}}\">\n                    <div *ngIf=\"username.invalid && (authForm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" type=\"password\" name=\"password\" #password=\"ngModel\" [(ngModel)]=\"creds.password\"\n                        [attr.readonly]=\"inFlight || null\" data-netapp-id=\"loginPage-password-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:password' | i18next}}\"\n                        required>\n                    <div *ngIf=\"password.invalid && (authForm.submitted || password.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next}}\n                    </div>\n            </div>\n            <div class=\"form-group l-submit-btn mb-0\">\n                <button [attr.type]=\"inFlight ? 'button': 'submit'\" class=\"nwf-login-input btn btn-primary btn-lg position-relative d-inline-block\"\n                    data-netapp-id=\"loginPage-signIn-button\">\n                    <div>{{'nwfjs:signIn' | i18next}} <span class=\"loading position-absolute\" [hidden]=\"!inFlight\">{{loadingObs | async}}</span></div>\n                </button>\n            </div>\n            <p *ngIf=\"hasForgotPassword\" class=\"nwf-login-forgot\">\n                <a class=\"nwf-is-link-like\" (click)=\"forgotPasswordClick()\" data-netapp-id=\"loginPage-forgot-password-link\">{{'nwfjs:forgetPassword' | i18next}}</a>\n            </p>\n        </form>\n\n        <!-- Forgot Password Form -->\n        <form #forgotFrm=\"ngForm\" class=\"nwf-validatable\" *ngIf=\"forgotPasswordMode\" (ngSubmit)=\"forgotFrm.valid && forgotPasswordSubmit()\" [ngClass]=\"{'ng-submitted': forgotFrm.submitted }\">\n\n            <div class=\"nwf-forgot-password-title-panel\">\n                <div class=\"nwf-forgot-password-text\" data-netapp-id=\"loginPage-forgot-password-text\">\n                    <h4>{{'nwfjs:enterResetUsername' | i18next}}</h4>\n                </div>\n            </div>\n            <div class=\"form-group\">\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" [(ngModel)]=\"forgotCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" autocomplete=\"off\" placeholder=\"{{'nwfjs:usernameToReset' | i18next}}\"\n                        required>\n                    <div *ngIf=\"username.invalid && (forgotFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n            </div>\n            <div class=\"form-group\">\n            <!-- Submit/Cancel for Forgot Password  -->\n            <div class=\"nwf-login-row\">\n                <div class=\"nwf-login-button-panel\">\n                    <button class=\"btn btn-primary mr-2\" data-netapp-id=\"forgotPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                    <button class=\"btn btn-secondary\" (click)=\"forgotPasswordMode = false\" data-netapp-id=\"forgotPassword-cancel-button\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n                </div>\n            </div>\n            </div>\n        </form>\n\n        <!-- Reset password Form -->\n        <form #resetFrm=\"ngForm\"  *ngIf=\"resetPasswordMode\" (ngSubmit)=\"resetFrm.valid && resetPasswordSubmit()\" [ngClass]=\"{'ng-submitted': resetFrm.submitted }\">\n\n            <dl>\n                <dt>{{'nwfjs:currentUsername' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" name=\"username\" #username=\"ngModel\" autocomplete=\"off\" [(ngModel)]=\"resetCreds.username\"\n                        data-netapp-id=\"loginPage-username-input\" title=\"{{'nwfjs:usernameCannotChange' | i18next}}\" required disabled=\"true\">\n                    <div *ngIf=\"username.invalid && (resetFrm.submitted || username.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:newPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"newPassword\" #newPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.newPassword\" data-netapp-id=\"loginPage-new-password-input\" placeholder=\"{{'nwfjs:typeNewPassword' | i18next}}\" required>\n                    <div *ngIf=\"newPassword.invalid && (resetFrm.submitted || newPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                </dd>\n                <dt>{{'nwfjs:confirmNewPassword' | i18next}}</dt>\n                <dd>\n                    <input class=\"nwf-login-input form-control form-control-lg\" autocomplete=\"off\" name=\"confirmNewPassword\" #confirmNewPassword=\"ngModel\"\n                        type=\"password\" [(ngModel)]=\"resetCreds.confirmNewPassword\" name=\"confirmNewPassword\" data-netapp-id=\"loginPage-confirm-new-password-input\"\n                        placeholder=\"{{'nwfjs:typeNewPasswordAgain' | i18next}}\" required>\n                    <div *ngIf=\"confirmNewPassword.invalid && (resetFrm.submitted || confirmNewPassword.touched)\" class=\"invalid-feedback\">\n                        {{ 'nwfjs:emptyMessage' | i18next }}\n                    </div>\n                    <div *ngIf=\"!resetPasswordMatch\" class=\"invalid-feedback\">\n                        {{'nwfjs:changePasswordNotMatch' | i18next}}\n                    </div>\n                </dd>\n            </dl>\n\n            <div class=\"nwf-login-button-panel\">\n                <button class=\"btn btn-primary mr-2\" data-netapp-id=\"resetPassword-submit-button\">{{'nwfjs:submit' | i18next}}</button>\n                <button class=\"btn btn-secondary\" data-netapp-id=\"resetPassword-cancel-button\" (click)=\"resetPasswordCancelFn()\" type=\"button\">{{'nwfjs:cancel' | i18next}}</button>\n            </div>\n        </form>\n    </div>\n    <footer class=\"nwf-login-links\">\n        <!-- support -->\n        <a *ngIf=\"!isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{'nwfjs:netappSupport' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"supportHref\" target=\"_blank\" data-netapp-id=\"support-link\">{{supportLabel}}</a>\n        <span *ngIf=\"showHelp\">&nbsp;|&nbsp;</span>\n        <!-- help -->\n        <a *ngIf=\"showHelp\" nwf-help showIcon=\"false\" class=\"nwf-is-link-like\" data-netapp-id=\"help-link\">{{'nwfjs:help' | i18next}}</a>\n        <!-- home -->\n        &nbsp;|&nbsp;\n        <a *ngIf=\"!isOemVendor\" href=\"http://netapp.com\" target=\"_blank\" data-netapp-id=\"home-link\">{{'nwfjs:netapp' | i18next}}</a>\n        <a *ngIf=\"isOemVendor\" [href]=\"homeHref\" target=\"_blank\"  data-netapp-id=\"home-link\">{{homeLabel}}</a>\n    </footer>\n    </div>\n</div>",
                    styles: ["nwf-login{width:100%;height:100%;top:0;background-repeat:no-repeat;background-size:cover;display:flex;justify-content:center;align-items:flex-start}.nwf-login-dialog{padding:40px 40px 25px}.l-username{margin-top:2rem}.l-submit-btn{margin-top:2.5rem}h2{font-size:26px;color:#131313}#nwf-login-form[ng-reflect-klass]{margin-top:20px}#nwf-login-form[ng-reflect-klass] dd{margin-bottom:1.2rem}.nwf-login-banner-logo{background-image:url(data:image/png;base64,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);width:100%;background-repeat:no-repeat;height:24px;align-self:flex-start;margin-bottom:10px}.nwf-login-dialog-title-primary{font-size:24px;margin-top:0;margin-bottom:10px}.nwf-login-input{width:100%;margin:5px 0}.nwf-login-forgot{margin:5px 0;align-self:flex-end}.nwf-login-links{margin-top:10px;text-align:center}.nwf-login-overlay{width:100%;position:fixed;left:0;top:0;z-index:1049;height:100%}.nwf-login-button-panel{display:block;text-align:right}"]
                }] }
    ];
    /** @nocollapse */
    LoginComponent.ctorParameters = function () { return [
        { type: undefined, decorators: [{ type: Inject, args: ['NwfAuthService',] }] },
        { type: StateService },
        { type: NgbModal },
        { type: NwfTitleService },
        { type: I18NextPipe }
    ]; };
    LoginComponent.propDecorators = {
        returnTo: [{ type: Input }],
        appTitle: [{ type: Input }],
        supportHref: [{ type: Input }],
        supportLabel: [{ type: Input }],
        helpHref: [{ type: Input }],
        helpLabel: [{ type: Input }],
        homeHref: [{ type: Input }],
        homeLabel: [{ type: Input }],
        showHelp: [{ type: Input }],
        authToken: [{ type: Input }],
        resetUsername: [{ type: Input }]
    };
    return LoginComponent;
}());
export { LoginComponent };
if (false) {
    /** @type {?} */
    LoginComponent.prototype.returnTo;
    /** @type {?} */
    LoginComponent.prototype.appTitle;
    /** @type {?} */
    LoginComponent.prototype.supportHref;
    /** @type {?} */
    LoginComponent.prototype.supportLabel;
    /** @type {?} */
    LoginComponent.prototype.helpHref;
    /** @type {?} */
    LoginComponent.prototype.helpLabel;
    /** @type {?} */
    LoginComponent.prototype.homeHref;
    /** @type {?} */
    LoginComponent.prototype.homeLabel;
    /** @type {?} */
    LoginComponent.prototype.showHelp;
    /** @type {?} */
    LoginComponent.prototype.authToken;
    /** @type {?} */
    LoginComponent.prototype.resetUsername;
    /** @type {?} */
    LoginComponent.prototype.isOemVendor;
    /** @type {?} */
    LoginComponent.prototype.homeVendorHref;
    /** @type {?} */
    LoginComponent.prototype.titleElement;
    /** @type {?} */
    LoginComponent.prototype.username;
    /** @type {?} */
    LoginComponent.prototype.password;
    /** @type {?} */
    LoginComponent.prototype.hasForgotPassword;
    /** @type {?} */
    LoginComponent.prototype.hasResetPassword;
    /** @type {?} */
    LoginComponent.prototype.forgotPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.newPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmPassword;
    /** @type {?} */
    LoginComponent.prototype.confirmNewPassword;
    /** @type {?} */
    LoginComponent.prototype.message;
    /** @type {?} */
    LoginComponent.prototype.success;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMode;
    /** @type {?} */
    LoginComponent.prototype.resetPasswordMatch;
    /** @type {?} */
    LoginComponent.prototype.cnter;
    /** @type {?} */
    LoginComponent.prototype.loadingObs;
    /** @type {?} */
    LoginComponent.prototype.errorCode;
    /** @type {?} */
    LoginComponent.prototype.inFlight;
    /** @type {?} */
    LoginComponent.prototype.creds;
    /** @type {?} */
    LoginComponent.prototype.resetCreds;
    /** @type {?} */
    LoginComponent.prototype.forgotCreds;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.NwfAuthService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.$state;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.modalService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.titleService;
    /**
     * @type {?}
     * @private
     */
    LoginComponent.prototype.i18NextPipe;
}
//# sourceMappingURL=data:application/json;base64,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