/**
 * Creates a small alerts notifications on the page to provide feedback messages.
 * @param type - success | info | warning | error
 * @param dismissable - true | false
 *
 * @returns void
 *
 * The color of the alert should be set according to the type and dismissable is false by default.
 * @remarks Link to Scaffolding example - http://web.rtp.netapp.com/~peters1/nwfjs_scaffolding/#/components/alert
 */
import { EventEmitter, OnChanges } from '@angular/core';
export declare class AlertComponent implements OnChanges {
    type: 'success' | 'info' | 'warning' | 'error' | 'critical';
    dismissable: boolean;
    level: string;
    close: EventEmitter<void>;
    constructor();
    onClose(): void;
    ngOnChanges(changes: any): void;
}
